/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.methods;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static int getMandatoryInt(JsonObject object, String memberName) {
        Integer integer = JsonUtils.getInt(object, memberName);
        JsonUtils.checkMandatoryValue(integer, memberName);
        return integer;
    }

    public static Integer getInt(JsonObject object, String memberName) {
        JsonPrimitive primitive = JsonUtils.getPrimitiveChecked(object, memberName);
        return primitive == null ? null : Integer.valueOf(primitive.getAsInt());
    }

    public static long getMandatoryLong(JsonObject object, String memberName) {
        Long l = JsonUtils.getLong(object, memberName);
        JsonUtils.checkMandatoryValue(l, memberName);
        return l;
    }

    public static Long getLong(JsonObject object, String memberName) {
        JsonPrimitive primitive = JsonUtils.getPrimitiveChecked(object, memberName);
        return primitive == null ? null : Long.valueOf(primitive.getAsLong());
    }

    public static boolean getMandatoryBoolean(JsonObject object, String memberName) {
        Boolean bool = JsonUtils.getBoolean(object, memberName);
        JsonUtils.checkMandatoryValue(bool, memberName);
        return bool;
    }

    public static Boolean getBoolean(JsonObject object, String memberName) {
        JsonPrimitive primitive = JsonUtils.getPrimitiveChecked(object, memberName);
        return primitive == null ? null : Boolean.valueOf(primitive.getAsBoolean());
    }

    public static String getMandatoryString(JsonObject object, String memberName) {
        String string = JsonUtils.getString(object, memberName);
        JsonUtils.checkMandatoryValue(string, memberName);
        return string;
    }

    public static String getString(JsonObject object, String memberName) {
        JsonPrimitive primitive = JsonUtils.getPrimitiveChecked(object, memberName);
        return primitive == null ? null : primitive.getAsString();
    }

    public static BigDecimal getMandatoryBigDecimal(JsonObject object, String memberName) {
        BigDecimal bigDecimal = JsonUtils.getBigDecimal(object, memberName);
        JsonUtils.checkMandatoryValue(bigDecimal, memberName);
        return bigDecimal;
    }

    public static BigDecimal getBigDecimal(JsonObject object, String memberName) {
        JsonPrimitive primitive = JsonUtils.getPrimitiveChecked(object, memberName);
        return primitive == null ? null : primitive.getAsBigDecimal();
    }

    public static DateTime getMandatoryDateTime(JsonObject object, String memberName) {
        DateTime dateTime = JsonUtils.getDateTime(object, memberName);
        JsonUtils.checkMandatoryValue(dateTime, memberName);
        return dateTime;
    }

    public static DateTime getDateTime(JsonObject object, String memberName) {
        JsonPrimitive primitive = JsonUtils.getPrimitiveChecked(object, memberName);
        return primitive == null ? null : DateTime.parse((String)primitive.getAsString(), (DateTimeFormatter)ISODateTimeFormat.dateTimeParser().withOffsetParsed());
    }

    public static Map<String, String> map(JsonObject object) {
        JsonUtils.checkObject(object);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : object.entrySet()) {
            String value = null;
            if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                value = ((JsonElement)entry.getValue()).getAsString();
            }
            result.put((String)entry.getKey(), value);
        }
        return result;
    }

    private static JsonPrimitive getPrimitiveChecked(JsonObject object, String memberName) {
        JsonUtils.checkParameters(object, memberName);
        return object.getAsJsonPrimitive(memberName);
    }

    private static void checkParameters(JsonObject object, String memberName) {
        JsonUtils.checkObject(object);
        JsonUtils.checkMemberName(memberName);
    }

    private static void checkObject(JsonObject object) {
        if (object == null) {
            throw new NullPointerException("JSON object is null.");
        }
    }

    private static void checkMemberName(String memberName) {
        if (memberName == null) {
            throw new NullPointerException("Member name is null.");
        }
        if (memberName.length() == 0) {
            throw new IllegalArgumentException("Member is an empty string.");
        }
    }

    private static void checkMandatoryValue(Object value, String memberName) {
        if (value == null) {
            throw new NullPointerException("mandatory value '" + memberName + "' is null");
        }
    }
}

