/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.methods;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.yandex.money.api.methods.JsonUtils;
import com.yandex.money.api.model.Error;
import com.yandex.money.api.model.Operation;
import com.yandex.money.api.net.HostsProvider;
import com.yandex.money.api.net.MethodRequest;
import com.yandex.money.api.net.MethodResponse;
import com.yandex.money.api.net.PostRequestBodyBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;

public class OperationDetails
implements MethodResponse {
    private final Error error;
    private final Operation operation;

    public OperationDetails(Error error, Operation operation) {
        this.error = error;
        this.operation = operation;
    }

    public String toString() {
        return "OperationDetails{error=" + (Object)((Object)this.error) + ", operation=" + this.operation + '}';
    }

    public Error getError() {
        return this.error;
    }

    public Operation getOperation() {
        return this.operation;
    }

    private static final class Deserializer
    implements JsonDeserializer<OperationDetails> {
        private Deserializer() {
        }

        public OperationDetails deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            return new OperationDetails(Error.parse(JsonUtils.getString(object, "error")), Operation.createFromJson(json));
        }
    }

    public static class Request
    implements MethodRequest<OperationDetails> {
        private final String operationId;

        public Request(String operationId) {
            if (operationId == null || operationId.isEmpty()) {
                throw new IllegalArgumentException("operationId is null or empty");
            }
            this.operationId = operationId;
        }

        @Override
        public URL requestURL(HostsProvider hostsProvider) throws MalformedURLException {
            return new URL(hostsProvider.getMoneyApi() + "/operation-details");
        }

        @Override
        public OperationDetails parseResponse(InputStream inputStream) {
            return (OperationDetails)Request.buildGson().fromJson((Reader)new InputStreamReader(inputStream), OperationDetails.class);
        }

        @Override
        public PostRequestBodyBuffer buildParameters() throws IOException {
            return new PostRequestBodyBuffer().addParam("operation_id", this.operationId);
        }

        private static Gson buildGson() {
            return new GsonBuilder().registerTypeAdapter(OperationDetails.class, (Object)new Deserializer()).create();
        }
    }
}

