/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.methods;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.yandex.money.api.methods.BaseProcessPayment;
import com.yandex.money.api.methods.JsonUtils;
import com.yandex.money.api.model.Error;
import com.yandex.money.api.model.ExternalCard;
import com.yandex.money.api.net.HostsProvider;
import com.yandex.money.api.net.MethodRequest;
import com.yandex.money.api.net.PostRequestBodyBuffer;
import com.yandex.money.api.utils.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class ProcessExternalPayment
extends BaseProcessPayment {
    private final ExternalCard moneySource;
    private final String invoiceId;

    public ProcessExternalPayment(BaseProcessPayment.Status status, Error error, String acsUri, Map<String, String> acsParams, ExternalCard moneySource, Long nextRetry, String invoiceId) {
        super(status, error, acsUri, acsParams, nextRetry);
        this.moneySource = moneySource;
        this.invoiceId = invoiceId;
    }

    public String toString() {
        return "ProcessExternalPayment{status=" + (Object)((Object)this.getStatus()) + ", error=" + (Object)((Object)this.getError()) + ", acsUri='" + this.getAcsUri() + '\'' + ", acsParams=" + this.getAcsParams() + ", nextRetry=" + this.getNextRetry() + ", moneySource=" + this.moneySource + ", invoiceId='" + this.invoiceId + '\'' + '}';
    }

    public ExternalCard getMoneySource() {
        return this.moneySource;
    }

    public String getInvoiceId() {
        return this.invoiceId;
    }

    public static class Request
    implements MethodRequest<ProcessExternalPayment> {
        private final String instanceId;
        private final String requestId;
        private final String extAuthSuccessUri;
        private final String extAuthFailUri;
        private final boolean requestToken;
        private final ExternalCard externalCard;
        private final String csc;

        public Request(String instanceId, String requestId, String extAuthSuccessUri, String extAuthFailUri, boolean requestToken) {
            this(instanceId, requestId, extAuthSuccessUri, extAuthFailUri, requestToken, null, null);
        }

        public Request(String instanceId, String requestId, String extAuthSuccessUri, String extAuthFailUri, ExternalCard externalCard, String csc) {
            this(instanceId, requestId, extAuthSuccessUri, extAuthFailUri, false, externalCard, csc);
        }

        private Request(String instanceId, String requestId, String extAuthSuccessUri, String extAuthFailUri, boolean requestToken, ExternalCard externalCard, String csc) {
            if (Strings.isNullOrEmpty(instanceId)) {
                throw new IllegalArgumentException("instanceId is null or empty");
            }
            this.instanceId = instanceId;
            if (Strings.isNullOrEmpty(requestId)) {
                throw new IllegalArgumentException("requestId is null or empty");
            }
            this.requestId = requestId;
            if (Strings.isNullOrEmpty(extAuthSuccessUri)) {
                throw new IllegalArgumentException("extAuthSuccessUri is null or empty");
            }
            this.extAuthSuccessUri = extAuthSuccessUri;
            if (Strings.isNullOrEmpty(extAuthFailUri)) {
                throw new IllegalArgumentException("extAuthFailUri is null or empty");
            }
            this.extAuthFailUri = extAuthFailUri;
            if (requestToken) {
                this.requestToken = true;
                this.externalCard = null;
                this.csc = null;
            } else {
                this.requestToken = false;
                this.externalCard = externalCard;
                this.csc = csc;
            }
        }

        @Override
        public URL requestURL(HostsProvider hostsProvider) throws MalformedURLException {
            return new URL(hostsProvider.getMoneyApi() + "/process-external-payment");
        }

        @Override
        public ProcessExternalPayment parseResponse(InputStream inputStream) {
            return (ProcessExternalPayment)new GsonBuilder().registerTypeAdapter(ProcessExternalPayment.class, (Object)new JsonDeserializer<ProcessExternalPayment>(){

                public ProcessExternalPayment deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    JsonObject o = json.getAsJsonObject();
                    Map<String, String> acsParams = null;
                    JsonObject paramsObj = o.getAsJsonObject("acs_params");
                    if (paramsObj != null) {
                        acsParams = JsonUtils.map(paramsObj);
                    }
                    String moneySourceMember = "money_source";
                    ExternalCard moneySource = o.has("money_source") ? ExternalCard.createFromJson(o.get("money_source")) : null;
                    return new ProcessExternalPayment(BaseProcessPayment.Status.parse(JsonUtils.getString(o, "status")), Error.parse(JsonUtils.getString(o, "error")), JsonUtils.getString(o, "acs_uri"), acsParams, moneySource, JsonUtils.getLong(o, "next_retry"), JsonUtils.getString(o, "invoice_id"));
                }
            }).create().fromJson((Reader)new InputStreamReader(inputStream), ProcessExternalPayment.class);
        }

        @Override
        public PostRequestBodyBuffer buildParameters() throws IOException {
            PostRequestBodyBuffer bb = new PostRequestBodyBuffer();
            bb.addParam("instance_id", this.instanceId);
            bb.addParam("request_id", this.requestId);
            bb.addParam("ext_auth_success_uri", this.extAuthSuccessUri);
            bb.addParam("ext_auth_fail_uri", this.extAuthFailUri);
            bb.addBooleanIfTrue("request_token", this.requestToken);
            if (this.externalCard != null) {
                bb.addParamIfNotNull("money_source_token", this.externalCard.getMoneySourceToken());
                bb.addParamIfNotNull("csc", this.csc);
            }
            return bb;
        }
    }
}

