/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.methods;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.yandex.money.api.methods.BaseProcessPayment;
import com.yandex.money.api.methods.JsonUtils;
import com.yandex.money.api.model.DigitalGoods;
import com.yandex.money.api.model.Error;
import com.yandex.money.api.model.MoneySource;
import com.yandex.money.api.net.HostsProvider;
import com.yandex.money.api.net.MethodRequest;
import com.yandex.money.api.net.PostRequestBodyBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class ProcessPayment
extends BaseProcessPayment {
    private final String paymentId;
    private final BigDecimal balance;
    private final String invoiceId;
    private final String payer;
    private final String payee;
    private final BigDecimal creditAmount;
    private final String accountUnblockUri;
    private final String payeeUid;
    private final String holdForPickupLink;
    private final DigitalGoods digitalGoods;

    private ProcessPayment(BaseProcessPayment.Status status, Error error, String paymentId, BigDecimal balance, String invoiceId, String payer, String payee, BigDecimal creditAmount, String accountUnblockUri, String payeeUid, String holdForPickupLink, String acsUri, Map<String, String> acsParams, Long nextRetry, DigitalGoods digitalGoods) {
        super(status, error, acsUri, acsParams, nextRetry);
        if (status == BaseProcessPayment.Status.SUCCESS && paymentId == null) {
            throw new NullPointerException("paymentId is null when status is success");
        }
        this.paymentId = paymentId;
        this.balance = balance;
        this.invoiceId = invoiceId;
        this.payer = payer;
        this.payee = payee;
        this.creditAmount = creditAmount;
        this.accountUnblockUri = accountUnblockUri;
        this.payeeUid = payeeUid;
        this.holdForPickupLink = holdForPickupLink;
        this.digitalGoods = digitalGoods;
    }

    public String toString() {
        return "ProcessPayment{status=" + (Object)((Object)this.getStatus()) + ", error=" + (Object)((Object)this.getError()) + ", acsUri='" + this.getAcsUri() + '\'' + ", acsParams=" + this.getAcsParams() + ", nextRetry=" + this.getNextRetry() + ", paymentId='" + this.paymentId + '\'' + ", balance=" + this.balance + ", invoiceId='" + this.invoiceId + '\'' + ", payer='" + this.payer + '\'' + ", payee='" + this.payee + '\'' + ", creditAmount=" + this.creditAmount + ", accountUnblockUri='" + this.accountUnblockUri + '\'' + ", payeeUid='" + this.payeeUid + '\'' + ", holdForPickupLink='" + this.holdForPickupLink + '\'' + ", digitalGoods=" + this.digitalGoods + '}';
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public String getInvoiceId() {
        return this.invoiceId;
    }

    public String getPayer() {
        return this.payer;
    }

    public String getPayee() {
        return this.payee;
    }

    public BigDecimal getCreditAmount() {
        return this.creditAmount;
    }

    public String getAccountUnblockUri() {
        return this.accountUnblockUri;
    }

    public String getPayeeUid() {
        return this.payeeUid;
    }

    public String getHoldForPickupLink() {
        return this.holdForPickupLink;
    }

    public DigitalGoods getDigitalGoods() {
        return this.digitalGoods;
    }

    private static final class Deserializer
    implements JsonDeserializer<ProcessPayment> {
        private Deserializer() {
        }

        public ProcessPayment deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            return new Builder().setStatus(BaseProcessPayment.Status.parse(JsonUtils.getMandatoryString(object, "status"))).setError(Error.parse(JsonUtils.getString(object, "error"))).setPaymentId(JsonUtils.getString(object, "payment_id")).setBalance(JsonUtils.getBigDecimal(object, "balance")).setInvoiceId(JsonUtils.getString(object, "invoice_id")).setPayer(JsonUtils.getString(object, "payer")).setPayee(JsonUtils.getString(object, "payee")).setCreditAmount(JsonUtils.getBigDecimal(object, "credit_amount")).setAccountUnblockUri(JsonUtils.getString(object, "account_unblock_uri")).setPayeeUid(JsonUtils.getString(object, "payee_uid")).setHoldForPickupLink(JsonUtils.getString(object, "hold_for_pickup_link")).setAcsUri(JsonUtils.getString(object, "acs_uri")).setAcsParams(object.has("acs_params") ? JsonUtils.map(object.getAsJsonObject("acs_params")) : null).setNextRetry(JsonUtils.getLong(object, "next_retry")).setDigitalGoods(DigitalGoods.createFromJson(object.get("digital_goods"))).createProcessPayment();
        }
    }

    public static class Builder {
        private BaseProcessPayment.Status status;
        private Error error;
        private String paymentId;
        private BigDecimal balance;
        private String invoiceId;
        private String payer;
        private String payee;
        private BigDecimal creditAmount;
        private String accountUnblockUri;
        private String payeeUid;
        private String holdForPickupLink;
        private String acsUri;
        private Map<String, String> acsParams;
        private Long nextRetry;
        private DigitalGoods digitalGoods;

        public Builder setStatus(BaseProcessPayment.Status status) {
            this.status = status;
            return this;
        }

        public Builder setError(Error error) {
            this.error = error;
            return this;
        }

        public Builder setPaymentId(String paymentId) {
            this.paymentId = paymentId;
            return this;
        }

        public Builder setBalance(BigDecimal balance) {
            this.balance = balance;
            return this;
        }

        public Builder setInvoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        public Builder setPayer(String payer) {
            this.payer = payer;
            return this;
        }

        public Builder setPayee(String payee) {
            this.payee = payee;
            return this;
        }

        public Builder setCreditAmount(BigDecimal creditAmount) {
            this.creditAmount = creditAmount;
            return this;
        }

        public Builder setAccountUnblockUri(String accountUnblockUri) {
            this.accountUnblockUri = accountUnblockUri;
            return this;
        }

        public Builder setPayeeUid(String payeeUid) {
            this.payeeUid = payeeUid;
            return this;
        }

        public Builder setHoldForPickupLink(String holdForPickupLink) {
            this.holdForPickupLink = holdForPickupLink;
            return this;
        }

        public Builder setAcsUri(String acsUri) {
            this.acsUri = acsUri;
            return this;
        }

        public Builder setAcsParams(Map<String, String> acsParams) {
            this.acsParams = acsParams;
            return this;
        }

        public Builder setNextRetry(Long nextRetry) {
            this.nextRetry = nextRetry;
            return this;
        }

        public Builder setDigitalGoods(DigitalGoods digitalGoods) {
            this.digitalGoods = digitalGoods;
            return this;
        }

        public ProcessPayment createProcessPayment() {
            return new ProcessPayment(this.status, this.error, this.paymentId, this.balance, this.invoiceId, this.payer, this.payee, this.creditAmount, this.accountUnblockUri, this.payeeUid, this.holdForPickupLink, this.acsUri, this.acsParams, this.nextRetry, this.digitalGoods);
        }
    }

    public static enum TestResult {
        SUCCESS("success"),
        CONTRACT_NOT_FOUND("contract_not_found"),
        NOT_ENOUGH_FUNDS("not_enough_funds"),
        LIMIT_EXCEEDED("limit_exceeded"),
        MONEY_SOURCE_NOT_AVAILABLE("money_source_not_available"),
        ILLEGAL_PARAM_CSC("illegal_param_csc"),
        PAYMENT_REFUSED("payment_refused"),
        AUTHORIZATION_REJECT("authorization_reject"),
        ACCOUNT_BLOCKED("account_blocked"),
        ILLEGAL_PARAM_EXT_AUTH_SUCCESS_URI("illegal_param_ext_auth_success_uri"),
        ILLEGAL_PARAM_EXT_AUTH_FAIL_URI("illegal_param_ext_auth_fail_uri");

        private final String code;

        private TestResult(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }

    public static final class Request
    implements MethodRequest<ProcessPayment> {
        private final String requestId;
        private final MoneySource moneySource;
        private final String csc;
        private final String extAuthSuccessUri;
        private final String extAuthFailUri;
        private boolean testPayment;
        private boolean testCardAvailable;
        private TestResult testResult;

        public Request(String requestId) {
            this(requestId, null, null, null, null);
        }

        public Request(String requestId, MoneySource moneySource, String csc, String extAuthSuccessUri, String extAuthFailUri) {
            if (requestId == null || requestId.isEmpty()) {
                throw new IllegalArgumentException("requestId is null or empty");
            }
            this.requestId = requestId;
            this.moneySource = moneySource;
            this.csc = csc;
            this.extAuthSuccessUri = extAuthSuccessUri;
            this.extAuthFailUri = extAuthFailUri;
        }

        @Override
        public URL requestURL(HostsProvider hostsProvider) throws MalformedURLException {
            return new URL(hostsProvider.getMoneyApi() + "/process-payment");
        }

        @Override
        public ProcessPayment parseResponse(InputStream inputStream) {
            return (ProcessPayment)Request.buildGson().fromJson((Reader)new InputStreamReader(inputStream), ProcessPayment.class);
        }

        @Override
        public PostRequestBodyBuffer buildParameters() throws IOException {
            PostRequestBodyBuffer postRequestBodyBuffer = new PostRequestBodyBuffer();
            if (this.moneySource != null) {
                postRequestBodyBuffer.addParam("money_source", this.moneySource.getId());
            }
            if (this.testPayment) {
                postRequestBodyBuffer.addParamIfNotNull("test_payment", true);
                if (this.testCardAvailable) {
                    postRequestBodyBuffer.addParamIfNotNull("test_card", true);
                }
                if (this.testResult != null) {
                    postRequestBodyBuffer.addParam("test_result", this.testResult.getCode());
                }
            }
            return postRequestBodyBuffer.addParam("request_id", this.requestId).addParamIfNotNull("csc", this.csc).addParamIfNotNull("ext_auth_success_uri", this.extAuthSuccessUri).addParamIfNotNull("ext_auth_fail_uri", this.extAuthFailUri);
        }

        public void setTestPayment(boolean testPayment) {
            this.testPayment = testPayment;
        }

        public void setTestCardAvailable(boolean testCardAvailable) {
            this.testCardAvailable = testCardAvailable;
        }

        public void setTestResult(TestResult testResult) {
            this.testResult = testResult;
        }

        private static Gson buildGson() {
            return new GsonBuilder().registerTypeAdapter(ProcessPayment.class, (Object)new Deserializer()).create();
        }
    }
}

