/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.methods;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.yandex.money.api.methods.BaseRequestPayment;
import com.yandex.money.api.methods.JsonUtils;
import com.yandex.money.api.methods.params.P2pParams;
import com.yandex.money.api.methods.params.PhoneParams;
import com.yandex.money.api.model.Error;
import com.yandex.money.api.net.HostsProvider;
import com.yandex.money.api.net.MethodRequest;
import com.yandex.money.api.net.PostRequestBodyBuffer;
import com.yandex.money.api.utils.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public class RequestExternalPayment
extends BaseRequestPayment {
    private final String title;

    public RequestExternalPayment(BaseRequestPayment.Status status, Error error, String requestId, BigDecimal contractAmount, String title) {
        super(status, error, requestId, contractAmount);
        this.title = title;
    }

    public String toString() {
        return "RequestExternalPayment{status=" + (Object)((Object)this.getStatus()) + ", error=" + (Object)((Object)this.getError()) + ", requestId='" + this.getRequestId() + '\'' + ", contractAmount=" + this.getContractAmount() + ", title='" + this.title + '\'' + '}';
    }

    public String getTitle() {
        return this.title;
    }

    public static class Request
    implements MethodRequest<RequestExternalPayment> {
        private final String instanceId;
        private final String patternId;
        private final Map<String, String> params;

        private Request(String instanceId, String patternId, Map<String, String> params) {
            if (Strings.isNullOrEmpty(instanceId)) {
                throw new IllegalArgumentException("instanceId is null or empty");
            }
            this.instanceId = instanceId;
            if (Strings.isNullOrEmpty(patternId)) {
                throw new IllegalArgumentException("patternId is null or empty");
            }
            this.patternId = patternId;
            this.params = params;
        }

        public static Request newInstance(String instanceId, String patternId, Map<String, String> paramsShop) {
            if (paramsShop == null) {
                throw new IllegalArgumentException("paramsShop is null or empty");
            }
            return new Request(instanceId, patternId, paramsShop);
        }

        public static Request newInstance(String instanceId, P2pParams p2pParams) {
            if (p2pParams == null) {
                throw new IllegalArgumentException("p2pParams is null or empty");
            }
            return new Request(instanceId, "p2p", p2pParams.makeParams());
        }

        public static Request newInstance(String instanceId, PhoneParams phoneParams) {
            if (phoneParams == null) {
                throw new IllegalArgumentException("phoneParams is null or empty");
            }
            return new Request(instanceId, "phone-topup", phoneParams.makeParams());
        }

        @Override
        public URL requestURL(HostsProvider hostsProvider) throws MalformedURLException {
            return new URL(hostsProvider.getMoneyApi() + "/request-external-payment");
        }

        @Override
        public RequestExternalPayment parseResponse(InputStream inputStream) {
            return (RequestExternalPayment)new GsonBuilder().registerTypeAdapter(RequestExternalPayment.class, (Object)new JsonDeserializer<RequestExternalPayment>(){

                public RequestExternalPayment deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    JsonObject o = json.getAsJsonObject();
                    return new RequestExternalPayment(BaseRequestPayment.Status.parse(JsonUtils.getString(o, "status")), Error.parse(JsonUtils.getString(o, "error")), JsonUtils.getString(o, "request_id"), JsonUtils.getBigDecimal(o, "contract_amount"), JsonUtils.getString(o, "title"));
                }
            }).create().fromJson((Reader)new InputStreamReader(inputStream), RequestExternalPayment.class);
        }

        @Override
        public PostRequestBodyBuffer buildParameters() throws IOException {
            return new PostRequestBodyBuffer().addParam("instance_id", this.instanceId).addParam("pattern_id", this.patternId).addParams(this.params);
        }
    }
}

