/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.methods;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.yandex.money.api.methods.JsonUtils;
import com.yandex.money.api.model.Error;
import com.yandex.money.api.net.HostsProvider;
import com.yandex.money.api.net.MethodRequest;
import com.yandex.money.api.net.MethodResponse;
import com.yandex.money.api.net.PostRequestBodyBuffer;
import com.yandex.money.api.utils.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;

public class Token
implements MethodResponse {
    private final String accessToken;
    private final Error error;

    public Token(String accessToken, Error error) {
        this.accessToken = accessToken;
        this.error = error;
    }

    public String toString() {
        return "Token{accessToken='" + this.accessToken + '\'' + ", error=" + (Object)((Object)this.error) + '}';
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Error getError() {
        return this.error;
    }

    private static final class Deserializer
    implements JsonDeserializer<Token> {
        private Deserializer() {
        }

        public Token deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            return new Token(JsonUtils.getString(object, "access_token"), Error.parse(JsonUtils.getString(object, "error")));
        }
    }

    public static final class Revoke
    implements MethodRequest<Object> {
        private final boolean revokeAll;

        public Revoke() {
            this(false);
        }

        public Revoke(boolean revokeAll) {
            this.revokeAll = revokeAll;
        }

        @Override
        public URL requestURL(HostsProvider hostsProvider) throws MalformedURLException {
            return new URL(hostsProvider.getMoneyApi() + "/revoke");
        }

        @Override
        public Object parseResponse(InputStream inputStream) {
            return null;
        }

        @Override
        public PostRequestBodyBuffer buildParameters() throws IOException {
            return new PostRequestBodyBuffer().addBooleanIfTrue("revoke-all", this.revokeAll);
        }
    }

    public static class Request
    implements MethodRequest<Token> {
        protected final String code;
        protected final String clientId;
        private final String grantType;
        private final String redirectUri;
        private final String clientSecret;

        public Request(String code, String clientId, String redirectUri) {
            this(code, clientId, redirectUri, null);
        }

        public Request(String code, String clientId, String redirectUri, String clientSecret) {
            if (Strings.isNullOrEmpty(code)) {
                throw new NullPointerException("code is null or empty");
            }
            this.code = code;
            if (Strings.isNullOrEmpty(clientId)) {
                throw new NullPointerException("clientId is null or empty");
            }
            this.clientId = clientId;
            this.grantType = "authorization_code";
            if (Strings.isNullOrEmpty(redirectUri)) {
                throw new NullPointerException("redirectUri is null or empty");
            }
            this.redirectUri = redirectUri;
            this.clientSecret = clientSecret;
        }

        @Override
        public URL requestURL(HostsProvider hostsProvider) throws MalformedURLException {
            return new URL(hostsProvider.getSpMoney() + "/oauth/token");
        }

        @Override
        public Token parseResponse(InputStream inputStream) {
            return (Token)Request.buildGson().fromJson((Reader)new InputStreamReader(inputStream), Token.class);
        }

        @Override
        public PostRequestBodyBuffer buildParameters() throws IOException {
            return new PostRequestBodyBuffer().addParam("code", this.code).addParam("client_id", this.clientId).addParam("grant_type", this.grantType).addParamIfNotNull("redirect_uri", this.redirectUri).addParamIfNotNull("client_secret", this.clientSecret);
        }

        private static Gson buildGson() {
            return new GsonBuilder().registerTypeAdapter(Token.class, (Object)new Deserializer()).create();
        }
    }
}

