/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.methods.params;

import com.yandex.money.api.methods.params.Params;
import com.yandex.money.api.utils.Strings;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class P2pParams
implements Params {
    public static final String PATTERN_ID = "p2p";
    private static final String PARAM_TO = "to";
    private static final String PARAM_AMOUNT_DUE = "amount_due";
    private static final String PARAM_MESSAGE = "message";
    private final String to;
    private final BigDecimal amountDue;
    private final String message;

    public P2pParams(String to, BigDecimal amountDue, String message) {
        if (Strings.isNullOrEmpty(to)) {
            throw new IllegalArgumentException("to is null or empty");
        }
        this.to = to;
        if (amountDue == null) {
            throw new IllegalArgumentException("amount_due is null or empty");
        }
        this.amountDue = amountDue;
        this.message = message;
    }

    public P2pParams(String to, BigDecimal amountDue) {
        this(to, amountDue, null);
    }

    @Override
    public Map<String, String> makeParams() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(PARAM_TO, this.to);
        result.put(PARAM_AMOUNT_DUE, this.amountDue.toPlainString());
        if (!Strings.isNullOrEmpty(this.message)) {
            result.put(PARAM_MESSAGE, this.message);
        }
        return result;
    }
}

