/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.methods.params;

import com.yandex.money.api.methods.params.Params;
import com.yandex.money.api.utils.Strings;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class PhoneParams
implements Params {
    public static final String PATTERN_ID = "phone-topup";
    private static final String PARAM_PHONE_NUMBER = "phone-number";
    private static final String PARAM_AMOUNT = "amount";
    private final String number;
    private final BigDecimal amount;

    public PhoneParams(String number, BigDecimal amount) {
        if (Strings.isNullOrEmpty(number)) {
            throw new IllegalArgumentException("phone-number is null or empty");
        }
        this.number = number;
        if (amount == null) {
            throw new IllegalArgumentException("amount is null or empty");
        }
        this.amount = amount;
    }

    @Override
    public Map<String, String> makeParams() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(PARAM_PHONE_NUMBER, this.number);
        result.put(PARAM_AMOUNT, this.amount.toPlainString());
        return result;
    }
}

