/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.yandex.money.api.methods.JsonUtils;
import java.lang.reflect.Type;
import org.joda.time.DateTime;

public class Avatar {
    private final String url;
    private final DateTime timestamp;

    public Avatar(String url, DateTime timestamp) {
        if (url == null || url.length() == 0) {
            throw new JsonParseException("avatar url is null or empty");
        }
        this.url = url;
        if (timestamp == null) {
            throw new JsonParseException("avatar timestamp is null");
        }
        this.timestamp = timestamp;
    }

    public String toString() {
        return "Avatar{url='" + this.url + '\'' + ", timestamp=" + this.timestamp + '}';
    }

    public static Avatar createFromJson(JsonElement json) {
        return (Avatar)Avatar.buildGson().fromJson(json, Avatar.class);
    }

    public String getUrl() {
        return this.url;
    }

    public DateTime getTimestamp() {
        return this.timestamp;
    }

    private static Gson buildGson() {
        return new GsonBuilder().registerTypeAdapter(Avatar.class, (Object)new Deserializer()).create();
    }

    private static class Deserializer
    implements JsonDeserializer<Avatar> {
        private Deserializer() {
        }

        public Avatar deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            return new Avatar(JsonUtils.getMandatoryString(object, "url"), JsonUtils.getMandatoryDateTime(object, "ts"));
        }
    }
}

