/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.yandex.money.api.methods.JsonUtils;
import com.yandex.money.api.model.Card;
import com.yandex.money.api.utils.Strings;
import java.lang.reflect.Type;

public class ExternalCard
extends Card {
    private final String fundingSourceType;
    private final String moneySourceToken;

    public ExternalCard(String panFragment, String type, String fundingSourceType, String moneySourceToken) {
        super(null, panFragment, type);
        if (Strings.isNullOrEmpty(fundingSourceType)) {
            throw new NullPointerException("fundingSourceType is null or empty");
        }
        if (Strings.isNullOrEmpty(moneySourceToken)) {
            throw new NullPointerException("money source token is null or empty");
        }
        this.fundingSourceType = fundingSourceType;
        this.moneySourceToken = moneySourceToken;
    }

    public static ExternalCard createFromJson(JsonElement jsonElement) {
        return (ExternalCard)ExternalCard.buildGson().fromJson(jsonElement, ExternalCard.class);
    }

    @Override
    public String toString() {
        return "ExternalCard{fundingSourceType='" + this.fundingSourceType + '\'' + ", moneySourceToken='" + this.moneySourceToken + '\'' + '}';
    }

    public String getFundingSourceType() {
        return this.fundingSourceType;
    }

    public String getMoneySourceToken() {
        return this.moneySourceToken;
    }

    private static Gson buildGson() {
        return new GsonBuilder().registerTypeAdapter(ExternalCard.class, (Object)new Deserializer()).create();
    }

    private static final class Deserializer
    implements JsonDeserializer<ExternalCard> {
        private Deserializer() {
        }

        public ExternalCard deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            return new ExternalCard(JsonUtils.getMandatoryString(object, "pan_fragment"), JsonUtils.getMandatoryString(object, "payment_card_type"), JsonUtils.getMandatoryString(object, "type"), JsonUtils.getMandatoryString(object, "money_source_token"));
        }
    }
}

