/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.yandex.money.api.methods.JsonUtils;
import com.yandex.money.api.model.DigitalGoods;
import com.yandex.money.api.model.PayeeIdentifierType;
import java.math.BigDecimal;
import java.util.Map;
import org.joda.time.DateTime;

public class Operation {
    private final String operationId;
    private final Status status;
    private final String patternId;
    private final Direction direction;
    private final BigDecimal amount;
    private final BigDecimal amountDue;
    private final BigDecimal fee;
    private final DateTime datetime;
    private final String title;
    private final String sender;
    private final String recipient;
    private final PayeeIdentifierType recipientType;
    private final String message;
    private final String comment;
    private final Boolean codepro;
    private final String protectionCode;
    private final DateTime expires;
    private final DateTime answerDatetime;
    private final String label;
    private final String details;
    private final Boolean repeatable;
    private final Map<String, String> paymentParameters;
    private final Boolean favorite;
    private final Type type;
    private final DigitalGoods digitalGoods;

    protected Operation(String operationId, Status status, String patternId, Direction direction, BigDecimal amount, BigDecimal amountDue, BigDecimal fee, DateTime datetime, String title, String sender, String recipient, PayeeIdentifierType recipientType, String message, String comment, Boolean codepro, String protectionCode, DateTime expires, DateTime answerDatetime, String label, String details, Boolean repeatable, Map<String, String> paymentParameters, Boolean favorite, Type type, DigitalGoods digitalGoods) {
        this.operationId = operationId;
        this.status = status;
        this.patternId = patternId;
        this.direction = direction;
        this.amount = amount;
        this.amountDue = amountDue;
        this.fee = fee;
        this.datetime = datetime;
        this.title = title;
        this.sender = sender;
        this.recipient = recipient;
        this.recipientType = recipientType;
        this.message = message;
        this.comment = comment;
        this.codepro = codepro;
        this.protectionCode = protectionCode;
        this.expires = expires;
        this.answerDatetime = answerDatetime;
        this.label = label;
        this.details = details;
        this.repeatable = repeatable;
        this.paymentParameters = paymentParameters;
        this.favorite = favorite;
        this.type = type;
        this.digitalGoods = digitalGoods;
    }

    public static Operation createFromJson(JsonElement element) {
        return (Operation)Operation.buildGson().fromJson(element, Operation.class);
    }

    public String toString() {
        return "Operation{operationId='" + this.operationId + '\'' + ", status=" + (Object)((Object)this.status) + ", patternId='" + this.patternId + '\'' + ", direction=" + (Object)((Object)this.direction) + ", amount=" + this.amount + ", amountDue=" + this.amountDue + ", fee=" + this.fee + ", datetime=" + this.datetime + ", title='" + this.title + '\'' + ", sender='" + this.sender + '\'' + ", recipient='" + this.recipient + '\'' + ", recipientType=" + (Object)((Object)this.recipientType) + ", message='" + this.message + '\'' + ", comment='" + this.comment + '\'' + ", codepro=" + this.codepro + ", protectionCode='" + this.protectionCode + '\'' + ", expires=" + this.expires + ", answerDatetime=" + this.answerDatetime + ", label='" + this.label + '\'' + ", details='" + this.details + '\'' + ", repeatable=" + this.repeatable + ", paymentParameters=" + this.paymentParameters + ", favorite=" + this.favorite + ", type=" + (Object)((Object)this.type) + ", digitalGoods=" + this.digitalGoods + '}';
    }

    public String getOperationId() {
        return this.operationId;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getPatternId() {
        return this.patternId;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getAmountDue() {
        return this.amountDue;
    }

    public BigDecimal getFee() {
        return this.fee;
    }

    public DateTime getDatetime() {
        return this.datetime;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSender() {
        return this.sender;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public PayeeIdentifierType getRecipientType() {
        return this.recipientType;
    }

    public String getMessage() {
        return this.message;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isProtected() {
        return this.codepro != null && this.codepro != false;
    }

    public String getProtectionCode() {
        return this.protectionCode;
    }

    public DateTime getExpires() {
        return this.expires;
    }

    public DateTime getAnswerDatetime() {
        return this.answerDatetime;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDetails() {
        return this.details;
    }

    public boolean isRepeatable() {
        return this.repeatable != null && this.repeatable != false;
    }

    public Map<String, String> getPaymentParameters() {
        return this.paymentParameters;
    }

    public boolean isFavorite() {
        return this.favorite != null && this.favorite != false;
    }

    public Type getType() {
        return this.type;
    }

    public DigitalGoods getDigitalGoods() {
        return this.digitalGoods;
    }

    private static Gson buildGson() {
        return new GsonBuilder().registerTypeAdapter(Operation.class, (Object)new Deserializer()).create();
    }

    private static final class Deserializer
    implements JsonDeserializer<Operation> {
        private Deserializer() {
        }

        public Operation deserialize(JsonElement json, java.lang.reflect.Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject o = json.getAsJsonObject();
            String paymentParametersMember = "payment_parameters";
            return new Builder().setOperationId(JsonUtils.getMandatoryString(o, "operation_id")).setStatus(Status.parse(JsonUtils.getString(o, "status"))).setDatetime(JsonUtils.getDateTime(o, "datetime")).setTitle(JsonUtils.getMandatoryString(o, "title")).setPatternId(JsonUtils.getString(o, "pattern_id")).setDirection(Direction.parse(JsonUtils.getMandatoryString(o, "direction"))).setAmount(JsonUtils.getBigDecimal(o, "amount")).setAmountDue(JsonUtils.getBigDecimal(o, "amount_due")).setFee(JsonUtils.getBigDecimal(o, "fee")).setLabel(JsonUtils.getString(o, "label")).setType(Type.parse(JsonUtils.getString(o, "type"))).setSender(JsonUtils.getString(o, "sender")).setRecipient(JsonUtils.getString(o, "recipient")).setRecipientType(PayeeIdentifierType.parse(JsonUtils.getString(o, "recipient_type"))).setMessage(JsonUtils.getString(o, "message")).setComment(JsonUtils.getString(o, "comment")).setCodepro(JsonUtils.getBoolean(o, "codepro")).setProtectionCode(JsonUtils.getString(o, "protection_code")).setExpires(JsonUtils.getDateTime(o, "expires")).setAnswerDatetime(JsonUtils.getDateTime(o, "answer_datetime")).setDetails(JsonUtils.getString(o, "details")).setRepeatable(JsonUtils.getBoolean(o, "repeatable")).setPaymentParameters(o.has("payment_parameters") ? JsonUtils.map(o.getAsJsonObject("payment_parameters")) : null).setFavorite(JsonUtils.getBoolean(o, "favourite")).setDigitalGoods(DigitalGoods.createFromJson(o.get("digital_goods"))).createOperation();
        }
    }

    public static class Builder {
        private String operationId;
        private Status status;
        private String patternId;
        private Direction direction;
        private BigDecimal amount;
        private BigDecimal amountDue;
        private BigDecimal fee;
        private DateTime datetime;
        private String title;
        private String sender;
        private String recipient;
        private PayeeIdentifierType recipientType;
        private String message;
        private String comment;
        private Boolean codepro;
        private String protectionCode;
        private DateTime expires;
        private DateTime answerDatetime;
        private String label;
        private String details;
        private Boolean repeatable;
        private Map<String, String> paymentParameters;
        private Boolean favorite;
        private Type type;
        private DigitalGoods digitalGoods;

        public Builder setOperationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public Builder setStatus(Status status) {
            this.status = status;
            return this;
        }

        public Builder setPatternId(String patternId) {
            this.patternId = patternId;
            return this;
        }

        public Builder setDirection(Direction direction) {
            this.direction = direction;
            return this;
        }

        public Builder setAmount(BigDecimal amount) {
            this.amount = amount;
            return this;
        }

        public Builder setAmountDue(BigDecimal amountDue) {
            this.amountDue = amountDue;
            return this;
        }

        public Builder setFee(BigDecimal fee) {
            this.fee = fee;
            return this;
        }

        public Builder setDatetime(DateTime datetime) {
            this.datetime = datetime;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setSender(String sender) {
            this.sender = sender;
            return this;
        }

        public Builder setRecipient(String recipient) {
            this.recipient = recipient;
            return this;
        }

        public Builder setRecipientType(PayeeIdentifierType recipientType) {
            this.recipientType = recipientType;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder setCodepro(Boolean codepro) {
            this.codepro = codepro;
            return this;
        }

        public Builder setProtectionCode(String protectionCode) {
            this.protectionCode = protectionCode;
            return this;
        }

        public Builder setExpires(DateTime expires) {
            this.expires = expires;
            return this;
        }

        public Builder setAnswerDatetime(DateTime answerDatetime) {
            this.answerDatetime = answerDatetime;
            return this;
        }

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder setDetails(String details) {
            this.details = details;
            return this;
        }

        public Builder setRepeatable(Boolean repeatable) {
            this.repeatable = repeatable;
            return this;
        }

        public Builder setPaymentParameters(Map<String, String> paymentParameters) {
            this.paymentParameters = paymentParameters;
            return this;
        }

        public Builder setFavorite(Boolean favorite) {
            this.favorite = favorite;
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder setDigitalGoods(DigitalGoods digitalGoods) {
            this.digitalGoods = digitalGoods;
            return this;
        }

        public Operation createOperation() {
            return new Operation(this.operationId, this.status, this.patternId, this.direction, this.amount, this.amountDue, this.fee, this.datetime, this.title, this.sender, this.recipient, this.recipientType, this.message, this.comment, this.codepro, this.protectionCode, this.expires, this.answerDatetime, this.label, this.details, this.repeatable, this.paymentParameters, this.favorite, this.type, this.digitalGoods);
        }
    }

    public static enum Direction {
        INCOMING("in"),
        OUTGOING("out"),
        UNKNOWN("unknown");

        private final String direction;

        private Direction(String direction) {
            this.direction = direction;
        }

        public static Direction parse(String direction) {
            for (Direction value : Direction.values()) {
                if (!value.direction.equals(direction)) continue;
                return value;
            }
            return UNKNOWN;
        }
    }

    public static enum Type {
        PAYMENT_SHOP("payment-shop"),
        OUTGOING_TRANSFER("outgoing-transfer"),
        INCOMING_TRANSFER("incoming-transfer"),
        INCOMING_TRANSFER_PROTECTED("incoming-transfer-protected"),
        DEPOSITION("deposition"),
        UNKNOWN("unknown");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public static Type parse(String type) {
            for (Type value : Type.values()) {
                if (!value.type.equals(type)) continue;
                return value;
            }
            return UNKNOWN;
        }
    }

    public static enum Status {
        SUCCESS("success"),
        REFUSED("refused"),
        IN_PROGRESS("in_progress"),
        UNKNOWN("unknown");

        private final String status;

        private Status(String status) {
            this.status = status;
        }

        public static Status parse(String status) {
            for (Status value : Status.values()) {
                if (!value.status.equals(status)) continue;
                return value;
            }
            return UNKNOWN;
        }
    }
}

