/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.model;

public enum PayeeIdentifierType {
    ACCOUNT("account"),
    PHONE("phone"),
    EMAIL("email"),
    UNKNOWN("unknown");

    private final String code;

    private PayeeIdentifierType(String code) {
        this.code = code;
    }

    public static PayeeIdentifierType parse(String identifier) {
        if (identifier == null) {
            return null;
        }
        for (PayeeIdentifierType value : PayeeIdentifierType.values()) {
            if (!value.code.equals(identifier)) continue;
            return value;
        }
        return UNKNOWN;
    }

    public static PayeeIdentifierType determine(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            return UNKNOWN;
        }
        if (identifier.matches("41\\d{9,31}")) {
            return ACCOUNT;
        }
        if (identifier.matches("(\\+[0-9]+[\\- \\.]*)?(\\([0-9]+\\)[\\- \\.]*)?([0-9][0-9\\- \\.]+[0-9])")) {
            return PHONE;
        }
        if (identifier.matches("[a-zA-Z0-9\\+\\._%\\-\\+]{1,256}") || identifier.matches("[a-zA-Z0-9\\+\\._%\\-\\+]{1,256}@[a-zA-Z0-9][a-zA-Z0-9\\-]{0,64}(\\.[a-zA-Z0-9][a-zA-Z0-9\\-]{0,25})+")) {
            return EMAIL;
        }
        return UNKNOWN;
    }

    public String getCode() {
        return this.code;
    }
}

