/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.model;

import com.yandex.money.api.utils.Strings;
import java.math.BigDecimal;
import java.util.Iterator;

public class Scope {
    public static final Scope ACCOUNT_INFO = new Scope("account-info");
    public static final Scope INCOMING_TRANSFERS = new Scope("incoming-transfers");
    public static final Scope OPERATION_DETAILS = new Scope("operation-details");
    public static final Scope OPERATION_HISTORY = new Scope("operation-history");
    public static final Scope PAYMENT_P2P = new Scope("payment-p2p");
    public static final Scope PAYMENT_SHOP = new Scope("payment-shop");
    private final String name;

    protected Scope(String name) {
        if (Strings.isNullOrEmpty(name)) {
            throw new NullPointerException("scope name can not be null or empty");
        }
        this.name = name;
    }

    public static MoneySourceScope createMoneySourceScope() {
        return new MoneySourceScope();
    }

    public static LimitedScope createPaymentP2pLimitedScope() {
        return new LimitedScope(Scope.PAYMENT_P2P.name);
    }

    public static LimitedScope createPaymentShopLimitedScope() {
        return new LimitedScope(Scope.PAYMENT_SHOP.name);
    }

    public static PaymentScope createPaymentScopeToAccount(String account) {
        return PaymentScope.createPaymentToAccount(account);
    }

    public static PaymentScope createPaymentScopeToPattern(String patternId) {
        return PaymentScope.createPaymentToPattern(patternId);
    }

    public static String createScopeParameter(Iterator<Scope> scopes) {
        if (scopes == null || !scopes.hasNext()) {
            throw new IllegalArgumentException("scopes is null or empty");
        }
        StringBuilder builder = new StringBuilder(scopes.next().getQualifiedName());
        while (scopes.hasNext()) {
            builder.append(" ").append(scopes.next().getQualifiedName());
        }
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Scope) {
            Scope scope = (Scope)obj;
            return this.name.equals(scope.name);
        }
        return false;
    }

    public String getQualifiedName() {
        return this.name;
    }

    public static final class PaymentScope
    extends LimitedScope {
        private final String patternId;
        private final String account;

        private PaymentScope(String patternId, String account) {
            super("payment");
            this.patternId = patternId;
            this.account = account;
        }

        public static PaymentScope createPaymentToPattern(String patternId) {
            if (Strings.isNullOrEmpty(patternId)) {
                throw new IllegalArgumentException("pattern id is null or empty");
            }
            return new PaymentScope(patternId, null);
        }

        public static PaymentScope createPaymentToAccount(String account) {
            if (Strings.isNullOrEmpty(account)) {
                throw new IllegalArgumentException("account is null or empty");
            }
            return new PaymentScope(null, account);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof PaymentScope) {
                PaymentScope scope = (PaymentScope)obj;
                if (this.patternId == null) {
                    return scope.patternId == null && this.account.equals(scope.account);
                }
                return scope.account == null && this.patternId.equals(scope.patternId);
            }
            return false;
        }

        @Override
        public String getQualifiedName() {
            return super.getQualifiedName() + (Strings.isNullOrEmpty(this.patternId) ? "to-account(\"" + this.account + "\")" : "to-pattern(\"" + this.patternId + "\")") + this.getLimit();
        }
    }

    public static class LimitedScope
    extends Scope {
        private Integer duration;
        private BigDecimal sum;

        protected LimitedScope(String name) {
            super(name);
        }

        @Override
        public String getQualifiedName() {
            return super.getQualifiedName() + this.getLimit();
        }

        public LimitedScope setDuration(Integer duration) {
            if (duration != null && duration < 1) {
                throw new IllegalArgumentException("duration must have positive value: " + duration);
            }
            this.duration = duration;
            return this;
        }

        public LimitedScope setSum(BigDecimal sum) {
            if (sum != null && sum.doubleValue() < 0.0) {
                throw new IllegalArgumentException("sum must have positive value:" + sum.toPlainString());
            }
            this.sum = sum;
            return this;
        }

        protected String getLimit() {
            return this.sum != null ? ".limit(" + (this.duration != null ? this.duration : "") + "," + this.sum.toPlainString() + ")" : "";
        }
    }

    public static final class MoneySourceScope
    extends Scope {
        private boolean wallet = true;
        private boolean cards = false;

        private MoneySourceScope() {
            super("money-source");
        }

        public MoneySourceScope setSources(boolean wallet, boolean cards) {
            if (!wallet && !cards) {
                throw new IllegalArgumentException("inconsistent arguments: at least one ofparameters should not be false");
            }
            this.wallet = wallet;
            this.cards = cards;
            return this;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof MoneySourceScope) {
                MoneySourceScope scope = (MoneySourceScope)obj;
                return this.wallet == scope.wallet && this.cards == scope.cards;
            }
            return false;
        }

        @Override
        public String getQualifiedName() {
            return super.getQualifiedName() + "(\"" + (this.wallet ? "wallet" : "") + (this.wallet && this.cards ? "\",\"" : "") + (this.cards ? "cards" : "") + "\")";
        }
    }
}

