/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.net;

import com.squareup.okhttp.OkHttpClient;
import com.yandex.money.api.net.ApiClient;
import com.yandex.money.api.net.OAuth2Session;
import com.yandex.money.api.net.ResponseLoggingInputStream;
import com.yandex.money.api.net.UserAgent;
import com.yandex.money.api.utils.Language;
import com.yandex.money.api.utils.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Logger;

public abstract class AbstractSession {
    private static final Logger LOGGER = Logger.getLogger(OAuth2Session.class.getName());
    protected final ApiClient client;
    private boolean debugLogging = false;

    protected AbstractSession(ApiClient client) {
        if (client == null) {
            throw new NullPointerException("client is null");
        }
        this.client = client;
    }

    public void setDebugLogging(boolean debugLogging) {
        this.debugLogging = debugLogging;
    }

    protected HttpURLConnection openConnection(URL url) {
        Language language;
        OkHttpClient httpClient = this.client.getHttpClient();
        HttpURLConnection connection = httpClient.open(url);
        connection.setInstanceFollowRedirects(false);
        UserAgent userAgent = this.client.getUserAgent();
        if (userAgent != null) {
            connection.setRequestProperty("User-Agent", userAgent.getName());
        }
        if ((language = this.client.getLanguage()) != null) {
            connection.setRequestProperty("Accept-Language", language.getIso6391Code());
        }
        connection.setUseCaches(false);
        return connection;
    }

    protected InputStream getInputStream(HttpURLConnection connection) throws IOException {
        InputStream stream = connection.getResponseCode() >= 400 ? connection.getErrorStream() : connection.getInputStream();
        return this.debugLogging ? new ResponseLoggingInputStream(stream) : stream;
    }

    protected String processError(HttpURLConnection connection) throws IOException {
        String field = connection.getHeaderField("WWW-Authenticate");
        LOGGER.warning("Server has responded with a error: " + this.getError(connection) + "\n" + "WWW-Authenticate" + ": " + field);
        Streams.readStreamToNull(this.getInputStream(connection));
        return field;
    }

    private String getError(HttpURLConnection connection) {
        try {
            return "HTTP " + connection.getResponseCode() + " " + connection.getResponseMessage();
        }
        catch (IOException e) {
            return "UNKNOWN " + e.toString();
        }
    }
}

