/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.net;

import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.OkAuthenticator;
import com.squareup.okhttp.OkHttpClient;
import com.yandex.money.api.net.ApiClient;
import com.yandex.money.api.net.DefaultUserAgent;
import com.yandex.money.api.net.HostsProvider;
import com.yandex.money.api.net.UserAgent;
import com.yandex.money.api.net.WireLoggingSocketFactory;
import com.yandex.money.api.utils.Language;
import com.yandex.money.api.utils.Strings;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;

public class DefaultApiClient
implements ApiClient {
    private static final long DEFAULT_TIMEOUT = 30L;
    private final String id;
    private final OkHttpClient httpClient;
    private final HostsProvider hostsProvider;
    private String platform = "Java";
    private static OkAuthenticator NULL_AUTHENTICATOR = new OkAuthenticator(){

        public OkAuthenticator.Credential authenticate(Proxy proxy, URL url, List<OkAuthenticator.Challenge> challenges) throws IOException {
            return null;
        }

        public OkAuthenticator.Credential authenticateProxy(Proxy proxy, URL url, List<OkAuthenticator.Challenge> challenges) throws IOException {
            return null;
        }
    };

    public DefaultApiClient(String clientId) {
        if (clientId == null) {
            throw new NullPointerException("client id is null");
        }
        this.id = clientId;
        this.httpClient = DefaultApiClient.createHttpClient();
        this.hostsProvider = new HostsProvider(false);
    }

    public DefaultApiClient(String clientId, boolean debugLogging) {
        this(clientId);
        if (debugLogging) {
            SSLSocketFactory sslSocketFactory = DefaultApiClient.createSslSocketFactory();
            this.httpClient.setSslSocketFactory((SSLSocketFactory)new WireLoggingSocketFactory(sslSocketFactory));
        }
    }

    public DefaultApiClient(String clientId, boolean debugLogging, String platform) {
        this(clientId, debugLogging);
        if (!Strings.isNullOrEmpty(platform)) {
            this.platform = platform;
        }
    }

    @Override
    public String getClientId() {
        return this.id;
    }

    @Override
    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public HostsProvider getHostsProvider() {
        return this.hostsProvider;
    }

    @Override
    public UserAgent getUserAgent() {
        return new DefaultUserAgent(this.platform);
    }

    @Override
    public Language getLanguage() {
        return Language.getDefault();
    }

    private static OkHttpClient createHttpClient() {
        OkHttpClient client = new OkHttpClient();
        client.setReadTimeout(30L, TimeUnit.SECONDS);
        client.setConnectTimeout(30L, TimeUnit.SECONDS);
        client.setAuthenticator(NULL_AUTHENTICATOR);
        client.setConnectionPool(new ConnectionPool(4, 600000L));
        client.setFollowSslRedirects(false);
        return client;
    }

    private static SSLSocketFactory createSslSocketFactory() {
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, null, null);
            return context.getSocketFactory();
        }
        catch (GeneralSecurityException exception) {
            throw new RuntimeException(exception);
        }
    }
}

