/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.net;

import com.yandex.money.api.model.Scope;
import com.yandex.money.api.net.ApiClient;
import com.yandex.money.api.net.PostRequestBodyBuffer;
import com.yandex.money.api.utils.Strings;
import java.util.HashSet;
import java.util.Set;

public class OAuth2Authorization {
    private final ApiClient client;

    public OAuth2Authorization(ApiClient client) {
        if (client == null) {
            throw new NullPointerException("hostsProvider is null");
        }
        this.client = client;
    }

    public String getAuthorizeUrl() {
        return this.client.getHostsProvider().getSpMoney() + "/oauth/authorize";
    }

    public Params getAuthorizeParams() {
        return new Params().setClientId(this.client.getClientId());
    }

    public static final class Params {
        private String clientId;
        private String responseType;
        private String redirectUri;
        private Set<Scope> scopes;
        private String rawScope;
        private String instanceName;

        public Params setResponseType(String responseType) {
            this.responseType = responseType;
            return this;
        }

        public Params setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public Params addScope(Scope scope) {
            if (scope != null) {
                if (this.scopes == null) {
                    this.scopes = new HashSet<Scope>();
                }
                this.scopes.add(scope);
            }
            return this;
        }

        public Params setRawScope(String rawScope) {
            this.rawScope = rawScope;
            return this;
        }

        public Params setInstanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public byte[] build() {
            PostRequestBodyBuffer buffer = new PostRequestBodyBuffer();
            String scopeName = "scope";
            if (Strings.isNullOrEmpty(this.rawScope)) {
                if (this.scopes != null) {
                    buffer.addParam("scope", Scope.createScopeParameter(this.scopes.iterator()));
                }
            } else {
                buffer.addParam("scope", this.rawScope);
            }
            return buffer.addParamIfNotNull("client_id", this.clientId).addParamIfNotNull("response_type", this.responseType).addParamIfNotNull("redirect_uri", this.redirectUri).addParamIfNotNull("instance_name", this.instanceName).toByteArray();
        }

        private Params setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }
    }
}

