/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.net;

import com.yandex.money.api.exceptions.InsufficientScopeException;
import com.yandex.money.api.exceptions.InvalidRequestException;
import com.yandex.money.api.exceptions.InvalidTokenException;
import com.yandex.money.api.net.AbstractSession;
import com.yandex.money.api.net.ApiClient;
import com.yandex.money.api.net.HostsProvider;
import com.yandex.money.api.net.MethodRequest;
import com.yandex.money.api.net.OAuth2Authorization;
import com.yandex.money.api.net.PostRequestBodyBuffer;
import com.yandex.money.api.utils.Streams;
import com.yandex.money.api.utils.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;

public class OAuth2Session
extends AbstractSession {
    private String accessToken;

    public OAuth2Session(ApiClient client) {
        super(client);
    }

    public <T> T execute(MethodRequest<T> request) throws IOException, InvalidRequestException, InvalidTokenException, InsufficientScopeException {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        HostsProvider hostsProvider = this.client.getHostsProvider();
        HttpURLConnection connection = this.openConnection(request.requestURL(hostsProvider));
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            PostRequestBodyBuffer parameters = request.buildParameters();
            if (parameters == null) {
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Length", "0");
            } else {
                parameters.setHttpHeaders(connection);
            }
            if (this.isAuthorized()) {
                connection.setRequestProperty("Authorization", "Bearer " + this.accessToken);
            }
            if (parameters != null) {
                outputStream = connection.getOutputStream();
                parameters.write(outputStream);
                outputStream.close();
                outputStream = null;
            }
            switch (connection.getResponseCode()) {
                case 200: {
                    inputStream = this.getInputStream(connection);
                    if (this.isJsonType(connection)) {
                        T t = request.parseResponse(inputStream);
                        return t;
                    }
                    Streams.readStreamToNull(inputStream);
                    throw new IOException("Server has responded with a wrong content type");
                }
                case 400: {
                    throw new InvalidRequestException(this.processError(connection));
                }
                case 401: {
                    throw new InvalidTokenException(this.processError(connection));
                }
                case 403: {
                    throw new InsufficientScopeException(this.processError(connection));
                }
            }
            throw new IOException(this.processError(connection));
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public boolean isAuthorized() {
        return !Strings.isNullOrEmpty(this.accessToken);
    }

    public OAuth2Authorization createOAuth2Authorization() {
        return new OAuth2Authorization(this.client);
    }

    private boolean isJsonType(HttpURLConnection connection) {
        String field = connection.getHeaderField("Content-Type");
        return field != null && field.startsWith("application/json");
    }
}

