/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.net;

import com.yandex.money.api.utils.Streams;
import com.yandex.money.api.utils.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;
import org.joda.time.DateTime;

public class PostRequestBodyBuffer
extends ByteArrayOutputStream {
    private static final Charset REQUEST_CHARSET_UTF8 = Charset.forName("UTF-8");
    private static final byte[] POST_PARAM_DELIMITER = "&".getBytes(REQUEST_CHARSET_UTF8);
    private static final byte[] POST_PARAM_NV_DELIMITER = "=".getBytes(REQUEST_CHARSET_UTF8);
    private String contentType = "application/x-www-form-urlencoded";

    public PostRequestBodyBuffer addParam(String name, int value) {
        return this.addParam(name, Integer.toString(value));
    }

    public PostRequestBodyBuffer addParam(String name, String value) {
        if (value == null) {
            value = "";
        }
        try {
            return this.addParamWithoutURLEncoding(URLEncoder.encode(name, REQUEST_CHARSET_UTF8.name()).getBytes(REQUEST_CHARSET_UTF8), URLEncoder.encode(value, REQUEST_CHARSET_UTF8.name()).replace("+", "%20").getBytes(REQUEST_CHARSET_UTF8));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public PostRequestBodyBuffer addParams(Map<String, String> params) {
        if (params == null) {
            throw new NullPointerException("params is null");
        }
        for (Map.Entry<String, String> entry : params.entrySet()) {
            this.addParam(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public PostRequestBodyBuffer addParamIfNotNull(String name, Integer value) {
        return value != null ? this.addParam(name, value.toString()) : this;
    }

    public PostRequestBodyBuffer addParamIfNotNull(String name, Boolean value) {
        return value != null ? this.addParam(name, value.toString()) : this;
    }

    public PostRequestBodyBuffer addParamIfNotNull(String name, String value) {
        return value != null ? this.addParam(name, value) : this;
    }

    public PostRequestBodyBuffer addParamIfNotNull(String name, BigDecimal value) {
        return value != null ? this.addParam(name, value.toPlainString()) : this;
    }

    public PostRequestBodyBuffer addDateTimeIfNotNull(String name, DateTime value) {
        if (value != null) {
            return this.addParam(name, value.toString());
        }
        return this;
    }

    public PostRequestBodyBuffer addBooleanIfTrue(String name, Boolean value) {
        if (value != null && value.booleanValue()) {
            return this.addParam(name, "true");
        }
        return this;
    }

    public PostRequestBodyBuffer addParamWithoutURLEncoding(byte[] name, byte[] value) {
        try {
            if (this.size() > 0) {
                this.write(POST_PARAM_DELIMITER);
            }
            this.write(name);
            this.write(POST_PARAM_NV_DELIMITER);
            this.write(value);
            return this;
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public PostRequestBodyBuffer addContent(InputStream inputStream) {
        try {
            Streams.copy(inputStream, this);
            return this;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public PostRequestBodyBuffer setContentType(String contentType) {
        if (Strings.isNullOrEmpty(contentType)) {
            throw new IllegalArgumentException("contentType should not be null or empty");
        }
        this.contentType = contentType;
        return this;
    }

    public void setHttpHeaders(HttpURLConnection connection) throws ProtocolException {
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", this.contentType);
        connection.setFixedLengthStreamingMode(this.size());
    }

    public void write(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }
}

