/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.net;

import com.yandex.money.api.utils.Numbers;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.logging.Logger;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

final class WireLoggingSocketFactory
extends SSLSocketFactory {
    private static final Logger LOG = Logger.getLogger(WireLoggingSocketFactory.class.getName());
    private final SSLSocketFactory delegate;

    WireLoggingSocketFactory(SSLSocketFactory sf0) {
        this.delegate = sf0;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        LOG.info("Creating socket: " + host + ":" + port);
        return new WireLogSocket((SSLSocket)this.delegate.createSocket(s, host, port, autoClose));
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException {
        LOG.info("Creating socket: " + s + ":" + i);
        return new WireLogSocket((SSLSocket)this.delegate.createSocket(s, i));
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inetAddress, int i2) throws IOException {
        LOG.info("Creating socket: " + inetAddress);
        return new WireLogSocket((SSLSocket)this.delegate.createSocket(s, i, inetAddress, i2));
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
        LOG.info("Creating socket: " + inetAddress);
        return new WireLogSocket((SSLSocket)this.delegate.createSocket(inetAddress, i));
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress2, int i2) throws IOException {
        LOG.info("Creating socket: " + inetAddress);
        return new WireLogSocket((SSLSocket)this.delegate.createSocket(inetAddress, i, inetAddress2, i2));
    }

    private static class WireLogSocket
    extends SSLSocket {
        private final SSLSocket delegate;

        public WireLogSocket(SSLSocket s) {
            this.delegate = s;
        }

        private static void logWire(String prefix, byte[] data, int off, int len) throws IOException {
            StringBuilder buffer = new StringBuilder(prefix).append(" block buffer ").append(data.length).append(" offset ").append(off).append(" length ").append(len).append('\n');
            for (int i = 0; i < len; ++i) {
                byte b = data[off + i];
                if (b == 13) {
                    buffer.append("[\\r]");
                    continue;
                }
                if (b == 10) {
                    buffer.append("[\\n]\n");
                    continue;
                }
                if (b < 32 || b > 127) {
                    buffer.append(" ").append(Numbers.byteToHex(b));
                    continue;
                }
                buffer.append((char)b);
            }
            LOG.info(buffer.toString());
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return new LoggingOutputStream(this.delegate.getOutputStream());
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new LoggingInputStream(this.delegate.getInputStream());
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        public String[] getEnabledCipherSuites() {
            return this.delegate.getEnabledCipherSuites();
        }

        @Override
        public void setEnabledCipherSuites(String[] strings) {
            this.delegate.setEnabledCipherSuites(strings);
        }

        @Override
        public String[] getSupportedProtocols() {
            return this.delegate.getSupportedProtocols();
        }

        @Override
        public String[] getEnabledProtocols() {
            return this.delegate.getEnabledProtocols();
        }

        @Override
        public void setEnabledProtocols(String[] strings) {
            this.delegate.setEnabledProtocols(strings);
        }

        @Override
        public SSLSession getSession() {
            return this.delegate.getSession();
        }

        @Override
        public void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
            this.delegate.addHandshakeCompletedListener(handshakeCompletedListener);
        }

        @Override
        public void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
            this.delegate.removeHandshakeCompletedListener(handshakeCompletedListener);
        }

        @Override
        public void startHandshake() throws IOException {
            this.delegate.startHandshake();
        }

        @Override
        public boolean getUseClientMode() {
            return this.delegate.getUseClientMode();
        }

        @Override
        public void setUseClientMode(boolean b) {
            this.delegate.setUseClientMode(b);
        }

        @Override
        public boolean getNeedClientAuth() {
            return this.delegate.getNeedClientAuth();
        }

        @Override
        public void setNeedClientAuth(boolean b) {
            this.delegate.setNeedClientAuth(b);
        }

        @Override
        public boolean getWantClientAuth() {
            return this.delegate.getWantClientAuth();
        }

        @Override
        public void setWantClientAuth(boolean b) {
            this.delegate.setWantClientAuth(b);
        }

        @Override
        public boolean getEnableSessionCreation() {
            return this.delegate.getEnableSessionCreation();
        }

        @Override
        public void setEnableSessionCreation(boolean b) {
            this.delegate.setEnableSessionCreation(b);
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        @Override
        public InetAddress getInetAddress() {
            return this.delegate.getInetAddress();
        }

        @Override
        public boolean getKeepAlive() throws SocketException {
            return this.delegate.getKeepAlive();
        }

        @Override
        public InetAddress getLocalAddress() {
            return this.delegate.getLocalAddress();
        }

        @Override
        public int getLocalPort() {
            return this.delegate.getLocalPort();
        }

        @Override
        public int getPort() {
            return this.delegate.getPort();
        }

        @Override
        public int getSoLinger() throws SocketException {
            return this.delegate.getSoLinger();
        }

        @Override
        public int getReceiveBufferSize() throws SocketException {
            return this.delegate.getReceiveBufferSize();
        }

        @Override
        public int getSendBufferSize() throws SocketException {
            return this.delegate.getSendBufferSize();
        }

        @Override
        public int getSoTimeout() throws SocketException {
            return this.delegate.getSoTimeout();
        }

        @Override
        public boolean getTcpNoDelay() throws SocketException {
            return this.delegate.getTcpNoDelay();
        }

        @Override
        public void setKeepAlive(boolean keepAlive) throws SocketException {
            this.delegate.setKeepAlive(keepAlive);
        }

        @Override
        public void setSendBufferSize(int size) throws SocketException {
            this.delegate.setSendBufferSize(size);
        }

        @Override
        public void setReceiveBufferSize(int size) throws SocketException {
            this.delegate.setReceiveBufferSize(size);
        }

        @Override
        public void setSoLinger(boolean on, int timeout) throws SocketException {
            this.delegate.setSoLinger(on, timeout);
        }

        @Override
        public void setSoTimeout(int timeout) throws SocketException {
            this.delegate.setSoTimeout(timeout);
        }

        @Override
        public void setTcpNoDelay(boolean on) throws SocketException {
            this.delegate.setTcpNoDelay(on);
        }

        @Override
        public String toString() {
            return "WireLogSocket={" + this.delegate.toString() + '}';
        }

        @Override
        public void shutdownInput() throws IOException {
            this.delegate.shutdownInput();
        }

        @Override
        public void shutdownOutput() throws IOException {
            this.delegate.shutdownOutput();
        }

        @Override
        public SocketAddress getLocalSocketAddress() {
            return this.delegate.getLocalSocketAddress();
        }

        @Override
        public SocketAddress getRemoteSocketAddress() {
            return this.delegate.getRemoteSocketAddress();
        }

        @Override
        public boolean isBound() {
            return this.delegate.isBound();
        }

        @Override
        public boolean isConnected() {
            return this.delegate.isConnected();
        }

        @Override
        public boolean isClosed() {
            return this.delegate.isClosed();
        }

        @Override
        public void bind(SocketAddress localAddr) throws IOException {
            this.delegate.bind(localAddr);
        }

        @Override
        public void connect(SocketAddress remoteAddr) throws IOException {
            this.delegate.connect(remoteAddr);
        }

        @Override
        public void connect(SocketAddress remoteAddr, int timeout) throws IOException {
            this.delegate.connect(remoteAddr, timeout);
        }

        @Override
        public boolean isInputShutdown() {
            return this.delegate.isInputShutdown();
        }

        @Override
        public boolean isOutputShutdown() {
            return this.delegate.isOutputShutdown();
        }

        @Override
        public void setReuseAddress(boolean reuse) throws SocketException {
            this.delegate.setReuseAddress(reuse);
        }

        @Override
        public boolean getReuseAddress() throws SocketException {
            return this.delegate.getReuseAddress();
        }

        @Override
        public void setOOBInline(boolean oobinline) throws SocketException {
            this.delegate.setOOBInline(oobinline);
        }

        @Override
        public boolean getOOBInline() throws SocketException {
            return this.delegate.getOOBInline();
        }

        @Override
        public void setTrafficClass(int value) throws SocketException {
            this.delegate.setTrafficClass(value);
        }

        @Override
        public int getTrafficClass() throws SocketException {
            return this.delegate.getTrafficClass();
        }

        @Override
        public void sendUrgentData(int value) throws IOException {
            this.delegate.sendUrgentData(value);
        }

        @Override
        public SocketChannel getChannel() {
            return this.delegate.getChannel();
        }

        @Override
        public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
            this.delegate.setPerformancePreferences(connectionTime, latency, bandwidth);
        }

        private static class LoggingInputStream
        extends FilterInputStream {
            public LoggingInputStream(InputStream out) {
                super(out);
            }

            @Override
            public int read() throws IOException {
                int b = this.in.read();
                if (b >= 0) {
                    WireLogSocket.logWire("READ:", new byte[]{(byte)b}, 0, 1);
                }
                return b;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int result = this.in.read(b, off, len);
                if (result > 0) {
                    WireLogSocket.logWire("READ:", b, off, result);
                }
                return result;
            }
        }

        private static class LoggingOutputStream
        extends FilterOutputStream {
            public LoggingOutputStream(OutputStream out) {
                super(out);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
                WireLogSocket.logWire("WRITE:", b, off, len);
            }

            @Override
            public void write(int b) throws IOException {
                this.out.write(b);
                WireLogSocket.logWire("WRITE:", new byte[]{(byte)b}, 0, 1);
            }
        }
    }
}

