/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.utils;

import com.yandex.money.api.utils.Strings;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public enum Language {
    ENGLISH("en"),
    RUSSIAN("ru");

    private static final Set<String> cisIso6391Codes;
    private final String iso6391Code;

    private Language(String iso6391Code) {
        this.iso6391Code = iso6391Code;
    }

    public static Language getDefault() {
        Locale locale = Locale.getDefault();
        for (Language value : Language.values()) {
            if (!value.iso6391Code.equals(locale.getLanguage())) continue;
            return value;
        }
        return Language.getSupported(locale.getLanguage());
    }

    public static Language getSupported(String iso6391Code) {
        if (Strings.isNullOrEmpty(iso6391Code)) {
            throw new IllegalArgumentException("ISO-639-1 code can not be null or empty");
        }
        for (Language value : Language.values()) {
            if (!value.iso6391Code.equals(iso6391Code)) continue;
            return value;
        }
        return Language.isCis(iso6391Code) ? RUSSIAN : ENGLISH;
    }

    public String getIso6391Code() {
        return this.iso6391Code;
    }

    private static boolean isCis(String iso6391Code) {
        return cisIso6391Codes.contains(iso6391Code);
    }

    static {
        HashSet<String> codes = new HashSet<String>();
        codes.add("ab");
        codes.add("az");
        codes.add("hy");
        codes.add("by");
        codes.add("bg");
        codes.add("ge");
        codes.add("kk");
        codes.add("ky");
        codes.add("lv");
        codes.add("lt");
        codes.add("mo");
        codes.add("pl");
        codes.add("ru");
        codes.add("ro");
        codes.add("tg");
        codes.add("tk");
        codes.add("uz");
        codes.add("uk");
        codes.add("et");
        cisIso6391Codes = Collections.unmodifiableSet(codes);
    }
}

