/*
 * Decompiled with CFR 0.152.
 */
package com.yandex.money.api.utils;

public final class Strings {
    private Strings() {
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static boolean containsDigitsOnly(String value) {
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        return value.matches("\\d*");
    }

    public static String concatenate(String[] array, String splitter) {
        if (array == null) {
            throw new NullPointerException("array is null");
        }
        if (splitter == null) {
            throw new NullPointerException("splitter is null");
        }
        if (array.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(array[0]);
        for (int i = 1; i < array.length; ++i) {
            sb.append(splitter).append(array[i]);
        }
        return sb.toString();
    }

    public static String[] split(String str, int n) {
        if (str == null) {
            throw new NullPointerException("str is null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("n should be greater than 0");
        }
        int length = str.length();
        String[] result = new String[length / n + (length % n == 0 ? 0 : 1)];
        for (int i = 0; i < result.length; ++i) {
            int beginIndex = i * n;
            int endIndex = (i + 1) * n;
            result[i] = str.substring(beginIndex, endIndex < length ? endIndex : length);
        }
        return result;
    }

    public static String group(String str, int groupSize, String separator) {
        String[] split = Strings.split(str, groupSize);
        return Strings.concatenate(split, separator);
    }
}

