/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.JsonElement;
import io.gsonfire.GsonFireBuilder;
import io.gsonfire.TypeSelector;

import okio.ByteString;

import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.HashMap;

/*
 * A JSON utility class
 *
 * NOTE: in the future, this class may be converted to static, which may break
 *       backward-compatibility
 */
public class JSON {
    private static Gson gson;
    private static boolean isLenientOnJson = false;
    private static DateTypeAdapter dateTypeAdapter = new DateTypeAdapter();
    private static SqlDateTypeAdapter sqlDateTypeAdapter = new SqlDateTypeAdapter();
    private static ByteArrayAdapter byteArrayAdapter = new ByteArrayAdapter();

    @SuppressWarnings("unchecked")
    public static GsonBuilder createGson() {
        GsonFireBuilder fireBuilder = new GsonFireBuilder()
        ;
        GsonBuilder builder = fireBuilder.createGsonBuilder();
        builder.disableHtmlEscaping();
        return builder;
    }

    private static String getDiscriminatorValue(JsonElement readElement, String discriminatorField) {
        JsonElement element = readElement.getAsJsonObject().get(discriminatorField);
        if (null == element) {
            throw new IllegalArgumentException("missing discriminator field: <" + discriminatorField + ">");
        }
        return element.getAsString();
    }

    /**
     * Returns the Java class that implements the OpenAPI schema for the specified discriminator value.
     *
     * @param classByDiscriminatorValue The map of discriminator values to Java classes.
     * @param discriminatorValue The value of the OpenAPI discriminator in the input data.
     * @return The Java class that implements the OpenAPI schema
     */
    private static Class getClassByDiscriminator(Map classByDiscriminatorValue, String discriminatorValue) {
        Class clazz = (Class) classByDiscriminatorValue.get(discriminatorValue);
        if (null == clazz) {
            throw new IllegalArgumentException("cannot determine model class of name: <" + discriminatorValue + ">");
        }
        return clazz;
    }

    {
        GsonBuilder gsonBuilder = createGson();
        gsonBuilder.registerTypeAdapter(Date.class, dateTypeAdapter);
        gsonBuilder.registerTypeAdapter(java.sql.Date.class, sqlDateTypeAdapter);
        gsonBuilder.registerTypeAdapter(byte[].class, byteArrayAdapter);
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.Balance.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.Contact.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.ContactCreateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.ContactCustomAttribute.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.ContactPage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.ContactUpdateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.CustomEventDefinition.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.CustomEventDefinitionCreateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.CustomEventDefinitionProperty.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.CustomEventDefinitionPropertyCreateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.CustomEventDefinitionPropertyUpdateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.CustomEventDefinitionUpdateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.CustomEventSendRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.Email.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.EmailDelivery.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.EmailSendRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.Error.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.ErrorResponse.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.Event.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.Mailbox.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.Page.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.PageCursor.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.Sms.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.SmsInbound.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.SmsPage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.SmsSendRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.Unsubscriber.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.UnsubscriberCreateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.UnsubscriberPage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.Verification.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.VerificationCheck.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.VerificationCheckRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.VerificationFallback.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.VerificationSendRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.Voice.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.VoicePage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.VoiceSendRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WebhookEndpoint.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WebhookEndpointCreateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WebhookEndpointPage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WebhookEndpointUpdateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappApiError.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappAuthIntlRateEligibilityCountry.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappBusinessAccount.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappBusinessAccountPage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappBusinessAccountRestrictionInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappCommerceSettings.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappCommerceSettingsUpdateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappConversation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappInboundMessage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappInboundMessageButton.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappInboundMessageContext.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappInboundMessageError.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappInboundMessageInteractive.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappInboundMessageInteractiveButtonReply.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappInboundMessageInteractiveListReply.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappInboundMessageLocation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappInboundMessageMedia.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappInboundMessageOrder.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappInboundMessageOrderProductItem.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappInboundMessageReferral.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappInboundMessageReferredProduct.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappInboundMessageSystem.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappInboundMessageText.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageContact.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageContactAddress.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageContactEmail.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageContactName.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageContactOrg.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageContactPhone.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageContactUrl.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageContext.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageInteractive.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageInteractiveAction.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageInteractiveActionButton.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageInteractiveActionButtonReply.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageInteractiveActionParameters.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageInteractiveActionParametersFlowActionPayload.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageInteractiveActionSection.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageInteractiveActionSectionProductItem.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageInteractiveActionSectionRow.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageInteractiveBody.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageInteractiveFooter.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageInteractiveHeader.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageLocation.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageMedia.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageOrderAmount.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageOrderBeneficiary.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageOrderDetails.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageOrderExpiration.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageOrderInfo.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageOrderItem.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageOrderPaymentGateway.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageOrderPaymentSetting.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageOrderPaymentSettingPaymentGatewayBilldesk.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageOrderPaymentSettingPaymentGatewayPayu.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageOrderPaymentSettingPaymentGatewayRazorpay.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageOrderPaymentSettingPaymentGatewayZaakpay.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageOrderStatus.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageReaction.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageSendRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageTemplate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageTemplateComponent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageTemplateComponentCard.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageTemplateComponentCardComponent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageTemplateComponentParameter.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageTemplateComponentParameterAction.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageTemplateComponentParameterActionSection.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageTemplateComponentParameterActionSectionProductItem.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageTemplateComponentParameterLimitedTimeOffer.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageTemplateLanguage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappMessageText.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappPayment.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappPaymentTransaction.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappPaymentTransactionError.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappPhoneNumber.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappPhoneNumberPage.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappPhoneNumberProfile.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappPhoneNumberProfileUpdateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappProfile.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappTemplate.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappTemplateComponent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappTemplateComponentButton.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappTemplateComponentCard.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappTemplateComponentCardComponent.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappTemplateComponentExample.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappTemplateComponentLimitedTimeOffer.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappTemplateCreateRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappTemplateEditRequest.CustomTypeAdapterFactory());
        gsonBuilder.registerTypeAdapterFactory(new com.ycloud.client.model.WhatsappTemplatePage.CustomTypeAdapterFactory());
        gson = gsonBuilder.create();
    }

    /**
     * Get Gson.
     *
     * @return Gson
     */
    public static Gson getGson() {
        return gson;
    }

    /**
     * Set Gson.
     *
     * @param gson Gson
     */
    public static void setGson(Gson gson) {
        JSON.gson = gson;
    }

    public static void setLenientOnJson(boolean lenientOnJson) {
        isLenientOnJson = lenientOnJson;
    }

    /**
     * Serialize the given Java object into JSON string.
     *
     * @param obj Object
     * @return String representation of the JSON
     */
    public static String serialize(Object obj) {
        return gson.toJson(obj);
    }

    /**
     * Deserialize the given JSON string to Java object.
     *
     * @param <T>        Type
     * @param body       The JSON string
     * @param returnType The type to deserialize into
     * @return The deserialized Java object
     */
    @SuppressWarnings("unchecked")
    public static <T> T deserialize(String body, Type returnType) {
        try {
            if (isLenientOnJson) {
                JsonReader jsonReader = new JsonReader(new StringReader(body));
                // see https://google-gson.googlecode.com/svn/trunk/gson/docs/javadocs/com/google/gson/stream/JsonReader.html#setLenient(boolean)
                jsonReader.setLenient(true);
                return gson.fromJson(jsonReader, returnType);
            } else {
                return gson.fromJson(body, returnType);
            }
        } catch (JsonParseException e) {
            // Fallback processing when failed to parse JSON form response body:
            // return the response body string directly for the String return type;
            if (returnType.equals(String.class)) {
                return (T) body;
            } else {
                throw (e);
            }
        }
    }

    /**
     * Gson TypeAdapter for Byte Array type
     */
    public static class ByteArrayAdapter extends TypeAdapter<byte[]> {

        @Override
        public void write(JsonWriter out, byte[] value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(ByteString.of(value).base64());
            }
        }

        @Override
        public byte[] read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String bytesAsBase64 = in.nextString();
                    ByteString byteString = ByteString.decodeBase64(bytesAsBase64);
                    return byteString.toByteArray();
            }
        }
    }

    /**
     * Gson TypeAdapter for java.sql.Date type
     * If the dateFormat is null, a simple "yyyy-MM-dd" format will be used
     * (more efficient than SimpleDateFormat).
     */
    public static class SqlDateTypeAdapter extends TypeAdapter<java.sql.Date> {

        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {}

        public SqlDateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, java.sql.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value;
                if (dateFormat != null) {
                    value = dateFormat.format(date);
                } else {
                    value = date.toString();
                }
                out.value(value);
            }
        }

        @Override
        public java.sql.Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    try {
                        if (dateFormat != null) {
                            return new java.sql.Date(dateFormat.parse(date).getTime());
                        }
                        return new java.sql.Date(ISO8601Utils.parse(date, new ParsePosition(0)).getTime());
                    } catch (ParseException e) {
                        throw new JsonParseException(e);
                    }
            }
        }
    }

    /**
     * Gson TypeAdapter for java.util.Date type
     * If the dateFormat is null, ISO8601Utils will be used.
     */
    public static class DateTypeAdapter extends TypeAdapter<Date> {

        private DateFormat dateFormat;

        public DateTypeAdapter() {}

        public DateTypeAdapter(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value;
                if (dateFormat != null) {
                    value = dateFormat.format(date);
                } else {
                    value = ISO8601Utils.format(date, true);
                }
                out.value(value);
            }
        }

        @Override
        public Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL:
                        in.nextNull();
                        return null;
                    default:
                        String date = in.nextString();
                        try {
                            if (dateFormat != null) {
                                return dateFormat.parse(date);
                            }
                            return ISO8601Utils.parse(date, new ParsePosition(0));
                        } catch (ParseException e) {
                            throw new JsonParseException(e);
                        }
                }
            } catch (IllegalArgumentException e) {
                throw new JsonParseException(e);
            }
        }
    }

    public static void setDateFormat(DateFormat dateFormat) {
        dateTypeAdapter.setFormat(dateFormat);
    }

    public static void setSqlDateFormat(DateFormat dateFormat) {
        sqlDateTypeAdapter.setFormat(dateFormat);
    }
}
