/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.api;

import com.ycloud.client.ApiCallback;
import com.ycloud.client.ApiClient;
import com.ycloud.client.ApiException;
import com.ycloud.client.ApiResponse;
import com.ycloud.client.Configuration;
import com.ycloud.client.Pair;
import com.ycloud.client.ProgressRequestBody;
import com.ycloud.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.ycloud.client.model.CustomEventDefinition;
import com.ycloud.client.model.CustomEventDefinitionCreateRequest;
import com.ycloud.client.model.CustomEventDefinitionProperty;
import com.ycloud.client.model.CustomEventDefinitionPropertyCreateRequest;
import com.ycloud.client.model.CustomEventDefinitionPropertyUpdateRequest;
import com.ycloud.client.model.CustomEventDefinitionUpdateRequest;
import com.ycloud.client.model.CustomEventSendRequest;
import com.ycloud.client.model.ErrorResponse;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class CustomEventsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public CustomEventsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomEventsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for createDefinition
     * @param customEventDefinitionCreateRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully created an event definition. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createDefinitionCall(CustomEventDefinitionCreateRequest customEventDefinitionCreateRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = customEventDefinitionCreateRequest;

        // create path and map variables
        String localVarPath = "/event/definitions";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createDefinitionValidateBeforeCall(CustomEventDefinitionCreateRequest customEventDefinitionCreateRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'customEventDefinitionCreateRequest' is set
        if (customEventDefinitionCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'customEventDefinitionCreateRequest' when calling createDefinition(Async)");
        }
        

        okhttp3.Call localVarCall = createDefinitionCall(customEventDefinitionCreateRequest, _callback);
        return localVarCall;

    }

    /**
     * Create an event definition
     * <p>
     * Creates a custom event definition.
     * @param customEventDefinitionCreateRequest  (required)
     * @return CustomEventDefinition
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully created an event definition. </td><td>  -  </td></tr>
     </table>
     */
    public CustomEventDefinition createDefinition(CustomEventDefinitionCreateRequest customEventDefinitionCreateRequest) throws ApiException {
        ApiResponse<CustomEventDefinition> localVarResp = createDefinitionWithHttpInfo(customEventDefinitionCreateRequest);
        return localVarResp.getData();
    }

    /**
     * Create an event definition
     * <p>
     * Creates a custom event definition.
     * @param customEventDefinitionCreateRequest  (required)
     * @return ApiResponse&lt;CustomEventDefinition&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully created an event definition. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CustomEventDefinition> createDefinitionWithHttpInfo(CustomEventDefinitionCreateRequest customEventDefinitionCreateRequest) throws ApiException {
        okhttp3.Call localVarCall = createDefinitionValidateBeforeCall(customEventDefinitionCreateRequest, null);
        Type localVarReturnType = new TypeToken<CustomEventDefinition>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an event definition (asynchronously)
     * <p>
     * Creates a custom event definition.
     * @param customEventDefinitionCreateRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully created an event definition. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createDefinitionAsync(CustomEventDefinitionCreateRequest customEventDefinitionCreateRequest, final ApiCallback<CustomEventDefinition> _callback) throws ApiException {

        okhttp3.Call localVarCall = createDefinitionValidateBeforeCall(customEventDefinitionCreateRequest, _callback);
        Type localVarReturnType = new TypeToken<CustomEventDefinition>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for createPropertyDefinition
     * @param name Name of the custom event. (required)
     * @param customEventDefinitionPropertyCreateRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully created an event property. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createPropertyDefinitionCall(String name, CustomEventDefinitionPropertyCreateRequest customEventDefinitionPropertyCreateRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = customEventDefinitionPropertyCreateRequest;

        // create path and map variables
        String localVarPath = "/event/definitions/{name}/properties"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createPropertyDefinitionValidateBeforeCall(String name, CustomEventDefinitionPropertyCreateRequest customEventDefinitionPropertyCreateRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling createPropertyDefinition(Async)");
        }
        
        // verify the required parameter 'customEventDefinitionPropertyCreateRequest' is set
        if (customEventDefinitionPropertyCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'customEventDefinitionPropertyCreateRequest' when calling createPropertyDefinition(Async)");
        }
        

        okhttp3.Call localVarCall = createPropertyDefinitionCall(name, customEventDefinitionPropertyCreateRequest, _callback);
        return localVarCall;

    }

    /**
     * Create an event property definition
     * <p>
     * Defines a new property for the event definition.
     * @param name Name of the custom event. (required)
     * @param customEventDefinitionPropertyCreateRequest  (required)
     * @return CustomEventDefinitionProperty
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully created an event property. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public CustomEventDefinitionProperty createPropertyDefinition(String name, CustomEventDefinitionPropertyCreateRequest customEventDefinitionPropertyCreateRequest) throws ApiException {
        ApiResponse<CustomEventDefinitionProperty> localVarResp = createPropertyDefinitionWithHttpInfo(name, customEventDefinitionPropertyCreateRequest);
        return localVarResp.getData();
    }

    /**
     * Create an event property definition
     * <p>
     * Defines a new property for the event definition.
     * @param name Name of the custom event. (required)
     * @param customEventDefinitionPropertyCreateRequest  (required)
     * @return ApiResponse&lt;CustomEventDefinitionProperty&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully created an event property. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CustomEventDefinitionProperty> createPropertyDefinitionWithHttpInfo(String name, CustomEventDefinitionPropertyCreateRequest customEventDefinitionPropertyCreateRequest) throws ApiException {
        okhttp3.Call localVarCall = createPropertyDefinitionValidateBeforeCall(name, customEventDefinitionPropertyCreateRequest, null);
        Type localVarReturnType = new TypeToken<CustomEventDefinitionProperty>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an event property definition (asynchronously)
     * <p>
     * Defines a new property for the event definition.
     * @param name Name of the custom event. (required)
     * @param customEventDefinitionPropertyCreateRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully created an event property. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createPropertyDefinitionAsync(String name, CustomEventDefinitionPropertyCreateRequest customEventDefinitionPropertyCreateRequest, final ApiCallback<CustomEventDefinitionProperty> _callback) throws ApiException {

        okhttp3.Call localVarCall = createPropertyDefinitionValidateBeforeCall(name, customEventDefinitionPropertyCreateRequest, _callback);
        Type localVarReturnType = new TypeToken<CustomEventDefinitionProperty>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for propertyDefinition
     * @param name Name of the custom event. (required)
     * @param propertyName Name of the custom event property. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully deleted the event property definition. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call propertyDefinitionCall(String name, String propertyName, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/event/definitions/{name}/properties/{propertyName}"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()))
            .replaceAll("\\{" + "propertyName" + "\\}", localVarApiClient.escapeString(propertyName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call propertyDefinitionValidateBeforeCall(String name, String propertyName, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling propertyDefinition(Async)");
        }
        
        // verify the required parameter 'propertyName' is set
        if (propertyName == null) {
            throw new ApiException("Missing the required parameter 'propertyName' when calling propertyDefinition(Async)");
        }
        

        okhttp3.Call localVarCall = propertyDefinitionCall(name, propertyName, _callback);
        return localVarCall;

    }

    /**
     * Delete an event property definition
     * <p>
     * Deletes a property of the event definition.
     * @param name Name of the custom event. (required)
     * @param propertyName Name of the custom event property. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully deleted the event property definition. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public void propertyDefinition(String name, String propertyName) throws ApiException {
        propertyDefinitionWithHttpInfo(name, propertyName);
    }

    /**
     * Delete an event property definition
     * <p>
     * Deletes a property of the event definition.
     * @param name Name of the custom event. (required)
     * @param propertyName Name of the custom event property. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully deleted the event property definition. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> propertyDefinitionWithHttpInfo(String name, String propertyName) throws ApiException {
        okhttp3.Call localVarCall = propertyDefinitionValidateBeforeCall(name, propertyName, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Delete an event property definition (asynchronously)
     * <p>
     * Deletes a property of the event definition.
     * @param name Name of the custom event. (required)
     * @param propertyName Name of the custom event property. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully deleted the event property definition. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call propertyDefinitionAsync(String name, String propertyName, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = propertyDefinitionValidateBeforeCall(name, propertyName, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for propertyDefinition_0
     * @param name Name of the custom event. (required)
     * @param propertyName Name of the custom event property. (required)
     * @param customEventDefinitionPropertyUpdateRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully updated the event property definition. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call propertyDefinition_0Call(String name, String propertyName, CustomEventDefinitionPropertyUpdateRequest customEventDefinitionPropertyUpdateRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = customEventDefinitionPropertyUpdateRequest;

        // create path and map variables
        String localVarPath = "/event/definitions/{name}/properties/{propertyName}"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()))
            .replaceAll("\\{" + "propertyName" + "\\}", localVarApiClient.escapeString(propertyName.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call propertyDefinition_0ValidateBeforeCall(String name, String propertyName, CustomEventDefinitionPropertyUpdateRequest customEventDefinitionPropertyUpdateRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling propertyDefinition_0(Async)");
        }
        
        // verify the required parameter 'propertyName' is set
        if (propertyName == null) {
            throw new ApiException("Missing the required parameter 'propertyName' when calling propertyDefinition_0(Async)");
        }
        
        // verify the required parameter 'customEventDefinitionPropertyUpdateRequest' is set
        if (customEventDefinitionPropertyUpdateRequest == null) {
            throw new ApiException("Missing the required parameter 'customEventDefinitionPropertyUpdateRequest' when calling propertyDefinition_0(Async)");
        }
        

        okhttp3.Call localVarCall = propertyDefinition_0Call(name, propertyName, customEventDefinitionPropertyUpdateRequest, _callback);
        return localVarCall;

    }

    /**
     * Update an event property definition
     * <p>
     * Updates an event property definition&#39;s label and description.
     * @param name Name of the custom event. (required)
     * @param propertyName Name of the custom event property. (required)
     * @param customEventDefinitionPropertyUpdateRequest  (required)
     * @return CustomEventDefinitionProperty
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully updated the event property definition. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public CustomEventDefinitionProperty propertyDefinition_0(String name, String propertyName, CustomEventDefinitionPropertyUpdateRequest customEventDefinitionPropertyUpdateRequest) throws ApiException {
        ApiResponse<CustomEventDefinitionProperty> localVarResp = propertyDefinition_0WithHttpInfo(name, propertyName, customEventDefinitionPropertyUpdateRequest);
        return localVarResp.getData();
    }

    /**
     * Update an event property definition
     * <p>
     * Updates an event property definition&#39;s label and description.
     * @param name Name of the custom event. (required)
     * @param propertyName Name of the custom event property. (required)
     * @param customEventDefinitionPropertyUpdateRequest  (required)
     * @return ApiResponse&lt;CustomEventDefinitionProperty&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully updated the event property definition. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CustomEventDefinitionProperty> propertyDefinition_0WithHttpInfo(String name, String propertyName, CustomEventDefinitionPropertyUpdateRequest customEventDefinitionPropertyUpdateRequest) throws ApiException {
        okhttp3.Call localVarCall = propertyDefinition_0ValidateBeforeCall(name, propertyName, customEventDefinitionPropertyUpdateRequest, null);
        Type localVarReturnType = new TypeToken<CustomEventDefinitionProperty>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update an event property definition (asynchronously)
     * <p>
     * Updates an event property definition&#39;s label and description.
     * @param name Name of the custom event. (required)
     * @param propertyName Name of the custom event property. (required)
     * @param customEventDefinitionPropertyUpdateRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully updated the event property definition. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call propertyDefinition_0Async(String name, String propertyName, CustomEventDefinitionPropertyUpdateRequest customEventDefinitionPropertyUpdateRequest, final ApiCallback<CustomEventDefinitionProperty> _callback) throws ApiException {

        okhttp3.Call localVarCall = propertyDefinition_0ValidateBeforeCall(name, propertyName, customEventDefinitionPropertyUpdateRequest, _callback);
        Type localVarReturnType = new TypeToken<CustomEventDefinitionProperty>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for retrieveDefinition
     * @param name Name of the custom event. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the event definition. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call retrieveDefinitionCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/event/definitions/{name}"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call retrieveDefinitionValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling retrieveDefinition(Async)");
        }
        

        okhttp3.Call localVarCall = retrieveDefinitionCall(name, _callback);
        return localVarCall;

    }

    /**
     * Retrieve an event definition
     * <p>
     * Retrieves a custom event definition you previously created.
     * @param name Name of the custom event. (required)
     * @return CustomEventDefinition
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the event definition. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public CustomEventDefinition retrieveDefinition(String name) throws ApiException {
        ApiResponse<CustomEventDefinition> localVarResp = retrieveDefinitionWithHttpInfo(name);
        return localVarResp.getData();
    }

    /**
     * Retrieve an event definition
     * <p>
     * Retrieves a custom event definition you previously created.
     * @param name Name of the custom event. (required)
     * @return ApiResponse&lt;CustomEventDefinition&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the event definition. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CustomEventDefinition> retrieveDefinitionWithHttpInfo(String name) throws ApiException {
        okhttp3.Call localVarCall = retrieveDefinitionValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<CustomEventDefinition>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve an event definition (asynchronously)
     * <p>
     * Retrieves a custom event definition you previously created.
     * @param name Name of the custom event. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the event definition. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call retrieveDefinitionAsync(String name, final ApiCallback<CustomEventDefinition> _callback) throws ApiException {

        okhttp3.Call localVarCall = retrieveDefinitionValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<CustomEventDefinition>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for sendEvent
     * @param customEventSendRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully sent the event. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendEventCall(CustomEventSendRequest customEventSendRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = customEventSendRequest;

        // create path and map variables
        String localVarPath = "/event/events";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendEventValidateBeforeCall(CustomEventSendRequest customEventSendRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'customEventSendRequest' is set
        if (customEventSendRequest == null) {
            throw new ApiException("Missing the required parameter 'customEventSendRequest' when calling sendEvent(Async)");
        }
        

        okhttp3.Call localVarCall = sendEventCall(customEventSendRequest, _callback);
        return localVarCall;

    }

    /**
     * Send an event
     * <p>
     * Sends an event.
     * @param customEventSendRequest  (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully sent the event. </td><td>  -  </td></tr>
     </table>
     */
    public void sendEvent(CustomEventSendRequest customEventSendRequest) throws ApiException {
        sendEventWithHttpInfo(customEventSendRequest);
    }

    /**
     * Send an event
     * <p>
     * Sends an event.
     * @param customEventSendRequest  (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully sent the event. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Void> sendEventWithHttpInfo(CustomEventSendRequest customEventSendRequest) throws ApiException {
        okhttp3.Call localVarCall = sendEventValidateBeforeCall(customEventSendRequest, null);
        return localVarApiClient.execute(localVarCall);
    }

    /**
     * Send an event (asynchronously)
     * <p>
     * Sends an event.
     * @param customEventSendRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully sent the event. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendEventAsync(CustomEventSendRequest customEventSendRequest, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendEventValidateBeforeCall(customEventSendRequest, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateDefinition
     * @param name Name of the custom event. (required)
     * @param customEventDefinitionUpdateRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully updated the event definition. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateDefinitionCall(String name, CustomEventDefinitionUpdateRequest customEventDefinitionUpdateRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = customEventDefinitionUpdateRequest;

        // create path and map variables
        String localVarPath = "/event/definitions/{name}"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateDefinitionValidateBeforeCall(String name, CustomEventDefinitionUpdateRequest customEventDefinitionUpdateRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling updateDefinition(Async)");
        }
        
        // verify the required parameter 'customEventDefinitionUpdateRequest' is set
        if (customEventDefinitionUpdateRequest == null) {
            throw new ApiException("Missing the required parameter 'customEventDefinitionUpdateRequest' when calling updateDefinition(Async)");
        }
        

        okhttp3.Call localVarCall = updateDefinitionCall(name, customEventDefinitionUpdateRequest, _callback);
        return localVarCall;

    }

    /**
     * Update an event definition
     * <p>
     * Updates an event definition&#39;s label and description.
     * @param name Name of the custom event. (required)
     * @param customEventDefinitionUpdateRequest  (required)
     * @return CustomEventDefinition
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully updated the event definition. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public CustomEventDefinition updateDefinition(String name, CustomEventDefinitionUpdateRequest customEventDefinitionUpdateRequest) throws ApiException {
        ApiResponse<CustomEventDefinition> localVarResp = updateDefinitionWithHttpInfo(name, customEventDefinitionUpdateRequest);
        return localVarResp.getData();
    }

    /**
     * Update an event definition
     * <p>
     * Updates an event definition&#39;s label and description.
     * @param name Name of the custom event. (required)
     * @param customEventDefinitionUpdateRequest  (required)
     * @return ApiResponse&lt;CustomEventDefinition&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully updated the event definition. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<CustomEventDefinition> updateDefinitionWithHttpInfo(String name, CustomEventDefinitionUpdateRequest customEventDefinitionUpdateRequest) throws ApiException {
        okhttp3.Call localVarCall = updateDefinitionValidateBeforeCall(name, customEventDefinitionUpdateRequest, null);
        Type localVarReturnType = new TypeToken<CustomEventDefinition>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update an event definition (asynchronously)
     * <p>
     * Updates an event definition&#39;s label and description.
     * @param name Name of the custom event. (required)
     * @param customEventDefinitionUpdateRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully updated the event definition. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateDefinitionAsync(String name, CustomEventDefinitionUpdateRequest customEventDefinitionUpdateRequest, final ApiCallback<CustomEventDefinition> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateDefinitionValidateBeforeCall(name, customEventDefinitionUpdateRequest, _callback);
        Type localVarReturnType = new TypeToken<CustomEventDefinition>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
