/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.api;

import com.ycloud.client.ApiCallback;
import com.ycloud.client.ApiClient;
import com.ycloud.client.ApiException;
import com.ycloud.client.ApiResponse;
import com.ycloud.client.Configuration;
import com.ycloud.client.Pair;
import com.ycloud.client.ProgressRequestBody;
import com.ycloud.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.ycloud.client.model.ErrorResponse;
import com.ycloud.client.model.Unsubscriber;
import com.ycloud.client.model.UnsubscriberChannel;
import com.ycloud.client.model.UnsubscriberCreateRequest;
import com.ycloud.client.model.UnsubscriberPage;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class UnsubscribersApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public UnsubscribersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UnsubscribersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    /**
     * Build call for create
     * @param unsubscriberCreateRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully created an unsubscriber. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createCall(UnsubscriberCreateRequest unsubscriberCreateRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = unsubscriberCreateRequest;

        // create path and map variables
        String localVarPath = "/unsubscribers";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call createValidateBeforeCall(UnsubscriberCreateRequest unsubscriberCreateRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'unsubscriberCreateRequest' is set
        if (unsubscriberCreateRequest == null) {
            throw new ApiException("Missing the required parameter 'unsubscriberCreateRequest' when calling create(Async)");
        }
        

        okhttp3.Call localVarCall = createCall(unsubscriberCreateRequest, _callback);
        return localVarCall;

    }

    /**
     * Create an unsubscriber
     * <p>
     * Creates an unsubscriber. An unsubscriber is a configuration item representing that customers opt out of receiving messages from your business. **A customer and a channel form a unique identifier for an unsubscriber.**
     * @param unsubscriberCreateRequest  (required)
     * @return Unsubscriber
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully created an unsubscriber. </td><td>  -  </td></tr>
     </table>
     */
    public Unsubscriber create(UnsubscriberCreateRequest unsubscriberCreateRequest) throws ApiException {
        ApiResponse<Unsubscriber> localVarResp = createWithHttpInfo(unsubscriberCreateRequest);
        return localVarResp.getData();
    }

    /**
     * Create an unsubscriber
     * <p>
     * Creates an unsubscriber. An unsubscriber is a configuration item representing that customers opt out of receiving messages from your business. **A customer and a channel form a unique identifier for an unsubscriber.**
     * @param unsubscriberCreateRequest  (required)
     * @return ApiResponse&lt;Unsubscriber&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully created an unsubscriber. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Unsubscriber> createWithHttpInfo(UnsubscriberCreateRequest unsubscriberCreateRequest) throws ApiException {
        okhttp3.Call localVarCall = createValidateBeforeCall(unsubscriberCreateRequest, null);
        Type localVarReturnType = new TypeToken<Unsubscriber>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Create an unsubscriber (asynchronously)
     * <p>
     * Creates an unsubscriber. An unsubscriber is a configuration item representing that customers opt out of receiving messages from your business. **A customer and a channel form a unique identifier for an unsubscriber.**
     * @param unsubscriberCreateRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully created an unsubscriber. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call createAsync(UnsubscriberCreateRequest unsubscriberCreateRequest, final ApiCallback<Unsubscriber> _callback) throws ApiException {

        okhttp3.Call localVarCall = createValidateBeforeCall(unsubscriberCreateRequest, _callback);
        Type localVarReturnType = new TypeToken<Unsubscriber>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for deleteByCustomerAndChannel
     * @param customer The customer who has opted out. (required)
     * @param channel  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully deleted the unsubscriber. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteByCustomerAndChannelCall(String customer, UnsubscriberChannel channel, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/unsubscribers/{customer}/{channel}"
            .replaceAll("\\{" + "customer" + "\\}", localVarApiClient.escapeString(customer.toString()))
            .replaceAll("\\{" + "channel" + "\\}", localVarApiClient.escapeString(channel.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call deleteByCustomerAndChannelValidateBeforeCall(String customer, UnsubscriberChannel channel, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'customer' is set
        if (customer == null) {
            throw new ApiException("Missing the required parameter 'customer' when calling deleteByCustomerAndChannel(Async)");
        }
        
        // verify the required parameter 'channel' is set
        if (channel == null) {
            throw new ApiException("Missing the required parameter 'channel' when calling deleteByCustomerAndChannel(Async)");
        }
        

        okhttp3.Call localVarCall = deleteByCustomerAndChannelCall(customer, channel, _callback);
        return localVarCall;

    }

    /**
     * Delete an unsubscriber
     * <p>
     * Deletes the unsubscriber for the specified customer and channel.
     * @param customer The customer who has opted out. (required)
     * @param channel  (required)
     * @return Unsubscriber
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully deleted the unsubscriber. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public Unsubscriber deleteByCustomerAndChannel(String customer, UnsubscriberChannel channel) throws ApiException {
        ApiResponse<Unsubscriber> localVarResp = deleteByCustomerAndChannelWithHttpInfo(customer, channel);
        return localVarResp.getData();
    }

    /**
     * Delete an unsubscriber
     * <p>
     * Deletes the unsubscriber for the specified customer and channel.
     * @param customer The customer who has opted out. (required)
     * @param channel  (required)
     * @return ApiResponse&lt;Unsubscriber&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully deleted the unsubscriber. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Unsubscriber> deleteByCustomerAndChannelWithHttpInfo(String customer, UnsubscriberChannel channel) throws ApiException {
        okhttp3.Call localVarCall = deleteByCustomerAndChannelValidateBeforeCall(customer, channel, null);
        Type localVarReturnType = new TypeToken<Unsubscriber>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Delete an unsubscriber (asynchronously)
     * <p>
     * Deletes the unsubscriber for the specified customer and channel.
     * @param customer The customer who has opted out. (required)
     * @param channel  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully deleted the unsubscriber. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call deleteByCustomerAndChannelAsync(String customer, UnsubscriberChannel channel, final ApiCallback<Unsubscriber> _callback) throws ApiException {

        okhttp3.Call localVarCall = deleteByCustomerAndChannelValidateBeforeCall(customer, channel, _callback);
        Type localVarReturnType = new TypeToken<Unsubscriber>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    private okhttp3.Call listCall(Integer page, Integer limit, Boolean includeTotal, String pageAfter, String filterCustomer, UnsubscriberChannel filterChannel, String filterRegionCode, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/unsubscribers";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (includeTotal != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeTotal", includeTotal));
        }

        if (pageAfter != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pageAfter", pageAfter));
        }

        if (filterCustomer != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filter.customer", filterCustomer));
        }

        if (filterChannel != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filter.channel", filterChannel));
        }

        if (filterRegionCode != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filter.regionCode", filterRegionCode));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listValidateBeforeCall(Integer page, Integer limit, Boolean includeTotal, String pageAfter, String filterCustomer, UnsubscriberChannel filterChannel, String filterRegionCode, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listCall(page, limit, includeTotal, pageAfter, filterCustomer, filterChannel, filterRegionCode, _callback);
        return localVarCall;

    }


    private ApiResponse<UnsubscriberPage> listWithHttpInfo(Integer page, Integer limit, Boolean includeTotal, String pageAfter, String filterCustomer, UnsubscriberChannel filterChannel, String filterRegionCode) throws ApiException {
        okhttp3.Call localVarCall = listValidateBeforeCall(page, limit, includeTotal, pageAfter, filterCustomer, filterChannel, filterRegionCode, null);
        Type localVarReturnType = new TypeToken<UnsubscriberPage>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listAsync(Integer page, Integer limit, Boolean includeTotal, String pageAfter, String filterCustomer, UnsubscriberChannel filterChannel, String filterRegionCode, final ApiCallback<UnsubscriberPage> _callback) throws ApiException {

        okhttp3.Call localVarCall = listValidateBeforeCall(page, limit, includeTotal, pageAfter, filterCustomer, filterChannel, filterRegionCode, _callback);
        Type localVarReturnType = new TypeToken<UnsubscriberPage>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class ApiListRequest {
        private Integer page;
        private Integer limit;
        private Boolean includeTotal;
        private String pageAfter;
        private String filterCustomer;
        private UnsubscriberChannel filterChannel;
        private String filterRegionCode;

        private ApiListRequest() {
        }

        /**
         * Set page
         * @param page Page number of the results to be returned, 1-based. (optional, default to 1)
         * @return ApiListRequest
         */
        public ApiListRequest page(Integer page) {
            this.page = page;
            return this;
        }

        /**
         * Set limit
         * @param limit A limit on the number of results to be returned, or number of results per page, between 1 and 100, defaults to 10. (optional, default to 10)
         * @return ApiListRequest
         */
        public ApiListRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set includeTotal
         * @param includeTotal Return results inside an object that contains the total result count or not. (optional, default to false)
         * @return ApiListRequest
         */
        public ApiListRequest includeTotal(Boolean includeTotal) {
            this.includeTotal = includeTotal;
            return this;
        }

        /**
         * Set pageAfter
         * @param pageAfter A cursor to fetch the next page in cursor pagination. For example, if you make a list request, receive 100 objects and &#x60;cursor.after&#x3D;id:foo&#x60;, your subsequent call can include &#x60;pageAfter&#x3D;id:foo&#x60; in order to fetch the next page of the list. (optional)
         * @return ApiListRequest
         */
        public ApiListRequest pageAfter(String pageAfter) {
            this.pageAfter = pageAfter;
            return this;
        }

        /**
         * Set filterCustomer
         * @param filterCustomer  (optional)
         * @return ApiListRequest
         */
        public ApiListRequest filterCustomer(String filterCustomer) {
            this.filterCustomer = filterCustomer;
            return this;
        }

        /**
         * Set filterChannel
         * @param filterChannel  (optional)
         * @return ApiListRequest
         */
        public ApiListRequest filterChannel(UnsubscriberChannel filterChannel) {
            this.filterChannel = filterChannel;
            return this;
        }

        /**
         * Set filterRegionCode
         * @param filterRegionCode  (optional)
         * @return ApiListRequest
         */
        public ApiListRequest filterRegionCode(String filterRegionCode) {
            this.filterRegionCode = filterRegionCode;
            return this;
        }

        /**
         * Build call for list
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved a paginated list of objects. </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listCall(page, limit, includeTotal, pageAfter, filterCustomer, filterChannel, filterRegionCode, _callback);
        }

        /**
         * Execute list request
         * @return UnsubscriberPage
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved a paginated list of objects. </td><td>  -  </td></tr>
         </table>
         */
        public UnsubscriberPage execute() throws ApiException {
            ApiResponse<UnsubscriberPage> localVarResp = listWithHttpInfo(page, limit, includeTotal, pageAfter, filterCustomer, filterChannel, filterRegionCode);
            return localVarResp.getData();
        }

        /**
         * Execute list request with HTTP info returned
         * @return ApiResponse&lt;UnsubscriberPage&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved a paginated list of objects. </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<UnsubscriberPage> executeWithHttpInfo() throws ApiException {
            return listWithHttpInfo(page, limit, includeTotal, pageAfter, filterCustomer, filterChannel, filterRegionCode);
        }

        /**
         * Execute list request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved a paginated list of objects. </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<UnsubscriberPage> _callback) throws ApiException {
            return listAsync(page, limit, includeTotal, pageAfter, filterCustomer, filterChannel, filterRegionCode, _callback);
        }
    }

    /**
     * List unsubscribers
     * <p>
     * Returns a paginated list of unsubscribers.
     * @return ApiListRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved a paginated list of objects. </td><td>  -  </td></tr>
     </table>
     */
    public ApiListRequest list() {
        return new ApiListRequest();
    }
    /**
     * Build call for listAllByCustomer
     * @param customer The customer who has opted out. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the unsubscribers. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listAllByCustomerCall(String customer, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/unsubscribers/{customer}"
            .replaceAll("\\{" + "customer" + "\\}", localVarApiClient.escapeString(customer.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listAllByCustomerValidateBeforeCall(String customer, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'customer' is set
        if (customer == null) {
            throw new ApiException("Missing the required parameter 'customer' when calling listAllByCustomer(Async)");
        }
        

        okhttp3.Call localVarCall = listAllByCustomerCall(customer, _callback);
        return localVarCall;

    }

    /**
     * List all unsubscribers by customer
     * <p>
     * Returns all unsubscribers for the specified customer.
     * @param customer The customer who has opted out. (required)
     * @return List&lt;Unsubscriber&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the unsubscribers. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public List<Unsubscriber> listAllByCustomer(String customer) throws ApiException {
        ApiResponse<List<Unsubscriber>> localVarResp = listAllByCustomerWithHttpInfo(customer);
        return localVarResp.getData();
    }

    /**
     * List all unsubscribers by customer
     * <p>
     * Returns all unsubscribers for the specified customer.
     * @param customer The customer who has opted out. (required)
     * @return ApiResponse&lt;List&lt;Unsubscriber&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the unsubscribers. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<List<Unsubscriber>> listAllByCustomerWithHttpInfo(String customer) throws ApiException {
        okhttp3.Call localVarCall = listAllByCustomerValidateBeforeCall(customer, null);
        Type localVarReturnType = new TypeToken<List<Unsubscriber>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * List all unsubscribers by customer (asynchronously)
     * <p>
     * Returns all unsubscribers for the specified customer.
     * @param customer The customer who has opted out. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the unsubscribers. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call listAllByCustomerAsync(String customer, final ApiCallback<List<Unsubscriber>> _callback) throws ApiException {

        okhttp3.Call localVarCall = listAllByCustomerValidateBeforeCall(customer, _callback);
        Type localVarReturnType = new TypeToken<List<Unsubscriber>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for retrieveByCustomerAndChannel
     * @param customer The customer who has opted out. (required)
     * @param channel  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the unsubscribers. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call retrieveByCustomerAndChannelCall(String customer, UnsubscriberChannel channel, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/unsubscribers/{customer}/{channel}"
            .replaceAll("\\{" + "customer" + "\\}", localVarApiClient.escapeString(customer.toString()))
            .replaceAll("\\{" + "channel" + "\\}", localVarApiClient.escapeString(channel.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call retrieveByCustomerAndChannelValidateBeforeCall(String customer, UnsubscriberChannel channel, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'customer' is set
        if (customer == null) {
            throw new ApiException("Missing the required parameter 'customer' when calling retrieveByCustomerAndChannel(Async)");
        }
        
        // verify the required parameter 'channel' is set
        if (channel == null) {
            throw new ApiException("Missing the required parameter 'channel' when calling retrieveByCustomerAndChannel(Async)");
        }
        

        okhttp3.Call localVarCall = retrieveByCustomerAndChannelCall(customer, channel, _callback);
        return localVarCall;

    }

    /**
     * Retrieve an unsubscriber
     * <p>
     * Retrieves the unsubscriber for the specified customer and channel.
     * @param customer The customer who has opted out. (required)
     * @param channel  (required)
     * @return Unsubscriber
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the unsubscribers. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public Unsubscriber retrieveByCustomerAndChannel(String customer, UnsubscriberChannel channel) throws ApiException {
        ApiResponse<Unsubscriber> localVarResp = retrieveByCustomerAndChannelWithHttpInfo(customer, channel);
        return localVarResp.getData();
    }

    /**
     * Retrieve an unsubscriber
     * <p>
     * Retrieves the unsubscriber for the specified customer and channel.
     * @param customer The customer who has opted out. (required)
     * @param channel  (required)
     * @return ApiResponse&lt;Unsubscriber&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the unsubscribers. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Unsubscriber> retrieveByCustomerAndChannelWithHttpInfo(String customer, UnsubscriberChannel channel) throws ApiException {
        okhttp3.Call localVarCall = retrieveByCustomerAndChannelValidateBeforeCall(customer, channel, null);
        Type localVarReturnType = new TypeToken<Unsubscriber>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve an unsubscriber (asynchronously)
     * <p>
     * Retrieves the unsubscriber for the specified customer and channel.
     * @param customer The customer who has opted out. (required)
     * @param channel  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the unsubscribers. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call retrieveByCustomerAndChannelAsync(String customer, UnsubscriberChannel channel, final ApiCallback<Unsubscriber> _callback) throws ApiException {

        okhttp3.Call localVarCall = retrieveByCustomerAndChannelValidateBeforeCall(customer, channel, _callback);
        Type localVarReturnType = new TypeToken<Unsubscriber>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
