/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.api;

import com.ycloud.client.ApiCallback;
import com.ycloud.client.ApiClient;
import com.ycloud.client.ApiException;
import com.ycloud.client.ApiResponse;
import com.ycloud.client.Configuration;
import com.ycloud.client.Pair;
import com.ycloud.client.ProgressRequestBody;
import com.ycloud.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import java.util.Date;
import com.ycloud.client.model.Voice;
import com.ycloud.client.model.VoicePage;
import com.ycloud.client.model.VoiceSendRequest;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class VoicesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public VoicesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VoicesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private okhttp3.Call listCall(Integer page, Integer limit, Boolean includeTotal, Date filterCreateTimeGte, Date filterCreateTimeLte, String filterId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/voices";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (includeTotal != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeTotal", includeTotal));
        }

        if (filterCreateTimeGte != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filter.createTime.gte", filterCreateTimeGte));
        }

        if (filterCreateTimeLte != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filter.createTime.lte", filterCreateTimeLte));
        }

        if (filterId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filter.id", filterId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listValidateBeforeCall(Integer page, Integer limit, Boolean includeTotal, Date filterCreateTimeGte, Date filterCreateTimeLte, String filterId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listCall(page, limit, includeTotal, filterCreateTimeGte, filterCreateTimeLte, filterId, _callback);
        return localVarCall;

    }


    private ApiResponse<VoicePage> listWithHttpInfo(Integer page, Integer limit, Boolean includeTotal, Date filterCreateTimeGte, Date filterCreateTimeLte, String filterId) throws ApiException {
        okhttp3.Call localVarCall = listValidateBeforeCall(page, limit, includeTotal, filterCreateTimeGte, filterCreateTimeLte, filterId, null);
        Type localVarReturnType = new TypeToken<VoicePage>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listAsync(Integer page, Integer limit, Boolean includeTotal, Date filterCreateTimeGte, Date filterCreateTimeLte, String filterId, final ApiCallback<VoicePage> _callback) throws ApiException {

        okhttp3.Call localVarCall = listValidateBeforeCall(page, limit, includeTotal, filterCreateTimeGte, filterCreateTimeLte, filterId, _callback);
        Type localVarReturnType = new TypeToken<VoicePage>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class ApiListRequest {
        private Integer page;
        private Integer limit;
        private Boolean includeTotal;
        private Date filterCreateTimeGte;
        private Date filterCreateTimeLte;
        private String filterId;

        private ApiListRequest() {
        }

        /**
         * Set page
         * @param page Page number of the results to be returned, 1-based. (optional, default to 1)
         * @return ApiListRequest
         */
        public ApiListRequest page(Integer page) {
            this.page = page;
            return this;
        }

        /**
         * Set limit
         * @param limit A limit on the number of results to be returned, or number of results per page, between 1 and 100, defaults to 10. (optional, default to 10)
         * @return ApiListRequest
         */
        public ApiListRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set includeTotal
         * @param includeTotal Return results inside an object that contains the total result count or not. (optional, default to false)
         * @return ApiListRequest
         */
        public ApiListRequest includeTotal(Boolean includeTotal) {
            this.includeTotal = includeTotal;
            return this;
        }

        /**
         * Set filterCreateTimeGte
         * @param filterCreateTimeGte Return results where the &#x60;createTime&#x60; field is greater than or equal to this value. Default: One day ago from now. (optional)
         * @return ApiListRequest
         */
        public ApiListRequest filterCreateTimeGte(Date filterCreateTimeGte) {
            this.filterCreateTimeGte = filterCreateTimeGte;
            return this;
        }

        /**
         * Set filterCreateTimeLte
         * @param filterCreateTimeLte Return results where the &#x60;createTime&#x60; field is less than or equal to this value. (optional)
         * @return ApiListRequest
         */
        public ApiListRequest filterCreateTimeLte(Date filterCreateTimeLte) {
            this.filterCreateTimeLte = filterCreateTimeLte;
            return this;
        }

        /**
         * Set filterId
         * @param filterId Unique object ID on our side. Other filter parameters will be ignored if this parameter is present. (optional)
         * @return ApiListRequest
         */
        public ApiListRequest filterId(String filterId) {
            this.filterId = filterId;
            return this;
        }

        /**
         * Build call for list
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved a paginated list of objects. </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listCall(page, limit, includeTotal, filterCreateTimeGte, filterCreateTimeLte, filterId, _callback);
        }

        /**
         * Execute list request
         * @return VoicePage
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved a paginated list of objects. </td><td>  -  </td></tr>
         </table>
         */
        public VoicePage execute() throws ApiException {
            ApiResponse<VoicePage> localVarResp = listWithHttpInfo(page, limit, includeTotal, filterCreateTimeGte, filterCreateTimeLte, filterId);
            return localVarResp.getData();
        }

        /**
         * Execute list request with HTTP info returned
         * @return ApiResponse&lt;VoicePage&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved a paginated list of objects. </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<VoicePage> executeWithHttpInfo() throws ApiException {
            return listWithHttpInfo(page, limit, includeTotal, filterCreateTimeGte, filterCreateTimeLte, filterId);
        }

        /**
         * Execute list request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved a paginated list of objects. </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<VoicePage> _callback) throws ApiException {
            return listAsync(page, limit, includeTotal, filterCreateTimeGte, filterCreateTimeLte, filterId, _callback);
        }
    }

    /**
     * List voice records
     * <p>
     * Returns a paginated list of voice calls you&#39;ve previously sent.
     * @return ApiListRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved a paginated list of objects. </td><td>  -  </td></tr>
     </table>
     */
    public ApiListRequest list() {
        return new ApiListRequest();
    }
    /**
     * Build call for send
     * @param voiceSendRequest Voice call request that needs to be sent. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request is successfully accepted. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendCall(VoiceSendRequest voiceSendRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = voiceSendRequest;

        // create path and map variables
        String localVarPath = "/voices";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call sendValidateBeforeCall(VoiceSendRequest voiceSendRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'voiceSendRequest' is set
        if (voiceSendRequest == null) {
            throw new ApiException("Missing the required parameter 'voiceSendRequest' when calling send(Async)");
        }
        

        okhttp3.Call localVarCall = sendCall(voiceSendRequest, _callback);
        return localVarCall;

    }

    /**
     * Send a voice code
     * <p>
     * Sends an outbound voice call verification code.
     * @param voiceSendRequest Voice call request that needs to be sent. (required)
     * @return Voice
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request is successfully accepted. </td><td>  -  </td></tr>
     </table>
     */
    public Voice send(VoiceSendRequest voiceSendRequest) throws ApiException {
        ApiResponse<Voice> localVarResp = sendWithHttpInfo(voiceSendRequest);
        return localVarResp.getData();
    }

    /**
     * Send a voice code
     * <p>
     * Sends an outbound voice call verification code.
     * @param voiceSendRequest Voice call request that needs to be sent. (required)
     * @return ApiResponse&lt;Voice&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request is successfully accepted. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<Voice> sendWithHttpInfo(VoiceSendRequest voiceSendRequest) throws ApiException {
        okhttp3.Call localVarCall = sendValidateBeforeCall(voiceSendRequest, null);
        Type localVarReturnType = new TypeToken<Voice>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Send a voice code (asynchronously)
     * <p>
     * Sends an outbound voice call verification code.
     * @param voiceSendRequest Voice call request that needs to be sent. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> The request is successfully accepted. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call sendAsync(VoiceSendRequest voiceSendRequest, final ApiCallback<Voice> _callback) throws ApiException {

        okhttp3.Call localVarCall = sendValidateBeforeCall(voiceSendRequest, _callback);
        Type localVarReturnType = new TypeToken<Voice>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
