/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.api;

import com.ycloud.client.ApiCallback;
import com.ycloud.client.ApiClient;
import com.ycloud.client.ApiException;
import com.ycloud.client.ApiResponse;
import com.ycloud.client.Configuration;
import com.ycloud.client.Pair;
import com.ycloud.client.ProgressRequestBody;
import com.ycloud.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.ycloud.client.model.ErrorResponse;
import com.ycloud.client.model.WhatsappCommerceSettings;
import com.ycloud.client.model.WhatsappCommerceSettingsUpdateRequest;
import com.ycloud.client.model.WhatsappPhoneNumber;
import com.ycloud.client.model.WhatsappPhoneNumberPage;
import com.ycloud.client.model.WhatsappPhoneNumberProfile;
import com.ycloud.client.model.WhatsappPhoneNumberProfileUpdateRequest;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class WhatsappPhoneNumbersApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public WhatsappPhoneNumbersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WhatsappPhoneNumbersApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private okhttp3.Call listCall(Integer page, Integer limit, Boolean includeTotal, String filterWabaId, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/whatsapp/phoneNumbers";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (page != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("page", page));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (includeTotal != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("includeTotal", includeTotal));
        }

        if (filterWabaId != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filter.wabaId", filterWabaId));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call listValidateBeforeCall(Integer page, Integer limit, Boolean includeTotal, String filterWabaId, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = listCall(page, limit, includeTotal, filterWabaId, _callback);
        return localVarCall;

    }


    private ApiResponse<WhatsappPhoneNumberPage> listWithHttpInfo(Integer page, Integer limit, Boolean includeTotal, String filterWabaId) throws ApiException {
        okhttp3.Call localVarCall = listValidateBeforeCall(page, limit, includeTotal, filterWabaId, null);
        Type localVarReturnType = new TypeToken<WhatsappPhoneNumberPage>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call listAsync(Integer page, Integer limit, Boolean includeTotal, String filterWabaId, final ApiCallback<WhatsappPhoneNumberPage> _callback) throws ApiException {

        okhttp3.Call localVarCall = listValidateBeforeCall(page, limit, includeTotal, filterWabaId, _callback);
        Type localVarReturnType = new TypeToken<WhatsappPhoneNumberPage>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class ApiListRequest {
        private Integer page;
        private Integer limit;
        private Boolean includeTotal;
        private String filterWabaId;

        private ApiListRequest() {
        }

        /**
         * Set page
         * @param page Page number of the results to be returned, 1-based. (optional, default to 1)
         * @return ApiListRequest
         */
        public ApiListRequest page(Integer page) {
            this.page = page;
            return this;
        }

        /**
         * Set limit
         * @param limit A limit on the number of results to be returned, or number of results per page, between 1 and 100, defaults to 10. (optional, default to 10)
         * @return ApiListRequest
         */
        public ApiListRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set includeTotal
         * @param includeTotal Return results inside an object that contains the total result count or not. (optional, default to false)
         * @return ApiListRequest
         */
        public ApiListRequest includeTotal(Boolean includeTotal) {
            this.includeTotal = includeTotal;
            return this;
        }

        /**
         * Set filterWabaId
         * @param filterWabaId **Required if you have more than 100 WABAs.** WhatsApp Business Account ID. (optional)
         * @return ApiListRequest
         */
        public ApiListRequest filterWabaId(String filterWabaId) {
            this.filterWabaId = filterWabaId;
            return this;
        }

        /**
         * Build call for list
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved a paginated list of objects. </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return listCall(page, limit, includeTotal, filterWabaId, _callback);
        }

        /**
         * Execute list request
         * @return WhatsappPhoneNumberPage
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved a paginated list of objects. </td><td>  -  </td></tr>
         </table>
         */
        public WhatsappPhoneNumberPage execute() throws ApiException {
            ApiResponse<WhatsappPhoneNumberPage> localVarResp = listWithHttpInfo(page, limit, includeTotal, filterWabaId);
            return localVarResp.getData();
        }

        /**
         * Execute list request with HTTP info returned
         * @return ApiResponse&lt;WhatsappPhoneNumberPage&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved a paginated list of objects. </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<WhatsappPhoneNumberPage> executeWithHttpInfo() throws ApiException {
            return listWithHttpInfo(page, limit, includeTotal, filterWabaId);
        }

        /**
         * Execute list request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Successfully retrieved a paginated list of objects. </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<WhatsappPhoneNumberPage> _callback) throws ApiException {
            return listAsync(page, limit, includeTotal, filterWabaId, _callback);
        }
    }

    /**
     * List phone numbers
     * <p>
     * Returns a paginated list of WhatsApp business phone numbers you&#39;ve registered.
     * @return ApiListRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved a paginated list of objects. </td><td>  -  </td></tr>
     </table>
     */
    public ApiListRequest list() {
        return new ApiListRequest();
    }
    /**
     * Build call for register
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number ID. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully registered the phone number. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call registerCall(String wabaId, String phoneNumber, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/whatsapp/phoneNumbers/{wabaId}/{phoneNumber}/register"
            .replaceAll("\\{" + "wabaId" + "\\}", localVarApiClient.escapeString(wabaId.toString()))
            .replaceAll("\\{" + "phoneNumber" + "\\}", localVarApiClient.escapeString(phoneNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call registerValidateBeforeCall(String wabaId, String phoneNumber, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'wabaId' is set
        if (wabaId == null) {
            throw new ApiException("Missing the required parameter 'wabaId' when calling register(Async)");
        }
        
        // verify the required parameter 'phoneNumber' is set
        if (phoneNumber == null) {
            throw new ApiException("Missing the required parameter 'phoneNumber' when calling register(Async)");
        }
        

        okhttp3.Call localVarCall = registerCall(wabaId, phoneNumber, _callback);
        return localVarCall;

    }

    /**
     * Register a phone number
     * <p>
     * Registers a WhatsApp business phone number.
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number ID. (required)
     * @return WhatsappPhoneNumber
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully registered the phone number. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public WhatsappPhoneNumber register(String wabaId, String phoneNumber) throws ApiException {
        ApiResponse<WhatsappPhoneNumber> localVarResp = registerWithHttpInfo(wabaId, phoneNumber);
        return localVarResp.getData();
    }

    /**
     * Register a phone number
     * <p>
     * Registers a WhatsApp business phone number.
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number ID. (required)
     * @return ApiResponse&lt;WhatsappPhoneNumber&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully registered the phone number. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WhatsappPhoneNumber> registerWithHttpInfo(String wabaId, String phoneNumber) throws ApiException {
        okhttp3.Call localVarCall = registerValidateBeforeCall(wabaId, phoneNumber, null);
        Type localVarReturnType = new TypeToken<WhatsappPhoneNumber>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Register a phone number (asynchronously)
     * <p>
     * Registers a WhatsApp business phone number.
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number ID. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully registered the phone number. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call registerAsync(String wabaId, String phoneNumber, final ApiCallback<WhatsappPhoneNumber> _callback) throws ApiException {

        okhttp3.Call localVarCall = registerValidateBeforeCall(wabaId, phoneNumber, _callback);
        Type localVarReturnType = new TypeToken<WhatsappPhoneNumber>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for retrieve
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call retrieveCall(String wabaId, String phoneNumber, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/whatsapp/phoneNumbers/{wabaId}/{phoneNumber}"
            .replaceAll("\\{" + "wabaId" + "\\}", localVarApiClient.escapeString(wabaId.toString()))
            .replaceAll("\\{" + "phoneNumber" + "\\}", localVarApiClient.escapeString(phoneNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call retrieveValidateBeforeCall(String wabaId, String phoneNumber, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'wabaId' is set
        if (wabaId == null) {
            throw new ApiException("Missing the required parameter 'wabaId' when calling retrieve(Async)");
        }
        
        // verify the required parameter 'phoneNumber' is set
        if (phoneNumber == null) {
            throw new ApiException("Missing the required parameter 'phoneNumber' when calling retrieve(Async)");
        }
        

        okhttp3.Call localVarCall = retrieveCall(wabaId, phoneNumber, _callback);
        return localVarCall;

    }

    /**
     * Retrieve a phone number
     * <p>
     * Retrieves a WhatsApp business phone number you&#39;ve registered.
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @return WhatsappPhoneNumber
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public WhatsappPhoneNumber retrieve(String wabaId, String phoneNumber) throws ApiException {
        ApiResponse<WhatsappPhoneNumber> localVarResp = retrieveWithHttpInfo(wabaId, phoneNumber);
        return localVarResp.getData();
    }

    /**
     * Retrieve a phone number
     * <p>
     * Retrieves a WhatsApp business phone number you&#39;ve registered.
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @return ApiResponse&lt;WhatsappPhoneNumber&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WhatsappPhoneNumber> retrieveWithHttpInfo(String wabaId, String phoneNumber) throws ApiException {
        okhttp3.Call localVarCall = retrieveValidateBeforeCall(wabaId, phoneNumber, null);
        Type localVarReturnType = new TypeToken<WhatsappPhoneNumber>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve a phone number (asynchronously)
     * <p>
     * Retrieves a WhatsApp business phone number you&#39;ve registered.
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call retrieveAsync(String wabaId, String phoneNumber, final ApiCallback<WhatsappPhoneNumber> _callback) throws ApiException {

        okhttp3.Call localVarCall = retrieveValidateBeforeCall(wabaId, phoneNumber, _callback);
        Type localVarReturnType = new TypeToken<WhatsappPhoneNumber>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for retrieveCommerceSettings
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call retrieveCommerceSettingsCall(String wabaId, String phoneNumber, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/whatsapp/phoneNumbers/{wabaId}/{phoneNumber}/whatsappCommerceSettings"
            .replaceAll("\\{" + "wabaId" + "\\}", localVarApiClient.escapeString(wabaId.toString()))
            .replaceAll("\\{" + "phoneNumber" + "\\}", localVarApiClient.escapeString(phoneNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call retrieveCommerceSettingsValidateBeforeCall(String wabaId, String phoneNumber, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'wabaId' is set
        if (wabaId == null) {
            throw new ApiException("Missing the required parameter 'wabaId' when calling retrieveCommerceSettings(Async)");
        }
        
        // verify the required parameter 'phoneNumber' is set
        if (phoneNumber == null) {
            throw new ApiException("Missing the required parameter 'phoneNumber' when calling retrieveCommerceSettings(Async)");
        }
        

        okhttp3.Call localVarCall = retrieveCommerceSettingsCall(wabaId, phoneNumber, _callback);
        return localVarCall;

    }

    /**
     * Retrieve commerce settings
     * <p>
     * Retrieves a WhatsApp business phone number&#39;s commerce settings.
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @return WhatsappCommerceSettings
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public WhatsappCommerceSettings retrieveCommerceSettings(String wabaId, String phoneNumber) throws ApiException {
        ApiResponse<WhatsappCommerceSettings> localVarResp = retrieveCommerceSettingsWithHttpInfo(wabaId, phoneNumber);
        return localVarResp.getData();
    }

    /**
     * Retrieve commerce settings
     * <p>
     * Retrieves a WhatsApp business phone number&#39;s commerce settings.
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @return ApiResponse&lt;WhatsappCommerceSettings&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WhatsappCommerceSettings> retrieveCommerceSettingsWithHttpInfo(String wabaId, String phoneNumber) throws ApiException {
        okhttp3.Call localVarCall = retrieveCommerceSettingsValidateBeforeCall(wabaId, phoneNumber, null);
        Type localVarReturnType = new TypeToken<WhatsappCommerceSettings>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve commerce settings (asynchronously)
     * <p>
     * Retrieves a WhatsApp business phone number&#39;s commerce settings.
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call retrieveCommerceSettingsAsync(String wabaId, String phoneNumber, final ApiCallback<WhatsappCommerceSettings> _callback) throws ApiException {

        okhttp3.Call localVarCall = retrieveCommerceSettingsValidateBeforeCall(wabaId, phoneNumber, _callback);
        Type localVarReturnType = new TypeToken<WhatsappCommerceSettings>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for retrieveProfile
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call retrieveProfileCall(String wabaId, String phoneNumber, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/whatsapp/phoneNumbers/{wabaId}/{phoneNumber}/profile"
            .replaceAll("\\{" + "wabaId" + "\\}", localVarApiClient.escapeString(wabaId.toString()))
            .replaceAll("\\{" + "phoneNumber" + "\\}", localVarApiClient.escapeString(phoneNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call retrieveProfileValidateBeforeCall(String wabaId, String phoneNumber, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'wabaId' is set
        if (wabaId == null) {
            throw new ApiException("Missing the required parameter 'wabaId' when calling retrieveProfile(Async)");
        }
        
        // verify the required parameter 'phoneNumber' is set
        if (phoneNumber == null) {
            throw new ApiException("Missing the required parameter 'phoneNumber' when calling retrieveProfile(Async)");
        }
        

        okhttp3.Call localVarCall = retrieveProfileCall(wabaId, phoneNumber, _callback);
        return localVarCall;

    }

    /**
     * Retrieve a phone number profile
     * <p>
     * Retrieves a WhatsApp business phone number&#39;s profile. Customers can view your business profile by clicking your business&#39;s name or number in a conversation thread.
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @return WhatsappPhoneNumberProfile
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public WhatsappPhoneNumberProfile retrieveProfile(String wabaId, String phoneNumber) throws ApiException {
        ApiResponse<WhatsappPhoneNumberProfile> localVarResp = retrieveProfileWithHttpInfo(wabaId, phoneNumber);
        return localVarResp.getData();
    }

    /**
     * Retrieve a phone number profile
     * <p>
     * Retrieves a WhatsApp business phone number&#39;s profile. Customers can view your business profile by clicking your business&#39;s name or number in a conversation thread.
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @return ApiResponse&lt;WhatsappPhoneNumberProfile&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WhatsappPhoneNumberProfile> retrieveProfileWithHttpInfo(String wabaId, String phoneNumber) throws ApiException {
        okhttp3.Call localVarCall = retrieveProfileValidateBeforeCall(wabaId, phoneNumber, null);
        Type localVarReturnType = new TypeToken<WhatsappPhoneNumberProfile>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Retrieve a phone number profile (asynchronously)
     * <p>
     * Retrieves a WhatsApp business phone number&#39;s profile. Customers can view your business profile by clicking your business&#39;s name or number in a conversation thread.
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully retrieved the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call retrieveProfileAsync(String wabaId, String phoneNumber, final ApiCallback<WhatsappPhoneNumberProfile> _callback) throws ApiException {

        okhttp3.Call localVarCall = retrieveProfileValidateBeforeCall(wabaId, phoneNumber, _callback);
        Type localVarReturnType = new TypeToken<WhatsappPhoneNumberProfile>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateCommerceSettings
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @param whatsappCommerceSettingsUpdateRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully updated the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateCommerceSettingsCall(String wabaId, String phoneNumber, WhatsappCommerceSettingsUpdateRequest whatsappCommerceSettingsUpdateRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = whatsappCommerceSettingsUpdateRequest;

        // create path and map variables
        String localVarPath = "/whatsapp/phoneNumbers/{wabaId}/{phoneNumber}/whatsappCommerceSettings"
            .replaceAll("\\{" + "wabaId" + "\\}", localVarApiClient.escapeString(wabaId.toString()))
            .replaceAll("\\{" + "phoneNumber" + "\\}", localVarApiClient.escapeString(phoneNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateCommerceSettingsValidateBeforeCall(String wabaId, String phoneNumber, WhatsappCommerceSettingsUpdateRequest whatsappCommerceSettingsUpdateRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'wabaId' is set
        if (wabaId == null) {
            throw new ApiException("Missing the required parameter 'wabaId' when calling updateCommerceSettings(Async)");
        }
        
        // verify the required parameter 'phoneNumber' is set
        if (phoneNumber == null) {
            throw new ApiException("Missing the required parameter 'phoneNumber' when calling updateCommerceSettings(Async)");
        }
        
        // verify the required parameter 'whatsappCommerceSettingsUpdateRequest' is set
        if (whatsappCommerceSettingsUpdateRequest == null) {
            throw new ApiException("Missing the required parameter 'whatsappCommerceSettingsUpdateRequest' when calling updateCommerceSettings(Async)");
        }
        

        okhttp3.Call localVarCall = updateCommerceSettingsCall(wabaId, phoneNumber, whatsappCommerceSettingsUpdateRequest, _callback);
        return localVarCall;

    }

    /**
     * Update commerce settings
     * <p>
     * Updates a WhatsApp business phone number&#39;s commerce settings. Use this endpoint to enable or disable the shopping cart or the product catalog for a specific business phone number.
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @param whatsappCommerceSettingsUpdateRequest  (required)
     * @return WhatsappCommerceSettings
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully updated the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public WhatsappCommerceSettings updateCommerceSettings(String wabaId, String phoneNumber, WhatsappCommerceSettingsUpdateRequest whatsappCommerceSettingsUpdateRequest) throws ApiException {
        ApiResponse<WhatsappCommerceSettings> localVarResp = updateCommerceSettingsWithHttpInfo(wabaId, phoneNumber, whatsappCommerceSettingsUpdateRequest);
        return localVarResp.getData();
    }

    /**
     * Update commerce settings
     * <p>
     * Updates a WhatsApp business phone number&#39;s commerce settings. Use this endpoint to enable or disable the shopping cart or the product catalog for a specific business phone number.
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @param whatsappCommerceSettingsUpdateRequest  (required)
     * @return ApiResponse&lt;WhatsappCommerceSettings&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully updated the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WhatsappCommerceSettings> updateCommerceSettingsWithHttpInfo(String wabaId, String phoneNumber, WhatsappCommerceSettingsUpdateRequest whatsappCommerceSettingsUpdateRequest) throws ApiException {
        okhttp3.Call localVarCall = updateCommerceSettingsValidateBeforeCall(wabaId, phoneNumber, whatsappCommerceSettingsUpdateRequest, null);
        Type localVarReturnType = new TypeToken<WhatsappCommerceSettings>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update commerce settings (asynchronously)
     * <p>
     * Updates a WhatsApp business phone number&#39;s commerce settings. Use this endpoint to enable or disable the shopping cart or the product catalog for a specific business phone number.
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @param whatsappCommerceSettingsUpdateRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully updated the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateCommerceSettingsAsync(String wabaId, String phoneNumber, WhatsappCommerceSettingsUpdateRequest whatsappCommerceSettingsUpdateRequest, final ApiCallback<WhatsappCommerceSettings> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateCommerceSettingsValidateBeforeCall(wabaId, phoneNumber, whatsappCommerceSettingsUpdateRequest, _callback);
        Type localVarReturnType = new TypeToken<WhatsappCommerceSettings>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
    /**
     * Build call for updateProfile
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @param whatsappPhoneNumberProfileUpdateRequest  (required)
     * @param _callback Callback for upload/download progress
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully updated the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateProfileCall(String wabaId, String phoneNumber, WhatsappPhoneNumberProfileUpdateRequest whatsappPhoneNumberProfileUpdateRequest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = whatsappPhoneNumberProfileUpdateRequest;

        // create path and map variables
        String localVarPath = "/whatsapp/phoneNumbers/{wabaId}/{phoneNumber}/profile"
            .replaceAll("\\{" + "wabaId" + "\\}", localVarApiClient.escapeString(wabaId.toString()))
            .replaceAll("\\{" + "phoneNumber" + "\\}", localVarApiClient.escapeString(phoneNumber.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] { "api_key" };
        return localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call updateProfileValidateBeforeCall(String wabaId, String phoneNumber, WhatsappPhoneNumberProfileUpdateRequest whatsappPhoneNumberProfileUpdateRequest, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'wabaId' is set
        if (wabaId == null) {
            throw new ApiException("Missing the required parameter 'wabaId' when calling updateProfile(Async)");
        }
        
        // verify the required parameter 'phoneNumber' is set
        if (phoneNumber == null) {
            throw new ApiException("Missing the required parameter 'phoneNumber' when calling updateProfile(Async)");
        }
        
        // verify the required parameter 'whatsappPhoneNumberProfileUpdateRequest' is set
        if (whatsappPhoneNumberProfileUpdateRequest == null) {
            throw new ApiException("Missing the required parameter 'whatsappPhoneNumberProfileUpdateRequest' when calling updateProfile(Async)");
        }
        

        okhttp3.Call localVarCall = updateProfileCall(wabaId, phoneNumber, whatsappPhoneNumberProfileUpdateRequest, _callback);
        return localVarCall;

    }

    /**
     * Update a phone number profile
     * <p>
     * Updates a WhatsApp business phone number profile.
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @param whatsappPhoneNumberProfileUpdateRequest  (required)
     * @return WhatsappPhoneNumberProfile
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully updated the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public WhatsappPhoneNumberProfile updateProfile(String wabaId, String phoneNumber, WhatsappPhoneNumberProfileUpdateRequest whatsappPhoneNumberProfileUpdateRequest) throws ApiException {
        ApiResponse<WhatsappPhoneNumberProfile> localVarResp = updateProfileWithHttpInfo(wabaId, phoneNumber, whatsappPhoneNumberProfileUpdateRequest);
        return localVarResp.getData();
    }

    /**
     * Update a phone number profile
     * <p>
     * Updates a WhatsApp business phone number profile.
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @param whatsappPhoneNumberProfileUpdateRequest  (required)
     * @return ApiResponse&lt;WhatsappPhoneNumberProfile&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully updated the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public ApiResponse<WhatsappPhoneNumberProfile> updateProfileWithHttpInfo(String wabaId, String phoneNumber, WhatsappPhoneNumberProfileUpdateRequest whatsappPhoneNumberProfileUpdateRequest) throws ApiException {
        okhttp3.Call localVarCall = updateProfileValidateBeforeCall(wabaId, phoneNumber, whatsappPhoneNumberProfileUpdateRequest, null);
        Type localVarReturnType = new TypeToken<WhatsappPhoneNumberProfile>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    /**
     * Update a phone number profile (asynchronously)
     * <p>
     * Updates a WhatsApp business phone number profile.
     * @param wabaId WhatsApp Business Account ID. (required)
     * @param phoneNumber Phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format. (required)
     * @param whatsappPhoneNumberProfileUpdateRequest  (required)
     * @param _callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Successfully updated the object. </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> The requested resource does not exist. </td><td>  -  </td></tr>
     </table>
     */
    public okhttp3.Call updateProfileAsync(String wabaId, String phoneNumber, WhatsappPhoneNumberProfileUpdateRequest whatsappPhoneNumberProfileUpdateRequest, final ApiCallback<WhatsappPhoneNumberProfile> _callback) throws ApiException {

        okhttp3.Call localVarCall = updateProfileValidateBeforeCall(wabaId, phoneNumber, whatsappPhoneNumberProfileUpdateRequest, _callback);
        Type localVarReturnType = new TypeToken<WhatsappPhoneNumberProfile>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}
