/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Date;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * Represents a custom property of a custom event definition.
 */
@ApiModel(description = "Represents a custom property of a custom event definition.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class CustomEventDefinitionProperty {
  public static final String SERIALIZED_NAME_NAME = "name";
  /**
   * The name of the custom property.
  **/
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_LABEL = "label";
  /**
   * The label of the property, used for display purposes.
  **/
  @SerializedName(SERIALIZED_NAME_LABEL)
  private String label;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  /**
   * The description of the property.
  **/
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_CREATE_TIME = "createTime";
  /**
   * The time at which this object is created, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_CREATE_TIME)
  private Date createTime;

  /**
   * The data type of the property. - &#x60;STRING&#x60;: Indicates a property that receives plain text strings. - &#x60;NUMBER&#x60;: Indicates a property that receives numeric values with up to one decimal. - &#x60;TIMESTAMP&#x60;: Indicates a property that receives epoch millisecond. - &#x60;URL&#x60;: Indicates a property that receives URLs, formatted as strings starting with &#x60;http://&#x60; or &#x60;https://&#x60;.
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    STRING("STRING"),
    
    NUMBER("NUMBER"),
    
    TIMESTAMP("TIMESTAMP"),
    
    URL("URL");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  /**
   * The data type of the property. - &#x60;STRING&#x60;: Indicates a property that receives plain text strings. - &#x60;NUMBER&#x60;: Indicates a property that receives numeric values with up to one decimal. - &#x60;TIMESTAMP&#x60;: Indicates a property that receives epoch millisecond. - &#x60;URL&#x60;: Indicates a property that receives URLs, formatted as strings starting with &#x60;http://&#x60; or &#x60;https://&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  public CustomEventDefinitionProperty() { 
  }

  public CustomEventDefinitionProperty name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * The name of the custom property.
   * @return name
  **/
  @javax.annotation.Nullable

  public String getName() {
    return name;
  }


  /**
   * The name of the custom property.
   **/
  @ApiModelProperty(example = "propertyName", value = "The name of the custom property.")
  public void setName(String name) {
    this.name = name;
  }


  public CustomEventDefinitionProperty label(String label) {
    
    this.label = label;
    return this;
  }

   /**
   * The label of the property, used for display purposes.
   * @return label
  **/
  @javax.annotation.Nullable

  public String getLabel() {
    return label;
  }


  /**
   * The label of the property, used for display purposes.
   **/
  @ApiModelProperty(example = "Property Label", value = "The label of the property, used for display purposes.")
  public void setLabel(String label) {
    this.label = label;
  }


  public CustomEventDefinitionProperty description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * The description of the property.
   * @return description
  **/
  @javax.annotation.Nullable

  public String getDescription() {
    return description;
  }


  /**
   * The description of the property.
   **/
  @ApiModelProperty(example = "Describes this property", value = "The description of the property.")
  public void setDescription(String description) {
    this.description = description;
  }


  public CustomEventDefinitionProperty createTime(Date createTime) {
    
    this.createTime = createTime;
    return this;
  }

   /**
   * The time at which this object is created, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
   * @return createTime
  **/
  @javax.annotation.Nullable

  public Date getCreateTime() {
    return createTime;
  }


  /**
   * The time at which this object is created, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
   **/
  @ApiModelProperty(example = "2024-08-22T00:00Z", value = "The time at which this object is created, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., `2022-06-01T12:00:00.000Z`.")
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }


  public CustomEventDefinitionProperty type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The data type of the property. - &#x60;STRING&#x60;: Indicates a property that receives plain text strings. - &#x60;NUMBER&#x60;: Indicates a property that receives numeric values with up to one decimal. - &#x60;TIMESTAMP&#x60;: Indicates a property that receives epoch millisecond. - &#x60;URL&#x60;: Indicates a property that receives URLs, formatted as strings starting with &#x60;http://&#x60; or &#x60;https://&#x60;.
   * @return type
  **/
  @javax.annotation.Nullable

  public TypeEnum getType() {
    return type;
  }


  /**
   * The data type of the property. - &#x60;STRING&#x60;: Indicates a property that receives plain text strings. - &#x60;NUMBER&#x60;: Indicates a property that receives numeric values with up to one decimal. - &#x60;TIMESTAMP&#x60;: Indicates a property that receives epoch millisecond. - &#x60;URL&#x60;: Indicates a property that receives URLs, formatted as strings starting with &#x60;http://&#x60; or &#x60;https://&#x60;.
   **/
  @ApiModelProperty(value = "The data type of the property. - `STRING`: Indicates a property that receives plain text strings. - `NUMBER`: Indicates a property that receives numeric values with up to one decimal. - `TIMESTAMP`: Indicates a property that receives epoch millisecond. - `URL`: Indicates a property that receives URLs, formatted as strings starting with `http://` or `https://`.")
  public void setType(TypeEnum type) {
    this.type = type;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public CustomEventDefinitionProperty putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CustomEventDefinitionProperty customEventDefinitionProperty = (CustomEventDefinitionProperty) o;
    return Objects.equals(this.name, customEventDefinitionProperty.name) &&
        Objects.equals(this.label, customEventDefinitionProperty.label) &&
        Objects.equals(this.description, customEventDefinitionProperty.description) &&
        Objects.equals(this.createTime, customEventDefinitionProperty.createTime) &&
        Objects.equals(this.type, customEventDefinitionProperty.type)&&
        Objects.equals(this.additionalProperties, customEventDefinitionProperty.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, label, description, createTime, type, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CustomEventDefinitionProperty {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    label: ").append(toIndentedString(label)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("name");
    openapiFields.add("label");
    openapiFields.add("description");
    openapiFields.add("createTime");
    openapiFields.add("type");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to CustomEventDefinitionProperty
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (CustomEventDefinitionProperty.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in CustomEventDefinitionProperty is not found in the empty JSON string", CustomEventDefinitionProperty.openapiRequiredFields.toString()));
        }
      }
      if (jsonObj.get("name") != null && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if (jsonObj.get("label") != null && !jsonObj.get("label").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `label` to be a primitive type in the JSON string but got `%s`", jsonObj.get("label").toString()));
      }
      if (jsonObj.get("description") != null && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if (jsonObj.get("type") != null && !jsonObj.get("type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!CustomEventDefinitionProperty.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'CustomEventDefinitionProperty' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<CustomEventDefinitionProperty> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(CustomEventDefinitionProperty.class));

       return (TypeAdapter<T>) new TypeAdapter<CustomEventDefinitionProperty>() {
           @Override
           public void write(JsonWriter out, CustomEventDefinitionProperty value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public CustomEventDefinitionProperty read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             CustomEventDefinitionProperty instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of CustomEventDefinitionProperty given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of CustomEventDefinitionProperty
  * @throws IOException if the JSON string is invalid with respect to CustomEventDefinitionProperty
  */
  public static CustomEventDefinitionProperty fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, CustomEventDefinitionProperty.class);
  }

 /**
  * Convert an instance of CustomEventDefinitionProperty to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

