/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.model.EmailContentType;
import com.ycloud.client.model.Mailbox;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * Email
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class Email {
  public static final String SERIALIZED_NAME_ID = "id";
  /**
   * Unique ID for the object.
  **/
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_FROM = "from";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_FROM)
  private Mailbox from;

  public static final String SERIALIZED_NAME_TO = "to";
  /**
   * The intended recipients&#39; email addresses.
  **/
  @SerializedName(SERIALIZED_NAME_TO)
  private List<Mailbox> to = null;

  public static final String SERIALIZED_NAME_CC = "cc";
  /**
   * Recipients who will receive a copy of the email.
  **/
  @SerializedName(SERIALIZED_NAME_CC)
  private List<Mailbox> cc = null;

  public static final String SERIALIZED_NAME_BCC = "bcc";
  /**
   * Recipients who will receive a blind carbon copy of the email.
  **/
  @SerializedName(SERIALIZED_NAME_BCC)
  private List<Mailbox> bcc = null;

  public static final String SERIALIZED_NAME_REPLY_TO = "replyTo";
  /**
   * If this field exists, then the reply should go to the addresses indicated in that field and not to the address(es) indicated in the &#x60;from&#x60; field.
  **/
  @SerializedName(SERIALIZED_NAME_REPLY_TO)
  private List<Mailbox> replyTo = null;

  public static final String SERIALIZED_NAME_SUBJECT = "subject";
  /**
   * The email subject, which contains a short string identifying the topic of the message.
  **/
  @SerializedName(SERIALIZED_NAME_SUBJECT)
  private String subject;

  public static final String SERIALIZED_NAME_SUMMARY = "summary";
  /**
   * This is a summary of your email. Max length: 70.
  **/
  @SerializedName(SERIALIZED_NAME_SUMMARY)
  private String summary;

  public static final String SERIALIZED_NAME_CONTENT_TYPE = "contentType";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_CONTENT_TYPE)
  private EmailContentType contentType;

  public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
  /**
   * A unique string to reference the object. This can be an order number or similar, and can be used to reconcile the object with your internal systems.
  **/
  @SerializedName(SERIALIZED_NAME_EXTERNAL_ID)
  private String externalId;

  public static final String SERIALIZED_NAME_CALLBACK_URL = "callbackUrl";
  /**
   * Delivery report URL. You can provide a URL, and we will push the updated status report to your server in time. e.g., https://httpbin.org/anything?tag&#x3D;api. Note: We recommend configuring Webhook Endpoints instead.
  **/
  @SerializedName(SERIALIZED_NAME_CALLBACK_URL)
  private String callbackUrl;

  public static final String SERIALIZED_NAME_CREATE_TIME = "createTime";
  /**
   * The time at which this message was created, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_CREATE_TIME)
  private Date createTime;

  public static final String SERIALIZED_NAME_TOTAL_RECIPIENTS = "totalRecipients";
  /**
   * Total recipients of this message, including &#x60;to&#x60;, &#x60;cc&#x60; and &#x60;bcc&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_TOTAL_RECIPIENTS)
  private Integer totalRecipients;

  public static final String SERIALIZED_NAME_TOTAL_PRICE = "totalPrice";
  /**
   * Total price of this message.
  **/
  @SerializedName(SERIALIZED_NAME_TOTAL_PRICE)
  private Double totalPrice;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  /**
   * Price currency. [ISO 4217 currency code](https://en.wikipedia.org/wiki/ISO_4217).
  **/
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private String currency;

  public Email() { 
  }

  public Email id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Unique ID for the object.
   * @return id
  **/
  @javax.annotation.Nonnull

  public String getId() {
    return id;
  }


  /**
   * Unique ID for the object.
   **/
  @ApiModelProperty(required = true, value = "Unique ID for the object.")
  public void setId(String id) {
    this.id = id;
  }


  public Email from(Mailbox from) {
    
    this.from = from;
    return this;
  }

   /**
   * Get from
   * @return from
  **/
  @javax.annotation.Nullable

  public Mailbox getFrom() {
    return from;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setFrom(Mailbox from) {
    this.from = from;
  }


  public Email to(List<Mailbox> to) {
    
    this.to = to;
    return this;
  }

  public Email addToItem(Mailbox toItem) {
    if (this.to == null) {
      this.to = new ArrayList<>();
    }
    this.to.add(toItem);
    return this;
  }

   /**
   * The intended recipients&#39; email addresses.
   * @return to
  **/
  @javax.annotation.Nullable

  public List<Mailbox> getTo() {
    return to;
  }


  /**
   * The intended recipients&#39; email addresses.
   **/
  @ApiModelProperty(value = "The intended recipients' email addresses.")
  public void setTo(List<Mailbox> to) {
    this.to = to;
  }


  public Email cc(List<Mailbox> cc) {
    
    this.cc = cc;
    return this;
  }

  public Email addCcItem(Mailbox ccItem) {
    if (this.cc == null) {
      this.cc = new ArrayList<>();
    }
    this.cc.add(ccItem);
    return this;
  }

   /**
   * Recipients who will receive a copy of the email.
   * @return cc
  **/
  @javax.annotation.Nullable

  public List<Mailbox> getCc() {
    return cc;
  }


  /**
   * Recipients who will receive a copy of the email.
   **/
  @ApiModelProperty(value = "Recipients who will receive a copy of the email.")
  public void setCc(List<Mailbox> cc) {
    this.cc = cc;
  }


  public Email bcc(List<Mailbox> bcc) {
    
    this.bcc = bcc;
    return this;
  }

  public Email addBccItem(Mailbox bccItem) {
    if (this.bcc == null) {
      this.bcc = new ArrayList<>();
    }
    this.bcc.add(bccItem);
    return this;
  }

   /**
   * Recipients who will receive a blind carbon copy of the email.
   * @return bcc
  **/
  @javax.annotation.Nullable

  public List<Mailbox> getBcc() {
    return bcc;
  }


  /**
   * Recipients who will receive a blind carbon copy of the email.
   **/
  @ApiModelProperty(value = "Recipients who will receive a blind carbon copy of the email.")
  public void setBcc(List<Mailbox> bcc) {
    this.bcc = bcc;
  }


  public Email replyTo(List<Mailbox> replyTo) {
    
    this.replyTo = replyTo;
    return this;
  }

  public Email addReplyToItem(Mailbox replyToItem) {
    if (this.replyTo == null) {
      this.replyTo = new ArrayList<>();
    }
    this.replyTo.add(replyToItem);
    return this;
  }

   /**
   * If this field exists, then the reply should go to the addresses indicated in that field and not to the address(es) indicated in the &#x60;from&#x60; field.
   * @return replyTo
  **/
  @javax.annotation.Nullable

  public List<Mailbox> getReplyTo() {
    return replyTo;
  }


  /**
   * If this field exists, then the reply should go to the addresses indicated in that field and not to the address(es) indicated in the &#x60;from&#x60; field.
   **/
  @ApiModelProperty(value = "If this field exists, then the reply should go to the addresses indicated in that field and not to the address(es) indicated in the `from` field.")
  public void setReplyTo(List<Mailbox> replyTo) {
    this.replyTo = replyTo;
  }


  public Email subject(String subject) {
    
    this.subject = subject;
    return this;
  }

   /**
   * The email subject, which contains a short string identifying the topic of the message.
   * @return subject
  **/
  @javax.annotation.Nullable

  public String getSubject() {
    return subject;
  }


  /**
   * The email subject, which contains a short string identifying the topic of the message.
   **/
  @ApiModelProperty(value = "The email subject, which contains a short string identifying the topic of the message.")
  public void setSubject(String subject) {
    this.subject = subject;
  }


  public Email summary(String summary) {
    
    this.summary = summary;
    return this;
  }

   /**
   * This is a summary of your email. Max length: 70.
   * @return summary
  **/
  @javax.annotation.Nullable

  public String getSummary() {
    return summary;
  }


  /**
   * This is a summary of your email. Max length: 70.
   **/
  @ApiModelProperty(example = "This is a summary.", value = "This is a summary of your email. Max length: 70.")
  public void setSummary(String summary) {
    this.summary = summary;
  }


  public Email contentType(EmailContentType contentType) {
    
    this.contentType = contentType;
    return this;
  }

   /**
   * Get contentType
   * @return contentType
  **/
  @javax.annotation.Nullable

  public EmailContentType getContentType() {
    return contentType;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setContentType(EmailContentType contentType) {
    this.contentType = contentType;
  }


  public Email externalId(String externalId) {
    
    this.externalId = externalId;
    return this;
  }

   /**
   * A unique string to reference the object. This can be an order number or similar, and can be used to reconcile the object with your internal systems.
   * @return externalId
  **/
  @javax.annotation.Nullable

  public String getExternalId() {
    return externalId;
  }


  /**
   * A unique string to reference the object. This can be an order number or similar, and can be used to reconcile the object with your internal systems.
   **/
  @ApiModelProperty(value = "A unique string to reference the object. This can be an order number or similar, and can be used to reconcile the object with your internal systems.")
  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }


  public Email callbackUrl(String callbackUrl) {
    
    this.callbackUrl = callbackUrl;
    return this;
  }

   /**
   * Delivery report URL. You can provide a URL, and we will push the updated status report to your server in time. e.g., https://httpbin.org/anything?tag&#x3D;api. Note: We recommend configuring Webhook Endpoints instead.
   * @return callbackUrl
  **/
  @javax.annotation.Nullable

  public String getCallbackUrl() {
    return callbackUrl;
  }


  /**
   * Delivery report URL. You can provide a URL, and we will push the updated status report to your server in time. e.g., https://httpbin.org/anything?tag&#x3D;api. Note: We recommend configuring Webhook Endpoints instead.
   **/
  @ApiModelProperty(example = "https://httpbin.org/anything?tag=api-email", value = "Delivery report URL. You can provide a URL, and we will push the updated status report to your server in time. e.g., https://httpbin.org/anything?tag=api. Note: We recommend configuring Webhook Endpoints instead.")
  public void setCallbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
  }


  public Email createTime(Date createTime) {
    
    this.createTime = createTime;
    return this;
  }

   /**
   * The time at which this message was created, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
   * @return createTime
  **/
  @javax.annotation.Nullable

  public Date getCreateTime() {
    return createTime;
  }


  /**
   * The time at which this message was created, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
   **/
  @ApiModelProperty(example = "2022-06-01T12:00Z", value = "The time at which this message was created, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., `2022-06-01T12:00:00.000Z`.")
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }


  public Email totalRecipients(Integer totalRecipients) {
    
    this.totalRecipients = totalRecipients;
    return this;
  }

   /**
   * Total recipients of this message, including &#x60;to&#x60;, &#x60;cc&#x60; and &#x60;bcc&#x60;.
   * @return totalRecipients
  **/
  @javax.annotation.Nullable

  public Integer getTotalRecipients() {
    return totalRecipients;
  }


  /**
   * Total recipients of this message, including &#x60;to&#x60;, &#x60;cc&#x60; and &#x60;bcc&#x60;.
   **/
  @ApiModelProperty(example = "3", value = "Total recipients of this message, including `to`, `cc` and `bcc`.")
  public void setTotalRecipients(Integer totalRecipients) {
    this.totalRecipients = totalRecipients;
  }


  public Email totalPrice(Double totalPrice) {
    
    this.totalPrice = totalPrice;
    return this;
  }

   /**
   * Total price of this message.
   * @return totalPrice
  **/
  @javax.annotation.Nullable

  public Double getTotalPrice() {
    return totalPrice;
  }


  /**
   * Total price of this message.
   **/
  @ApiModelProperty(example = "0.0085", value = "Total price of this message.")
  public void setTotalPrice(Double totalPrice) {
    this.totalPrice = totalPrice;
  }


  public Email currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Price currency. [ISO 4217 currency code](https://en.wikipedia.org/wiki/ISO_4217).
   * @return currency
  **/
  @javax.annotation.Nullable

  public String getCurrency() {
    return currency;
  }


  /**
   * Price currency. [ISO 4217 currency code](https://en.wikipedia.org/wiki/ISO_4217).
   **/
  @ApiModelProperty(example = "USD", value = "Price currency. [ISO 4217 currency code](https://en.wikipedia.org/wiki/ISO_4217).")
  public void setCurrency(String currency) {
    this.currency = currency;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public Email putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Email email = (Email) o;
    return Objects.equals(this.id, email.id) &&
        Objects.equals(this.from, email.from) &&
        Objects.equals(this.to, email.to) &&
        Objects.equals(this.cc, email.cc) &&
        Objects.equals(this.bcc, email.bcc) &&
        Objects.equals(this.replyTo, email.replyTo) &&
        Objects.equals(this.subject, email.subject) &&
        Objects.equals(this.summary, email.summary) &&
        Objects.equals(this.contentType, email.contentType) &&
        Objects.equals(this.externalId, email.externalId) &&
        Objects.equals(this.callbackUrl, email.callbackUrl) &&
        Objects.equals(this.createTime, email.createTime) &&
        Objects.equals(this.totalRecipients, email.totalRecipients) &&
        Objects.equals(this.totalPrice, email.totalPrice) &&
        Objects.equals(this.currency, email.currency)&&
        Objects.equals(this.additionalProperties, email.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, from, to, cc, bcc, replyTo, subject, summary, contentType, externalId, callbackUrl, createTime, totalRecipients, totalPrice, currency, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Email {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("    cc: ").append(toIndentedString(cc)).append("\n");
    sb.append("    bcc: ").append(toIndentedString(bcc)).append("\n");
    sb.append("    replyTo: ").append(toIndentedString(replyTo)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    summary: ").append(toIndentedString(summary)).append("\n");
    sb.append("    contentType: ").append(toIndentedString(contentType)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    callbackUrl: ").append(toIndentedString(callbackUrl)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    totalRecipients: ").append(toIndentedString(totalRecipients)).append("\n");
    sb.append("    totalPrice: ").append(toIndentedString(totalPrice)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("from");
    openapiFields.add("to");
    openapiFields.add("cc");
    openapiFields.add("bcc");
    openapiFields.add("replyTo");
    openapiFields.add("subject");
    openapiFields.add("summary");
    openapiFields.add("contentType");
    openapiFields.add("externalId");
    openapiFields.add("callbackUrl");
    openapiFields.add("createTime");
    openapiFields.add("totalRecipients");
    openapiFields.add("totalPrice");
    openapiFields.add("currency");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Email
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (Email.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in Email is not found in the empty JSON string", Email.openapiRequiredFields.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Email.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      // validate the optional field `from`
      if (jsonObj.getAsJsonObject("from") != null) {
        Mailbox.validateJsonObject(jsonObj.getAsJsonObject("from"));
      }
      JsonArray jsonArrayto = jsonObj.getAsJsonArray("to");
      if (jsonArrayto != null) {
        // ensure the json data is an array
        if (!jsonObj.get("to").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `to` to be an array in the JSON string but got `%s`", jsonObj.get("to").toString()));
        }

        // validate the optional field `to` (array)
        for (int i = 0; i < jsonArrayto.size(); i++) {
          Mailbox.validateJsonObject(jsonArrayto.get(i).getAsJsonObject());
        };
      }
      JsonArray jsonArraycc = jsonObj.getAsJsonArray("cc");
      if (jsonArraycc != null) {
        // ensure the json data is an array
        if (!jsonObj.get("cc").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `cc` to be an array in the JSON string but got `%s`", jsonObj.get("cc").toString()));
        }

        // validate the optional field `cc` (array)
        for (int i = 0; i < jsonArraycc.size(); i++) {
          Mailbox.validateJsonObject(jsonArraycc.get(i).getAsJsonObject());
        };
      }
      JsonArray jsonArraybcc = jsonObj.getAsJsonArray("bcc");
      if (jsonArraybcc != null) {
        // ensure the json data is an array
        if (!jsonObj.get("bcc").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `bcc` to be an array in the JSON string but got `%s`", jsonObj.get("bcc").toString()));
        }

        // validate the optional field `bcc` (array)
        for (int i = 0; i < jsonArraybcc.size(); i++) {
          Mailbox.validateJsonObject(jsonArraybcc.get(i).getAsJsonObject());
        };
      }
      JsonArray jsonArrayreplyTo = jsonObj.getAsJsonArray("replyTo");
      if (jsonArrayreplyTo != null) {
        // ensure the json data is an array
        if (!jsonObj.get("replyTo").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `replyTo` to be an array in the JSON string but got `%s`", jsonObj.get("replyTo").toString()));
        }

        // validate the optional field `replyTo` (array)
        for (int i = 0; i < jsonArrayreplyTo.size(); i++) {
          Mailbox.validateJsonObject(jsonArrayreplyTo.get(i).getAsJsonObject());
        };
      }
      if (jsonObj.get("subject") != null && !jsonObj.get("subject").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `subject` to be a primitive type in the JSON string but got `%s`", jsonObj.get("subject").toString()));
      }
      if (jsonObj.get("summary") != null && !jsonObj.get("summary").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `summary` to be a primitive type in the JSON string but got `%s`", jsonObj.get("summary").toString()));
      }
      if (jsonObj.get("externalId") != null && !jsonObj.get("externalId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `externalId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("externalId").toString()));
      }
      if (jsonObj.get("callbackUrl") != null && !jsonObj.get("callbackUrl").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `callbackUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("callbackUrl").toString()));
      }
      if (jsonObj.get("currency") != null && !jsonObj.get("currency").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("currency").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Email.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Email' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Email> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Email.class));

       return (TypeAdapter<T>) new TypeAdapter<Email>() {
           @Override
           public void write(JsonWriter out, Email value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public Email read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             Email instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Email given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Email
  * @throws IOException if the JSON string is invalid with respect to Email
  */
  public static Email fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Email.class);
  }

 /**
  * Convert an instance of Email to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

