/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.model.EmailContentType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * EmailSendRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class EmailSendRequest {
  public static final String SERIALIZED_NAME_FROM = "from";
  /**
   * - The sender&#39;s email. Its domain should be one that has been registered and activated in your account. - The sender&#39;s email address is required while the sender&#39;s name is optional. For example, both &#x60;support@example.com&#x60; and &#x60;Sender&lt;support@example.com&gt;&#x60; work.
  **/
  @SerializedName(SERIALIZED_NAME_FROM)
  private String from;

  public static final String SERIALIZED_NAME_TO = "to";
  /**
   * - The intended recipients&#39; email addresses. - Supports a comma-separated list of one or more addresses. Max items: 100.
  **/
  @SerializedName(SERIALIZED_NAME_TO)
  private String to;

  public static final String SERIALIZED_NAME_SUBJECT = "subject";
  /**
   * The email subject, which contains a short string identifying the topic of the message. Max length: 255.
  **/
  @SerializedName(SERIALIZED_NAME_SUBJECT)
  private String subject;

  public static final String SERIALIZED_NAME_CONTENT = "content";
  /**
   * - The email body. Max size: 150 KB. - Variables in the form of &#x60;#var_1#&#x60; are supported, they should be used together with the &#x60;variables&#x60; parameter. Variable keys only support letters, digits, and the underline character (&#x60;_&#x60;). - You can use the [Test Templates](https://help.ycloud.com/en/articles/6006545) provided by YCloud for testing.
  **/
  @SerializedName(SERIALIZED_NAME_CONTENT)
  private String content;

  public static final String SERIALIZED_NAME_CONTENT_TYPE = "contentType";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_CONTENT_TYPE)
  private EmailContentType contentType;

  public static final String SERIALIZED_NAME_VARIABLES = "variables";
  /**
   * - The variable key-value pairs that will replace the variable placeholders in &#x60;content&#x60; for each recipient. Variable keys are those that are wrapped with &#x60;#&#x60; as placeholders (e.g., &#x60;#var_1#&#x60;) in &#x60;content&#x60;. The placeholders will be replaced by variable values when sending the email. - The size of the array must be the same as the number of recipients in &#x60;to&#x60;. Be aware that &#x60;cc&#x60; and &#x60;bcc&#x60; addresses are excluded, and they can not receive emails that contain variables. - This parameter&#39;s size will be calculated together with the parameter &#x60;content&#x60;. The whole size must not exceed 150 KB.
  **/
  @SerializedName(SERIALIZED_NAME_VARIABLES)
  private List<Map<String, String>> variables = null;

  public static final String SERIALIZED_NAME_CC = "cc";
  /**
   * Recipients who will receive a copy of the email.
  **/
  @SerializedName(SERIALIZED_NAME_CC)
  private String cc;

  public static final String SERIALIZED_NAME_BCC = "bcc";
  /**
   * Recipients who will receive a blind carbon copy of the email.
  **/
  @SerializedName(SERIALIZED_NAME_BCC)
  private String bcc;

  public static final String SERIALIZED_NAME_REPLY_TO = "replyTo";
  /**
   * If this field exists, then the reply should go to the addresses indicated in that field and not to the address(es) indicated in the &#x60;from&#x60; field.
  **/
  @SerializedName(SERIALIZED_NAME_REPLY_TO)
  private String replyTo;

  public static final String SERIALIZED_NAME_SUMMARY = "summary";
  /**
   * This is a summary of your email. Max length: 70.
  **/
  @SerializedName(SERIALIZED_NAME_SUMMARY)
  private String summary;

  public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
  /**
   * A unique string to reference the object. This can be an order number or similar, and can be used to reconcile the object with your internal systems.
  **/
  @SerializedName(SERIALIZED_NAME_EXTERNAL_ID)
  private String externalId;

  public static final String SERIALIZED_NAME_CALLBACK_URL = "callbackUrl";
  /**
   * Delivery report URL. You can provide a URL, and we will push the updated status report to your server in time. e.g., https://httpbin.org/anything?tag&#x3D;api. Note: We recommend configuring Webhook Endpoints instead.
  **/
  @SerializedName(SERIALIZED_NAME_CALLBACK_URL)
  private String callbackUrl;

  public EmailSendRequest() { 
  }

  public EmailSendRequest from(String from) {
    
    this.from = from;
    return this;
  }

   /**
   * - The sender&#39;s email. Its domain should be one that has been registered and activated in your account. - The sender&#39;s email address is required while the sender&#39;s name is optional. For example, both &#x60;support@example.com&#x60; and &#x60;Sender&lt;support@example.com&gt;&#x60; work.
   * @return from
  **/
  @javax.annotation.Nonnull

  public String getFrom() {
    return from;
  }


  /**
   * - The sender&#39;s email. Its domain should be one that has been registered and activated in your account. - The sender&#39;s email address is required while the sender&#39;s name is optional. For example, both &#x60;support@example.com&#x60; and &#x60;Sender&lt;support@example.com&gt;&#x60; work.
   **/
  @ApiModelProperty(example = "SupportTeam<support@example.com>", required = true, value = "- The sender's email. Its domain should be one that has been registered and activated in your account. - The sender's email address is required while the sender's name is optional. For example, both `support@example.com` and `Sender<support@example.com>` work.")
  public void setFrom(String from) {
    this.from = from;
  }


  public EmailSendRequest to(String to) {
    
    this.to = to;
    return this;
  }

   /**
   * - The intended recipients&#39; email addresses. - Supports a comma-separated list of one or more addresses. Max items: 100.
   * @return to
  **/
  @javax.annotation.Nonnull

  public String getTo() {
    return to;
  }


  /**
   * - The intended recipients&#39; email addresses. - Supports a comma-separated list of one or more addresses. Max items: 100.
   **/
  @ApiModelProperty(example = "to1@example.com,Nick<to2@example.com>", required = true, value = "- The intended recipients' email addresses. - Supports a comma-separated list of one or more addresses. Max items: 100.")
  public void setTo(String to) {
    this.to = to;
  }


  public EmailSendRequest subject(String subject) {
    
    this.subject = subject;
    return this;
  }

   /**
   * The email subject, which contains a short string identifying the topic of the message. Max length: 255.
   * @return subject
  **/
  @javax.annotation.Nonnull

  public String getSubject() {
    return subject;
  }


  /**
   * The email subject, which contains a short string identifying the topic of the message. Max length: 255.
   **/
  @ApiModelProperty(required = true, value = "The email subject, which contains a short string identifying the topic of the message. Max length: 255.")
  public void setSubject(String subject) {
    this.subject = subject;
  }


  public EmailSendRequest content(String content) {
    
    this.content = content;
    return this;
  }

   /**
   * - The email body. Max size: 150 KB. - Variables in the form of &#x60;#var_1#&#x60; are supported, they should be used together with the &#x60;variables&#x60; parameter. Variable keys only support letters, digits, and the underline character (&#x60;_&#x60;). - You can use the [Test Templates](https://help.ycloud.com/en/articles/6006545) provided by YCloud for testing.
   * @return content
  **/
  @javax.annotation.Nonnull

  public String getContent() {
    return content;
  }


  /**
   * - The email body. Max size: 150 KB. - Variables in the form of &#x60;#var_1#&#x60; are supported, they should be used together with the &#x60;variables&#x60; parameter. Variable keys only support letters, digits, and the underline character (&#x60;_&#x60;). - You can use the [Test Templates](https://help.ycloud.com/en/articles/6006545) provided by YCloud for testing.
   **/
  @ApiModelProperty(example = "This is a test message from #nick#.", required = true, value = "- The email body. Max size: 150 KB. - Variables in the form of `#var_1#` are supported, they should be used together with the `variables` parameter. Variable keys only support letters, digits, and the underline character (`_`). - You can use the [Test Templates](https://help.ycloud.com/en/articles/6006545) provided by YCloud for testing.")
  public void setContent(String content) {
    this.content = content;
  }


  public EmailSendRequest contentType(EmailContentType contentType) {
    
    this.contentType = contentType;
    return this;
  }

   /**
   * Get contentType
   * @return contentType
  **/
  @javax.annotation.Nullable

  public EmailContentType getContentType() {
    return contentType;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setContentType(EmailContentType contentType) {
    this.contentType = contentType;
  }


  public EmailSendRequest variables(List<Map<String, String>> variables) {
    
    this.variables = variables;
    return this;
  }

  public EmailSendRequest addVariablesItem(Map<String, String> variablesItem) {
    if (this.variables == null) {
      this.variables = new ArrayList<>();
    }
    this.variables.add(variablesItem);
    return this;
  }

   /**
   * - The variable key-value pairs that will replace the variable placeholders in &#x60;content&#x60; for each recipient. Variable keys are those that are wrapped with &#x60;#&#x60; as placeholders (e.g., &#x60;#var_1#&#x60;) in &#x60;content&#x60;. The placeholders will be replaced by variable values when sending the email. - The size of the array must be the same as the number of recipients in &#x60;to&#x60;. Be aware that &#x60;cc&#x60; and &#x60;bcc&#x60; addresses are excluded, and they can not receive emails that contain variables. - This parameter&#39;s size will be calculated together with the parameter &#x60;content&#x60;. The whole size must not exceed 150 KB.
   * @return variables
  **/
  @javax.annotation.Nullable

  public List<Map<String, String>> getVariables() {
    return variables;
  }


  /**
   * - The variable key-value pairs that will replace the variable placeholders in &#x60;content&#x60; for each recipient. Variable keys are those that are wrapped with &#x60;#&#x60; as placeholders (e.g., &#x60;#var_1#&#x60;) in &#x60;content&#x60;. The placeholders will be replaced by variable values when sending the email. - The size of the array must be the same as the number of recipients in &#x60;to&#x60;. Be aware that &#x60;cc&#x60; and &#x60;bcc&#x60; addresses are excluded, and they can not receive emails that contain variables. - This parameter&#39;s size will be calculated together with the parameter &#x60;content&#x60;. The whole size must not exceed 150 KB.
   **/
  @ApiModelProperty(value = "- The variable key-value pairs that will replace the variable placeholders in `content` for each recipient. Variable keys are those that are wrapped with `#` as placeholders (e.g., `#var_1#`) in `content`. The placeholders will be replaced by variable values when sending the email. - The size of the array must be the same as the number of recipients in `to`. Be aware that `cc` and `bcc` addresses are excluded, and they can not receive emails that contain variables. - This parameter's size will be calculated together with the parameter `content`. The whole size must not exceed 150 KB.")
  public void setVariables(List<Map<String, String>> variables) {
    this.variables = variables;
  }


  public EmailSendRequest cc(String cc) {
    
    this.cc = cc;
    return this;
  }

   /**
   * Recipients who will receive a copy of the email.
   * @return cc
  **/
  @javax.annotation.Nullable

  public String getCc() {
    return cc;
  }


  /**
   * Recipients who will receive a copy of the email.
   **/
  @ApiModelProperty(example = "cc1@example.com,Nick<cc2@example.com>", value = "Recipients who will receive a copy of the email.")
  public void setCc(String cc) {
    this.cc = cc;
  }


  public EmailSendRequest bcc(String bcc) {
    
    this.bcc = bcc;
    return this;
  }

   /**
   * Recipients who will receive a blind carbon copy of the email.
   * @return bcc
  **/
  @javax.annotation.Nullable

  public String getBcc() {
    return bcc;
  }


  /**
   * Recipients who will receive a blind carbon copy of the email.
   **/
  @ApiModelProperty(example = "bcc1@example.com,Nick<bcc2@example.com>", value = "Recipients who will receive a blind carbon copy of the email.")
  public void setBcc(String bcc) {
    this.bcc = bcc;
  }


  public EmailSendRequest replyTo(String replyTo) {
    
    this.replyTo = replyTo;
    return this;
  }

   /**
   * If this field exists, then the reply should go to the addresses indicated in that field and not to the address(es) indicated in the &#x60;from&#x60; field.
   * @return replyTo
  **/
  @javax.annotation.Nullable

  public String getReplyTo() {
    return replyTo;
  }


  /**
   * If this field exists, then the reply should go to the addresses indicated in that field and not to the address(es) indicated in the &#x60;from&#x60; field.
   **/
  @ApiModelProperty(value = "If this field exists, then the reply should go to the addresses indicated in that field and not to the address(es) indicated in the `from` field.")
  public void setReplyTo(String replyTo) {
    this.replyTo = replyTo;
  }


  public EmailSendRequest summary(String summary) {
    
    this.summary = summary;
    return this;
  }

   /**
   * This is a summary of your email. Max length: 70.
   * @return summary
  **/
  @javax.annotation.Nullable

  public String getSummary() {
    return summary;
  }


  /**
   * This is a summary of your email. Max length: 70.
   **/
  @ApiModelProperty(example = "This is a summary.", value = "This is a summary of your email. Max length: 70.")
  public void setSummary(String summary) {
    this.summary = summary;
  }


  public EmailSendRequest externalId(String externalId) {
    
    this.externalId = externalId;
    return this;
  }

   /**
   * A unique string to reference the object. This can be an order number or similar, and can be used to reconcile the object with your internal systems.
   * @return externalId
  **/
  @javax.annotation.Nullable

  public String getExternalId() {
    return externalId;
  }


  /**
   * A unique string to reference the object. This can be an order number or similar, and can be used to reconcile the object with your internal systems.
   **/
  @ApiModelProperty(value = "A unique string to reference the object. This can be an order number or similar, and can be used to reconcile the object with your internal systems.")
  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }


  public EmailSendRequest callbackUrl(String callbackUrl) {
    
    this.callbackUrl = callbackUrl;
    return this;
  }

   /**
   * Delivery report URL. You can provide a URL, and we will push the updated status report to your server in time. e.g., https://httpbin.org/anything?tag&#x3D;api. Note: We recommend configuring Webhook Endpoints instead.
   * @return callbackUrl
  **/
  @javax.annotation.Nullable

  public String getCallbackUrl() {
    return callbackUrl;
  }


  /**
   * Delivery report URL. You can provide a URL, and we will push the updated status report to your server in time. e.g., https://httpbin.org/anything?tag&#x3D;api. Note: We recommend configuring Webhook Endpoints instead.
   **/
  @ApiModelProperty(example = "https://httpbin.org/anything?tag=api-email", value = "Delivery report URL. You can provide a URL, and we will push the updated status report to your server in time. e.g., https://httpbin.org/anything?tag=api. Note: We recommend configuring Webhook Endpoints instead.")
  public void setCallbackUrl(String callbackUrl) {
    this.callbackUrl = callbackUrl;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public EmailSendRequest putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EmailSendRequest emailSendRequest = (EmailSendRequest) o;
    return Objects.equals(this.from, emailSendRequest.from) &&
        Objects.equals(this.to, emailSendRequest.to) &&
        Objects.equals(this.subject, emailSendRequest.subject) &&
        Objects.equals(this.content, emailSendRequest.content) &&
        Objects.equals(this.contentType, emailSendRequest.contentType) &&
        Objects.equals(this.variables, emailSendRequest.variables) &&
        Objects.equals(this.cc, emailSendRequest.cc) &&
        Objects.equals(this.bcc, emailSendRequest.bcc) &&
        Objects.equals(this.replyTo, emailSendRequest.replyTo) &&
        Objects.equals(this.summary, emailSendRequest.summary) &&
        Objects.equals(this.externalId, emailSendRequest.externalId) &&
        Objects.equals(this.callbackUrl, emailSendRequest.callbackUrl)&&
        Objects.equals(this.additionalProperties, emailSendRequest.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(from, to, subject, content, contentType, variables, cc, bcc, replyTo, summary, externalId, callbackUrl, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EmailSendRequest {\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    contentType: ").append(toIndentedString(contentType)).append("\n");
    sb.append("    variables: ").append(toIndentedString(variables)).append("\n");
    sb.append("    cc: ").append(toIndentedString(cc)).append("\n");
    sb.append("    bcc: ").append(toIndentedString(bcc)).append("\n");
    sb.append("    replyTo: ").append(toIndentedString(replyTo)).append("\n");
    sb.append("    summary: ").append(toIndentedString(summary)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    callbackUrl: ").append(toIndentedString(callbackUrl)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("from");
    openapiFields.add("to");
    openapiFields.add("subject");
    openapiFields.add("content");
    openapiFields.add("contentType");
    openapiFields.add("variables");
    openapiFields.add("cc");
    openapiFields.add("bcc");
    openapiFields.add("replyTo");
    openapiFields.add("summary");
    openapiFields.add("externalId");
    openapiFields.add("callbackUrl");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("from");
    openapiRequiredFields.add("to");
    openapiRequiredFields.add("subject");
    openapiRequiredFields.add("content");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to EmailSendRequest
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (EmailSendRequest.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in EmailSendRequest is not found in the empty JSON string", EmailSendRequest.openapiRequiredFields.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : EmailSendRequest.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (jsonObj.get("from") != null && !jsonObj.get("from").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `from` to be a primitive type in the JSON string but got `%s`", jsonObj.get("from").toString()));
      }
      if (jsonObj.get("to") != null && !jsonObj.get("to").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `to` to be a primitive type in the JSON string but got `%s`", jsonObj.get("to").toString()));
      }
      if (jsonObj.get("subject") != null && !jsonObj.get("subject").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `subject` to be a primitive type in the JSON string but got `%s`", jsonObj.get("subject").toString()));
      }
      if (jsonObj.get("content") != null && !jsonObj.get("content").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `content` to be a primitive type in the JSON string but got `%s`", jsonObj.get("content").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("variables") != null && !jsonObj.get("variables").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `variables` to be an array in the JSON string but got `%s`", jsonObj.get("variables").toString()));
      }
      if (jsonObj.get("cc") != null && !jsonObj.get("cc").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cc` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cc").toString()));
      }
      if (jsonObj.get("bcc") != null && !jsonObj.get("bcc").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `bcc` to be a primitive type in the JSON string but got `%s`", jsonObj.get("bcc").toString()));
      }
      if (jsonObj.get("replyTo") != null && !jsonObj.get("replyTo").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `replyTo` to be a primitive type in the JSON string but got `%s`", jsonObj.get("replyTo").toString()));
      }
      if (jsonObj.get("summary") != null && !jsonObj.get("summary").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `summary` to be a primitive type in the JSON string but got `%s`", jsonObj.get("summary").toString()));
      }
      if (jsonObj.get("externalId") != null && !jsonObj.get("externalId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `externalId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("externalId").toString()));
      }
      if (jsonObj.get("callbackUrl") != null && !jsonObj.get("callbackUrl").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `callbackUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("callbackUrl").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!EmailSendRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'EmailSendRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<EmailSendRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(EmailSendRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<EmailSendRequest>() {
           @Override
           public void write(JsonWriter out, EmailSendRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public EmailSendRequest read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             EmailSendRequest instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of EmailSendRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of EmailSendRequest
  * @throws IOException if the JSON string is invalid with respect to EmailSendRequest
  */
  public static EmailSendRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, EmailSendRequest.class);
  }

 /**
  * Convert an instance of EmailSendRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

