/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.model.WhatsappApiError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * Error
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class Error {
  public static final String SERIALIZED_NAME_STATUS = "status";
  /**
   * HTTP status code, [RFC 7231, Section 6](https://datatracker.ietf.org/doc/html/rfc7231#section-6). It conveys the HTTP status code used for the convenience of the consumer.
  **/
  @SerializedName(SERIALIZED_NAME_STATUS)
  private Integer status;

  public static final String SERIALIZED_NAME_CODE = "code";
  /**
   * One of a server-defined error codes. Some &#x60;4xx&#x60; errors that could be handled programmatically include an error code that briefly explains the error reported.
  **/
  @SerializedName(SERIALIZED_NAME_CODE)
  private String code;

  public static final String SERIALIZED_NAME_MESSAGE = "message";
  /**
   * A human-readable representation of the error. It is intended as an aid to developers and is not suitable for exposure to end users.
  **/
  @SerializedName(SERIALIZED_NAME_MESSAGE)
  private String message;

  public static final String SERIALIZED_NAME_TARGET = "target";
  /**
   * The target of the error.
  **/
  @SerializedName(SERIALIZED_NAME_TARGET)
  private String target;

  public static final String SERIALIZED_NAME_DOC_URL = "docUrl";
  /**
   * A URL to more information about the error.
  **/
  @SerializedName(SERIALIZED_NAME_DOC_URL)
  private String docUrl;

  public static final String SERIALIZED_NAME_REQUEST_ID = "requestId";
  /**
   * Each API request has an associated request ID. It conveys the response header &#x60;YCloud-Request-ID&#x60; used for the convenience of the consumer.
  **/
  @SerializedName(SERIALIZED_NAME_REQUEST_ID)
  private String requestId;

  public static final String SERIALIZED_NAME_WHATSAPP_API_ERROR = "whatsappApiError";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_WHATSAPP_API_ERROR)
  private WhatsappApiError whatsappApiError;

  public Error() { 
  }

  public Error status(Integer status) {
    
    this.status = status;
    return this;
  }

   /**
   * HTTP status code, [RFC 7231, Section 6](https://datatracker.ietf.org/doc/html/rfc7231#section-6). It conveys the HTTP status code used for the convenience of the consumer.
   * @return status
  **/
  @javax.annotation.Nonnull

  public Integer getStatus() {
    return status;
  }


  /**
   * HTTP status code, [RFC 7231, Section 6](https://datatracker.ietf.org/doc/html/rfc7231#section-6). It conveys the HTTP status code used for the convenience of the consumer.
   **/
  @ApiModelProperty(example = "404", required = true, value = "HTTP status code, [RFC 7231, Section 6](https://datatracker.ietf.org/doc/html/rfc7231#section-6). It conveys the HTTP status code used for the convenience of the consumer.")
  public void setStatus(Integer status) {
    this.status = status;
  }


  public Error code(String code) {
    
    this.code = code;
    return this;
  }

   /**
   * One of a server-defined error codes. Some &#x60;4xx&#x60; errors that could be handled programmatically include an error code that briefly explains the error reported.
   * @return code
  **/
  @javax.annotation.Nonnull

  public String getCode() {
    return code;
  }


  /**
   * One of a server-defined error codes. Some &#x60;4xx&#x60; errors that could be handled programmatically include an error code that briefly explains the error reported.
   **/
  @ApiModelProperty(example = "NOT_FOUND", required = true, value = "One of a server-defined error codes. Some `4xx` errors that could be handled programmatically include an error code that briefly explains the error reported.")
  public void setCode(String code) {
    this.code = code;
  }


  public Error message(String message) {
    
    this.message = message;
    return this;
  }

   /**
   * A human-readable representation of the error. It is intended as an aid to developers and is not suitable for exposure to end users.
   * @return message
  **/
  @javax.annotation.Nullable

  public String getMessage() {
    return message;
  }


  /**
   * A human-readable representation of the error. It is intended as an aid to developers and is not suitable for exposure to end users.
   **/
  @ApiModelProperty(example = "The requested resource does not exist.", value = "A human-readable representation of the error. It is intended as an aid to developers and is not suitable for exposure to end users.")
  public void setMessage(String message) {
    this.message = message;
  }


  public Error target(String target) {
    
    this.target = target;
    return this;
  }

   /**
   * The target of the error.
   * @return target
  **/
  @javax.annotation.Nullable

  public String getTarget() {
    return target;
  }


  /**
   * The target of the error.
   **/
  @ApiModelProperty(example = "", value = "The target of the error.")
  public void setTarget(String target) {
    this.target = target;
  }


  public Error docUrl(String docUrl) {
    
    this.docUrl = docUrl;
    return this;
  }

   /**
   * A URL to more information about the error.
   * @return docUrl
  **/
  @javax.annotation.Nullable

  public String getDocUrl() {
    return docUrl;
  }


  /**
   * A URL to more information about the error.
   **/
  @ApiModelProperty(example = "", value = "A URL to more information about the error.")
  public void setDocUrl(String docUrl) {
    this.docUrl = docUrl;
  }


  public Error requestId(String requestId) {
    
    this.requestId = requestId;
    return this;
  }

   /**
   * Each API request has an associated request ID. It conveys the response header &#x60;YCloud-Request-ID&#x60; used for the convenience of the consumer.
   * @return requestId
  **/
  @javax.annotation.Nullable

  public String getRequestId() {
    return requestId;
  }


  /**
   * Each API request has an associated request ID. It conveys the response header &#x60;YCloud-Request-ID&#x60; used for the convenience of the consumer.
   **/
  @ApiModelProperty(example = "req_1KjtKI80IKoaJNa6n6p", value = "Each API request has an associated request ID. It conveys the response header `YCloud-Request-ID` used for the convenience of the consumer.")
  public void setRequestId(String requestId) {
    this.requestId = requestId;
  }


  public Error whatsappApiError(WhatsappApiError whatsappApiError) {
    
    this.whatsappApiError = whatsappApiError;
    return this;
  }

   /**
   * Get whatsappApiError
   * @return whatsappApiError
  **/
  @javax.annotation.Nullable

  public WhatsappApiError getWhatsappApiError() {
    return whatsappApiError;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setWhatsappApiError(WhatsappApiError whatsappApiError) {
    this.whatsappApiError = whatsappApiError;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public Error putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Error error = (Error) o;
    return Objects.equals(this.status, error.status) &&
        Objects.equals(this.code, error.code) &&
        Objects.equals(this.message, error.message) &&
        Objects.equals(this.target, error.target) &&
        Objects.equals(this.docUrl, error.docUrl) &&
        Objects.equals(this.requestId, error.requestId) &&
        Objects.equals(this.whatsappApiError, error.whatsappApiError)&&
        Objects.equals(this.additionalProperties, error.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, code, message, target, docUrl, requestId, whatsappApiError, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Error {\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    target: ").append(toIndentedString(target)).append("\n");
    sb.append("    docUrl: ").append(toIndentedString(docUrl)).append("\n");
    sb.append("    requestId: ").append(toIndentedString(requestId)).append("\n");
    sb.append("    whatsappApiError: ").append(toIndentedString(whatsappApiError)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("status");
    openapiFields.add("code");
    openapiFields.add("message");
    openapiFields.add("target");
    openapiFields.add("docUrl");
    openapiFields.add("requestId");
    openapiFields.add("whatsappApiError");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("status");
    openapiRequiredFields.add("code");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Error
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (Error.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in Error is not found in the empty JSON string", Error.openapiRequiredFields.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : Error.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (jsonObj.get("code") != null && !jsonObj.get("code").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `code` to be a primitive type in the JSON string but got `%s`", jsonObj.get("code").toString()));
      }
      if (jsonObj.get("message") != null && !jsonObj.get("message").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `message` to be a primitive type in the JSON string but got `%s`", jsonObj.get("message").toString()));
      }
      if (jsonObj.get("target") != null && !jsonObj.get("target").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `target` to be a primitive type in the JSON string but got `%s`", jsonObj.get("target").toString()));
      }
      if (jsonObj.get("docUrl") != null && !jsonObj.get("docUrl").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `docUrl` to be a primitive type in the JSON string but got `%s`", jsonObj.get("docUrl").toString()));
      }
      if (jsonObj.get("requestId") != null && !jsonObj.get("requestId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `requestId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("requestId").toString()));
      }
      // validate the optional field `whatsappApiError`
      if (jsonObj.getAsJsonObject("whatsappApiError") != null) {
        WhatsappApiError.validateJsonObject(jsonObj.getAsJsonObject("whatsappApiError"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Error.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Error' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Error> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Error.class));

       return (TypeAdapter<T>) new TypeAdapter<Error>() {
           @Override
           public void write(JsonWriter out, Error value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public Error read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             Error instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Error given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Error
  * @throws IOException if the JSON string is invalid with respect to Error
  */
  public static Error fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Error.class);
  }

 /**
  * Convert an instance of Error to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

