/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import io.swagger.annotations.ApiModel;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Current status of business verification of Meta Business Account which owns this WhatsApp Business Account.
 */
@JsonAdapter(MetaBusinessAccountVerificationStatus.Adapter.class)
public enum MetaBusinessAccountVerificationStatus {
  
  EXPIRED("expired"),
  
  FAILED("failed"),
  
  INELIGIBLE("ineligible"),
  
  NOT_VERIFIED("not_verified"),
  
  PENDING("pending"),
  
  PENDING_NEED_MORE_INFO("pending_need_more_info"),
  
  PENDING_SUBMISSION("pending_submission"),
  
  REJECTED("rejected"),
  
  REVOKED("revoked"),
  
  VERIFIED("verified");

  private String value;

  MetaBusinessAccountVerificationStatus(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static MetaBusinessAccountVerificationStatus fromValue(String value) {
    for (MetaBusinessAccountVerificationStatus b : MetaBusinessAccountVerificationStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<MetaBusinessAccountVerificationStatus> {
    @Override
    public void write(final JsonWriter jsonWriter, final MetaBusinessAccountVerificationStatus enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public MetaBusinessAccountVerificationStatus read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return MetaBusinessAccountVerificationStatus.fromValue(value);
    }
  }
}

