/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import io.swagger.annotations.ApiModel;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Status of the verification. - &#x60;pending&#x60;: The verification message (SMS, Voice, etc.) is sent, waiting to be checked. This happens when you call the &#39;Start a verification&#39; API successfully. - &#x60;approved&#x60;: The verification has been successfully checked. A &#x60;pending&#x60; verification status changes to &#x60;approved&#x60; when you call the &#39;Check a verification&#39; API and receive a response with the &#x60;valid&#x60; parameter is &#x60;true&#x60;. An approved verification cannot be checked anymore. - &#x60;blocked&#x60;: The verification is blocked by user-defined rules such as denylist, and geographical permission restrictions. A blocked verification cannot be checked. - &#x60;expired&#x60;: The verification has expired and cannot be checked anymore. - &#x60;undelivered&#x60;: Our system has received a delivery receipt indicating that the verification message was not delivered. An undelivered verification cannot be checked anymore.
 */
@JsonAdapter(VerificationStatus.Adapter.class)
public enum VerificationStatus {
  
  PENDING("pending"),
  
  APPROVED("approved"),
  
  BLOCKED("blocked"),
  
  EXPIRED("expired"),
  
  UNDELIVERED("undelivered");

  private String value;

  VerificationStatus(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static VerificationStatus fromValue(String value) {
    for (VerificationStatus b : VerificationStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<VerificationStatus> {
    @Override
    public void write(final JsonWriter jsonWriter, final VerificationStatus enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public VerificationStatus read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return VerificationStatus.fromValue(value);
    }
  }
}

