/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import io.swagger.annotations.ApiModel;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Webhook endpoint status. - &#x60;active&#x60;: Indicates that the webhook endpoint is active, and will receive notifications of events monitored. - &#x60;disabled&#x60;: Indicates that the webhook endpoint is disabled, and will not receive notifications. - &#x60;pending&#x60;: Indicates that the webhook endpoint is pending, and will not receive notifications. If a webhook endpoint fails to receive notifications frequently, it changes to pending.
 */
@JsonAdapter(WebhookEndpointStatus.Adapter.class)
public enum WebhookEndpointStatus {
  
  ACTIVE("active"),
  
  DISABLED("disabled"),
  
  PENDING("pending");

  private String value;

  WebhookEndpointStatus(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static WebhookEndpointStatus fromValue(String value) {
    for (WebhookEndpointStatus b : WebhookEndpointStatus.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<WebhookEndpointStatus> {
    @Override
    public void write(final JsonWriter jsonWriter, final WebhookEndpointStatus enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public WebhookEndpointStatus read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return WebhookEndpointStatus.fromValue(value);
    }
  }
}

