/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.model.EventType;
import com.ycloud.client.model.WebhookEndpointStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * WebhookEndpointUpdateRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class WebhookEndpointUpdateRequest {
  public static final String SERIALIZED_NAME_URL = "url";
  /**
   * The URL of the webhook endpoint.
  **/
  @SerializedName(SERIALIZED_NAME_URL)
  private String url;

  public static final String SERIALIZED_NAME_ENABLED_EVENTS = "enabledEvents";
  /**
   * The list of events to enable for this endpoint.
  **/
  @SerializedName(SERIALIZED_NAME_ENABLED_EVENTS)
  private List<EventType> enabledEvents = null;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  /**
   * An optional description of what the webhook is used for.
  **/
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_STATUS = "status";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_STATUS)
  private WebhookEndpointStatus status;

  public WebhookEndpointUpdateRequest() { 
  }

  public WebhookEndpointUpdateRequest url(String url) {
    
    this.url = url;
    return this;
  }

   /**
   * The URL of the webhook endpoint.
   * @return url
  **/
  @javax.annotation.Nullable

  public String getUrl() {
    return url;
  }


  /**
   * The URL of the webhook endpoint.
   **/
  @ApiModelProperty(example = "https://httpbin.org/anything?tag=api", value = "The URL of the webhook endpoint.")
  public void setUrl(String url) {
    this.url = url;
  }


  public WebhookEndpointUpdateRequest enabledEvents(List<EventType> enabledEvents) {
    
    this.enabledEvents = enabledEvents;
    return this;
  }

  public WebhookEndpointUpdateRequest addEnabledEventsItem(EventType enabledEventsItem) {
    if (this.enabledEvents == null) {
      this.enabledEvents = new ArrayList<>();
    }
    this.enabledEvents.add(enabledEventsItem);
    return this;
  }

   /**
   * The list of events to enable for this endpoint.
   * @return enabledEvents
  **/
  @javax.annotation.Nullable

  public List<EventType> getEnabledEvents() {
    return enabledEvents;
  }


  /**
   * The list of events to enable for this endpoint.
   **/
  @ApiModelProperty(value = "The list of events to enable for this endpoint.")
  public void setEnabledEvents(List<EventType> enabledEvents) {
    this.enabledEvents = enabledEvents;
  }


  public WebhookEndpointUpdateRequest description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * An optional description of what the webhook is used for.
   * @return description
  **/
  @javax.annotation.Nullable

  public String getDescription() {
    return description;
  }


  /**
   * An optional description of what the webhook is used for.
   **/
  @ApiModelProperty(example = "My first webhook endpoint.", value = "An optional description of what the webhook is used for.")
  public void setDescription(String description) {
    this.description = description;
  }


  public WebhookEndpointUpdateRequest status(WebhookEndpointStatus status) {
    
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nullable

  public WebhookEndpointStatus getStatus() {
    return status;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setStatus(WebhookEndpointStatus status) {
    this.status = status;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public WebhookEndpointUpdateRequest putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WebhookEndpointUpdateRequest webhookEndpointUpdateRequest = (WebhookEndpointUpdateRequest) o;
    return Objects.equals(this.url, webhookEndpointUpdateRequest.url) &&
        Objects.equals(this.enabledEvents, webhookEndpointUpdateRequest.enabledEvents) &&
        Objects.equals(this.description, webhookEndpointUpdateRequest.description) &&
        Objects.equals(this.status, webhookEndpointUpdateRequest.status)&&
        Objects.equals(this.additionalProperties, webhookEndpointUpdateRequest.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(url, enabledEvents, description, status, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WebhookEndpointUpdateRequest {\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    enabledEvents: ").append(toIndentedString(enabledEvents)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("url");
    openapiFields.add("enabledEvents");
    openapiFields.add("description");
    openapiFields.add("status");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to WebhookEndpointUpdateRequest
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (WebhookEndpointUpdateRequest.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in WebhookEndpointUpdateRequest is not found in the empty JSON string", WebhookEndpointUpdateRequest.openapiRequiredFields.toString()));
        }
      }
      if (jsonObj.get("url") != null && !jsonObj.get("url").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get("url").toString()));
      }
      // ensure the json data is an array
      if (jsonObj.get("enabledEvents") != null && !jsonObj.get("enabledEvents").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `enabledEvents` to be an array in the JSON string but got `%s`", jsonObj.get("enabledEvents").toString()));
      }
      if (jsonObj.get("description") != null && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!WebhookEndpointUpdateRequest.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'WebhookEndpointUpdateRequest' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<WebhookEndpointUpdateRequest> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(WebhookEndpointUpdateRequest.class));

       return (TypeAdapter<T>) new TypeAdapter<WebhookEndpointUpdateRequest>() {
           @Override
           public void write(JsonWriter out, WebhookEndpointUpdateRequest value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public WebhookEndpointUpdateRequest read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             WebhookEndpointUpdateRequest instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of WebhookEndpointUpdateRequest given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of WebhookEndpointUpdateRequest
  * @throws IOException if the JSON string is invalid with respect to WebhookEndpointUpdateRequest
  */
  public static WebhookEndpointUpdateRequest fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, WebhookEndpointUpdateRequest.class);
  }

 /**
  * Convert an instance of WebhookEndpointUpdateRequest to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

