/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * The original error object returned by WhatsApp. See [Handling Errors](https://developers.facebook.com/docs/graph-api/guides/error-handling), [Cloud API Error Codes](https://developers.facebook.com/docs/whatsapp/cloud-api/support/error-codes).
 */
@ApiModel(description = "The original error object returned by WhatsApp. See [Handling Errors](https://developers.facebook.com/docs/graph-api/guides/error-handling), [Cloud API Error Codes](https://developers.facebook.com/docs/whatsapp/cloud-api/support/error-codes).")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class WhatsappApiError {
  public static final String SERIALIZED_NAME_MESSAGE = "message";
  /**
   * A human-readable description of the error.
  **/
  @SerializedName(SERIALIZED_NAME_MESSAGE)
  private String message;

  public static final String SERIALIZED_NAME_CODE = "code";
  /**
   * An error code.
  **/
  @SerializedName(SERIALIZED_NAME_CODE)
  private String code;

  public static final String SERIALIZED_NAME_TYPE = "type";
  /**
   * Error type.
  **/
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public static final String SERIALIZED_NAME_ERROR_SUBCODE = "error_subcode";
  /**
   * Additional code about the error.
  **/
  @SerializedName(SERIALIZED_NAME_ERROR_SUBCODE)
  private String errorSubcode;

  public static final String SERIALIZED_NAME_ERROR_USER_MSG = "error_user_msg";
  /**
   * The message to display to the user. The language of the message is based on the locale of the API request.
  **/
  @SerializedName(SERIALIZED_NAME_ERROR_USER_MSG)
  private String errorUserMsg;

  public static final String SERIALIZED_NAME_ERROR_USER_TITLE = "error_user_title";
  /**
   * The title of the dialog, if shown. The language of the message is based on the locale of the API request.
  **/
  @SerializedName(SERIALIZED_NAME_ERROR_USER_TITLE)
  private String errorUserTitle;

  public static final String SERIALIZED_NAME_FBTRACE_ID = "fbtrace_id";
  /**
   * Internal support identifier. When reporting a bug related to a Graph API call, include the fbtrace_id to help us find log data for debugging.
  **/
  @SerializedName(SERIALIZED_NAME_FBTRACE_ID)
  private String fbtraceId;

  public static final String SERIALIZED_NAME_ERROR_DATA = "error_data";
  /**
   * Additional data about the error. A string or map. - For template APIs, this field is a string describing the reason for the error.   - For message APIs, this field is a map with property &#x60;details&#x60; describing the reason for the error.
  **/
  @SerializedName(SERIALIZED_NAME_ERROR_DATA)
  private Object errorData;

  public WhatsappApiError() { 
  }

  public WhatsappApiError message(String message) {
    
    this.message = message;
    return this;
  }

   /**
   * A human-readable description of the error.
   * @return message
  **/
  @javax.annotation.Nonnull

  public String getMessage() {
    return message;
  }


  /**
   * A human-readable description of the error.
   **/
  @ApiModelProperty(example = "HSM Template creation failed", required = true, value = "A human-readable description of the error.")
  public void setMessage(String message) {
    this.message = message;
  }


  public WhatsappApiError code(String code) {
    
    this.code = code;
    return this;
  }

   /**
   * An error code.
   * @return code
  **/
  @javax.annotation.Nonnull

  public String getCode() {
    return code;
  }


  /**
   * An error code.
   **/
  @ApiModelProperty(example = "200002", required = true, value = "An error code.")
  public void setCode(String code) {
    this.code = code;
  }


  public WhatsappApiError type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Error type.
   * @return type
  **/
  @javax.annotation.Nullable

  public String getType() {
    return type;
  }


  /**
   * Error type.
   **/
  @ApiModelProperty(example = "OAuthException", value = "Error type.")
  public void setType(String type) {
    this.type = type;
  }


  public WhatsappApiError errorSubcode(String errorSubcode) {
    
    this.errorSubcode = errorSubcode;
    return this;
  }

   /**
   * Additional code about the error.
   * @return errorSubcode
  **/
  @javax.annotation.Nullable

  public String getErrorSubcode() {
    return errorSubcode;
  }


  /**
   * Additional code about the error.
   **/
  @ApiModelProperty(example = "2388109", value = "Additional code about the error.")
  public void setErrorSubcode(String errorSubcode) {
    this.errorSubcode = errorSubcode;
  }


  public WhatsappApiError errorUserMsg(String errorUserMsg) {
    
    this.errorUserMsg = errorUserMsg;
    return this;
  }

   /**
   * The message to display to the user. The language of the message is based on the locale of the API request.
   * @return errorUserMsg
  **/
  @javax.annotation.Nullable

  public String getErrorUserMsg() {
    return errorUserMsg;
  }


  /**
   * The message to display to the user. The language of the message is based on the locale of the API request.
   **/
  @ApiModelProperty(example = "This message template cannot be created.", value = "The message to display to the user. The language of the message is based on the locale of the API request.")
  public void setErrorUserMsg(String errorUserMsg) {
    this.errorUserMsg = errorUserMsg;
  }


  public WhatsappApiError errorUserTitle(String errorUserTitle) {
    
    this.errorUserTitle = errorUserTitle;
    return this;
  }

   /**
   * The title of the dialog, if shown. The language of the message is based on the locale of the API request.
   * @return errorUserTitle
  **/
  @javax.annotation.Nullable

  public String getErrorUserTitle() {
    return errorUserTitle;
  }


  /**
   * The title of the dialog, if shown. The language of the message is based on the locale of the API request.
   **/
  @ApiModelProperty(example = "Message Cannot Be Submitted", value = "The title of the dialog, if shown. The language of the message is based on the locale of the API request.")
  public void setErrorUserTitle(String errorUserTitle) {
    this.errorUserTitle = errorUserTitle;
  }


  public WhatsappApiError fbtraceId(String fbtraceId) {
    
    this.fbtraceId = fbtraceId;
    return this;
  }

   /**
   * Internal support identifier. When reporting a bug related to a Graph API call, include the fbtrace_id to help us find log data for debugging.
   * @return fbtraceId
  **/
  @javax.annotation.Nullable

  public String getFbtraceId() {
    return fbtraceId;
  }


  /**
   * Internal support identifier. When reporting a bug related to a Graph API call, include the fbtrace_id to help us find log data for debugging.
   **/
  @ApiModelProperty(example = "AVGjJ7ia2zJkrHG", value = "Internal support identifier. When reporting a bug related to a Graph API call, include the fbtrace_id to help us find log data for debugging.")
  public void setFbtraceId(String fbtraceId) {
    this.fbtraceId = fbtraceId;
  }


  public WhatsappApiError errorData(Object errorData) {
    
    this.errorData = errorData;
    return this;
  }

   /**
   * Additional data about the error. A string or map. - For template APIs, this field is a string describing the reason for the error.   - For message APIs, this field is a map with property &#x60;details&#x60; describing the reason for the error.
   * @return errorData
  **/
  @javax.annotation.Nullable

  public Object getErrorData() {
    return errorData;
  }


  /**
   * Additional data about the error. A string or map. - For template APIs, this field is a string describing the reason for the error.   - For message APIs, this field is a map with property &#x60;details&#x60; describing the reason for the error.
   **/
  @ApiModelProperty(value = "Additional data about the error. A string or map. - For template APIs, this field is a string describing the reason for the error.   - For message APIs, this field is a map with property `details` describing the reason for the error.")
  public void setErrorData(Object errorData) {
    this.errorData = errorData;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public WhatsappApiError putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsappApiError whatsappApiError = (WhatsappApiError) o;
    return Objects.equals(this.message, whatsappApiError.message) &&
        Objects.equals(this.code, whatsappApiError.code) &&
        Objects.equals(this.type, whatsappApiError.type) &&
        Objects.equals(this.errorSubcode, whatsappApiError.errorSubcode) &&
        Objects.equals(this.errorUserMsg, whatsappApiError.errorUserMsg) &&
        Objects.equals(this.errorUserTitle, whatsappApiError.errorUserTitle) &&
        Objects.equals(this.fbtraceId, whatsappApiError.fbtraceId) &&
        Objects.equals(this.errorData, whatsappApiError.errorData)&&
        Objects.equals(this.additionalProperties, whatsappApiError.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(message, code, type, errorSubcode, errorUserMsg, errorUserTitle, fbtraceId, errorData, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsappApiError {\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    errorSubcode: ").append(toIndentedString(errorSubcode)).append("\n");
    sb.append("    errorUserMsg: ").append(toIndentedString(errorUserMsg)).append("\n");
    sb.append("    errorUserTitle: ").append(toIndentedString(errorUserTitle)).append("\n");
    sb.append("    fbtraceId: ").append(toIndentedString(fbtraceId)).append("\n");
    sb.append("    errorData: ").append(toIndentedString(errorData)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("message");
    openapiFields.add("code");
    openapiFields.add("type");
    openapiFields.add("error_subcode");
    openapiFields.add("error_user_msg");
    openapiFields.add("error_user_title");
    openapiFields.add("fbtrace_id");
    openapiFields.add("error_data");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("message");
    openapiRequiredFields.add("code");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to WhatsappApiError
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (WhatsappApiError.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappApiError is not found in the empty JSON string", WhatsappApiError.openapiRequiredFields.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : WhatsappApiError.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (jsonObj.get("message") != null && !jsonObj.get("message").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `message` to be a primitive type in the JSON string but got `%s`", jsonObj.get("message").toString()));
      }
      if (jsonObj.get("code") != null && !jsonObj.get("code").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `code` to be a primitive type in the JSON string but got `%s`", jsonObj.get("code").toString()));
      }
      if (jsonObj.get("type") != null && !jsonObj.get("type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
      }
      if (jsonObj.get("error_subcode") != null && !jsonObj.get("error_subcode").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `error_subcode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("error_subcode").toString()));
      }
      if (jsonObj.get("error_user_msg") != null && !jsonObj.get("error_user_msg").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `error_user_msg` to be a primitive type in the JSON string but got `%s`", jsonObj.get("error_user_msg").toString()));
      }
      if (jsonObj.get("error_user_title") != null && !jsonObj.get("error_user_title").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `error_user_title` to be a primitive type in the JSON string but got `%s`", jsonObj.get("error_user_title").toString()));
      }
      if (jsonObj.get("fbtrace_id") != null && !jsonObj.get("fbtrace_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `fbtrace_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("fbtrace_id").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!WhatsappApiError.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'WhatsappApiError' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<WhatsappApiError> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(WhatsappApiError.class));

       return (TypeAdapter<T>) new TypeAdapter<WhatsappApiError>() {
           @Override
           public void write(JsonWriter out, WhatsappApiError value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public WhatsappApiError read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             WhatsappApiError instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of WhatsappApiError given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of WhatsappApiError
  * @throws IOException if the JSON string is invalid with respect to WhatsappApiError
  */
  public static WhatsappApiError fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, WhatsappApiError.class);
  }

 /**
  * Convert an instance of WhatsappApiError to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

