/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import io.swagger.annotations.ApiModel;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Indicates the update event type of the WABA when a notification is sent to you to report a [policy violation](https://developers.facebook.com/docs/whatsapp/overview/policy-enforcement), a WABA has been banned and more. - &#x60;DISABLED_UPDATE&#x60;: WhatsApp Business Account Banned. - &#x60;ACCOUNT_RESTRICTION&#x60;: WhatsApp Business Account Restricted Due To Policy Violations. - &#x60;ACCOUNT_VIOLATION&#x60;: WhatsApp Business Account Violates Policy. - &#x60;AUTH_INTL_PRICE_ELIGIBILITY_UPDATE&#x60;: WhatsApp Business Account is eligible for the [authentication-international rate](https://developers.facebook.com/docs/whatsapp/pricing/authentication-international-rates). - &#x60;BUSINESS_PRIMARY_LOCATION_COUNTRY_UPDATE&#x60;: Business&#39;s [primary business location](https://developers.facebook.com/docs/whatsapp/pricing/authentication-international-rates#primary-business-location) is set.
 */
@JsonAdapter(WhatsappBusinessAccountUpdateEventEnum.Adapter.class)
public enum WhatsappBusinessAccountUpdateEventEnum {
  
  DISABLED_UPDATE("DISABLED_UPDATE"),
  
  ACCOUNT_RESTRICTION("ACCOUNT_RESTRICTION"),
  
  ACCOUNT_VIOLATION("ACCOUNT_VIOLATION"),
  
  AUTH_INTL_PRICE_ELIGIBILITY_UPDATE("AUTH_INTL_PRICE_ELIGIBILITY_UPDATE"),
  
  BUSINESS_PRIMARY_LOCATION_COUNTRY_UPDATE("BUSINESS_PRIMARY_LOCATION_COUNTRY_UPDATE");

  private String value;

  WhatsappBusinessAccountUpdateEventEnum(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static WhatsappBusinessAccountUpdateEventEnum fromValue(String value) {
    for (WhatsappBusinessAccountUpdateEventEnum b : WhatsappBusinessAccountUpdateEventEnum.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<WhatsappBusinessAccountUpdateEventEnum> {
    @Override
    public void write(final JsonWriter jsonWriter, final WhatsappBusinessAccountUpdateEventEnum enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public WhatsappBusinessAccountUpdateEventEnum read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return WhatsappBusinessAccountUpdateEventEnum.fromValue(value);
    }
  }
}

