/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import io.swagger.annotations.ApiModel;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Indicates [conversation category](https://developers.facebook.com/docs/whatsapp/pricing#conversation-categories). This can also be referred to as a conversation entry point. - &#x60;referral_conversion&#x60;: Indicates a [free entry point conversation](https://developers.facebook.com/docs/whatsapp/pricing#free-entry-point-conversations). - &#x60;authentication&#x60;: Indicates the conversation was opened by a business sending template categorized as &#x60;AUTHENTICATION&#x60; to the customer. This applies any time it has been more than 24 hours since the last customer message. - &#x60;marketing&#x60;: Indicates the conversation was opened by a business sending template categorized as &#x60;MARKETING&#x60; to the customer. This applies any time it has been more than 24 hours since the last customer message. - &#x60;utility&#x60;: Indicates the conversation was opened by a business sending template categorized as &#x60;UTILITY&#x60; to the customer. This applies any time it has been more than 24 hours since the last customer message. - &#x60;service&#x60;: Indicates that the conversation opened by a business replying to a customer within a [customer service window](https://developers.facebook.com/docs/whatsapp/pricing#customer-service-windows).
 */
@JsonAdapter(WhatsappConversationOriginType.Adapter.class)
public enum WhatsappConversationOriginType {
  
  REFERRAL_CONVERSION("referral_conversion"),
  
  AUTHENTICATION("authentication"),
  
  MARKETING("marketing"),
  
  UTILITY("utility"),
  
  SERVICE("service");

  private String value;

  WhatsappConversationOriginType(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static WhatsappConversationOriginType fromValue(String value) {
    for (WhatsappConversationOriginType b : WhatsappConversationOriginType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<WhatsappConversationOriginType> {
    @Override
    public void write(final JsonWriter jsonWriter, final WhatsappConversationOriginType enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public WhatsappConversationOriginType read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return WhatsappConversationOriginType.fromValue(value);
    }
  }
}

