/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import io.swagger.annotations.ApiModel;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Conversation type. There is a charge when the first business message of this conversation is delivered, initiating the 24-hour conversation session. As such, the conversation type can be &#x60;null&#x60; before the first message is delivered. - &#x60;FREE_ENTRY&#x60;: Conversations originating from a [free entry point](https://developers.facebook.com/docs/whatsapp/pricing#free-entry-point-conversations). - &#x60;FREE_TIER&#x60;: Conversations within the monthly [free tier](https://developers.facebook.com/docs/whatsapp/pricing#free-tier-conversations). - &#x60;REGULAR&#x60;: Any conversations that did not originate from a [free entry point](https://developers.facebook.com/docs/whatsapp/pricing#free-entry-point-conversations) or are above the monthly [free tier](https://developers.facebook.com/docs/whatsapp/pricing#free-tier-conversations) allotment.
 */
@JsonAdapter(WhatsappConversationType.Adapter.class)
public enum WhatsappConversationType {
  
  FREE_ENTRY("FREE_ENTRY"),
  
  FREE_TIER("FREE_TIER"),
  
  REGULAR("REGULAR");

  private String value;

  WhatsappConversationType(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static WhatsappConversationType fromValue(String value) {
    for (WhatsappConversationType b : WhatsappConversationType.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<WhatsappConversationType> {
    @Override
    public void write(final JsonWriter jsonWriter, final WhatsappConversationType enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public WhatsappConversationType read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return WhatsappConversationType.fromValue(value);
    }
  }
}

