/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.model.WhatsappInboundMessageButton;
import com.ycloud.client.model.WhatsappInboundMessageContext;
import com.ycloud.client.model.WhatsappInboundMessageError;
import com.ycloud.client.model.WhatsappInboundMessageInteractive;
import com.ycloud.client.model.WhatsappInboundMessageLocation;
import com.ycloud.client.model.WhatsappInboundMessageMedia;
import com.ycloud.client.model.WhatsappInboundMessageOrder;
import com.ycloud.client.model.WhatsappInboundMessageReferral;
import com.ycloud.client.model.WhatsappInboundMessageSystem;
import com.ycloud.client.model.WhatsappInboundMessageText;
import com.ycloud.client.model.WhatsappInboundMessageType;
import com.ycloud.client.model.WhatsappMessageContact;
import com.ycloud.client.model.WhatsappMessageReaction;
import com.ycloud.client.model.WhatsappProfile;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * WhatsApp inbound message object.
 */
@ApiModel(description = "WhatsApp inbound message object.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class WhatsappInboundMessage {
  public static final String SERIALIZED_NAME_ID = "id";
  /**
   * Unique ID for the object.
  **/
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_WAMID = "wamid";
  /**
   * The original message ID on WhatsApp&#39;s platform.
  **/
  @SerializedName(SERIALIZED_NAME_WAMID)
  private String wamid;

  public static final String SERIALIZED_NAME_WABA_ID = "wabaId";
  /**
   * WhatsApp Business Account ID.
  **/
  @SerializedName(SERIALIZED_NAME_WABA_ID)
  private String wabaId;

  public static final String SERIALIZED_NAME_FROM = "from";
  /**
   * The customer&#39;s phone number who sent the message to the business, formatted in [E.164](https://en.wikipedia.org/wiki/E.164) format.
  **/
  @SerializedName(SERIALIZED_NAME_FROM)
  private String from;

  public static final String SERIALIZED_NAME_CUSTOMER_PROFILE = "customerProfile";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_CUSTOMER_PROFILE)
  private WhatsappProfile customerProfile;

  public static final String SERIALIZED_NAME_TO = "to";
  /**
   * The recipient&#39;s phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.
  **/
  @SerializedName(SERIALIZED_NAME_TO)
  private String to;

  public static final String SERIALIZED_NAME_SEND_TIME = "sendTime";
  /**
   * The time at which this message is sent, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_SEND_TIME)
  private Date sendTime;

  public static final String SERIALIZED_NAME_TYPE = "type";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_TYPE)
  private WhatsappInboundMessageType type;

  public static final String SERIALIZED_NAME_TEXT = "text";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_TEXT)
  private WhatsappInboundMessageText text;

  public static final String SERIALIZED_NAME_IMAGE = "image";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_IMAGE)
  private WhatsappInboundMessageMedia image;

  public static final String SERIALIZED_NAME_VIDEO = "video";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_VIDEO)
  private WhatsappInboundMessageMedia video;

  public static final String SERIALIZED_NAME_AUDIO = "audio";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_AUDIO)
  private WhatsappInboundMessageMedia audio;

  public static final String SERIALIZED_NAME_DOCUMENT = "document";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_DOCUMENT)
  private WhatsappInboundMessageMedia document;

  public static final String SERIALIZED_NAME_STICKER = "sticker";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_STICKER)
  private WhatsappInboundMessageMedia sticker;

  public static final String SERIALIZED_NAME_INTERACTIVE = "interactive";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_INTERACTIVE)
  private WhatsappInboundMessageInteractive interactive;

  public static final String SERIALIZED_NAME_LOCATION = "location";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_LOCATION)
  private WhatsappInboundMessageLocation location;

  public static final String SERIALIZED_NAME_BUTTON = "button";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_BUTTON)
  private WhatsappInboundMessageButton button;

  public static final String SERIALIZED_NAME_CONTACTS = "contacts";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_CONTACTS)
  private List<WhatsappMessageContact> contacts = null;

  public static final String SERIALIZED_NAME_REACTION = "reaction";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_REACTION)
  private WhatsappMessageReaction reaction;

  public static final String SERIALIZED_NAME_ORDER = "order";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_ORDER)
  private WhatsappInboundMessageOrder order;

  public static final String SERIALIZED_NAME_SYSTEM = "system";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_SYSTEM)
  private WhatsappInboundMessageSystem system;

  public static final String SERIALIZED_NAME_ERRORS = "errors";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_ERRORS)
  private List<WhatsappInboundMessageError> errors = null;

  public static final String SERIALIZED_NAME_CONTEXT = "context";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_CONTEXT)
  private WhatsappInboundMessageContext context;

  public static final String SERIALIZED_NAME_REFERRAL = "referral";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_REFERRAL)
  private WhatsappInboundMessageReferral referral;

  public WhatsappInboundMessage() { 
  }

  public WhatsappInboundMessage id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Unique ID for the object.
   * @return id
  **/
  @javax.annotation.Nonnull

  public String getId() {
    return id;
  }


  /**
   * Unique ID for the object.
   **/
  @ApiModelProperty(required = true, value = "Unique ID for the object.")
  public void setId(String id) {
    this.id = id;
  }


  public WhatsappInboundMessage wamid(String wamid) {
    
    this.wamid = wamid;
    return this;
  }

   /**
   * The original message ID on WhatsApp&#39;s platform.
   * @return wamid
  **/
  @javax.annotation.Nullable

  public String getWamid() {
    return wamid;
  }


  /**
   * The original message ID on WhatsApp&#39;s platform.
   **/
  @ApiModelProperty(example = "wamid.BgNODYxN...", value = "The original message ID on WhatsApp's platform.")
  public void setWamid(String wamid) {
    this.wamid = wamid;
  }


  public WhatsappInboundMessage wabaId(String wabaId) {
    
    this.wabaId = wabaId;
    return this;
  }

   /**
   * WhatsApp Business Account ID.
   * @return wabaId
  **/
  @javax.annotation.Nullable

  public String getWabaId() {
    return wabaId;
  }


  /**
   * WhatsApp Business Account ID.
   **/
  @ApiModelProperty(example = "whatsapp-business-account-id", value = "WhatsApp Business Account ID.")
  public void setWabaId(String wabaId) {
    this.wabaId = wabaId;
  }


  public WhatsappInboundMessage from(String from) {
    
    this.from = from;
    return this;
  }

   /**
   * The customer&#39;s phone number who sent the message to the business, formatted in [E.164](https://en.wikipedia.org/wiki/E.164) format.
   * @return from
  **/
  @javax.annotation.Nullable

  public String getFrom() {
    return from;
  }


  /**
   * The customer&#39;s phone number who sent the message to the business, formatted in [E.164](https://en.wikipedia.org/wiki/E.164) format.
   **/
  @ApiModelProperty(example = "+16315551111", value = "The customer's phone number who sent the message to the business, formatted in [E.164](https://en.wikipedia.org/wiki/E.164) format.")
  public void setFrom(String from) {
    this.from = from;
  }


  public WhatsappInboundMessage customerProfile(WhatsappProfile customerProfile) {
    
    this.customerProfile = customerProfile;
    return this;
  }

   /**
   * Get customerProfile
   * @return customerProfile
  **/
  @javax.annotation.Nullable

  public WhatsappProfile getCustomerProfile() {
    return customerProfile;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setCustomerProfile(WhatsappProfile customerProfile) {
    this.customerProfile = customerProfile;
  }


  public WhatsappInboundMessage to(String to) {
    
    this.to = to;
    return this;
  }

   /**
   * The recipient&#39;s phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.
   * @return to
  **/
  @javax.annotation.Nullable

  public String getTo() {
    return to;
  }


  /**
   * The recipient&#39;s phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.
   **/
  @ApiModelProperty(example = "+16315551111", value = "The recipient's phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.")
  public void setTo(String to) {
    this.to = to;
  }


  public WhatsappInboundMessage sendTime(Date sendTime) {
    
    this.sendTime = sendTime;
    return this;
  }

   /**
   * The time at which this message is sent, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
   * @return sendTime
  **/
  @javax.annotation.Nullable

  public Date getSendTime() {
    return sendTime;
  }


  /**
   * The time at which this message is sent, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
   **/
  @ApiModelProperty(example = "2022-06-01T12:00Z", value = "The time at which this message is sent, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., `2022-06-01T12:00:00.000Z`.")
  public void setSendTime(Date sendTime) {
    this.sendTime = sendTime;
  }


  public WhatsappInboundMessage type(WhatsappInboundMessageType type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nullable

  public WhatsappInboundMessageType getType() {
    return type;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setType(WhatsappInboundMessageType type) {
    this.type = type;
  }


  public WhatsappInboundMessage text(WhatsappInboundMessageText text) {
    
    this.text = text;
    return this;
  }

   /**
   * Get text
   * @return text
  **/
  @javax.annotation.Nullable

  public WhatsappInboundMessageText getText() {
    return text;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setText(WhatsappInboundMessageText text) {
    this.text = text;
  }


  public WhatsappInboundMessage image(WhatsappInboundMessageMedia image) {
    
    this.image = image;
    return this;
  }

   /**
   * Get image
   * @return image
  **/
  @javax.annotation.Nullable

  public WhatsappInboundMessageMedia getImage() {
    return image;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setImage(WhatsappInboundMessageMedia image) {
    this.image = image;
  }


  public WhatsappInboundMessage video(WhatsappInboundMessageMedia video) {
    
    this.video = video;
    return this;
  }

   /**
   * Get video
   * @return video
  **/
  @javax.annotation.Nullable

  public WhatsappInboundMessageMedia getVideo() {
    return video;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setVideo(WhatsappInboundMessageMedia video) {
    this.video = video;
  }


  public WhatsappInboundMessage audio(WhatsappInboundMessageMedia audio) {
    
    this.audio = audio;
    return this;
  }

   /**
   * Get audio
   * @return audio
  **/
  @javax.annotation.Nullable

  public WhatsappInboundMessageMedia getAudio() {
    return audio;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setAudio(WhatsappInboundMessageMedia audio) {
    this.audio = audio;
  }


  public WhatsappInboundMessage document(WhatsappInboundMessageMedia document) {
    
    this.document = document;
    return this;
  }

   /**
   * Get document
   * @return document
  **/
  @javax.annotation.Nullable

  public WhatsappInboundMessageMedia getDocument() {
    return document;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setDocument(WhatsappInboundMessageMedia document) {
    this.document = document;
  }


  public WhatsappInboundMessage sticker(WhatsappInboundMessageMedia sticker) {
    
    this.sticker = sticker;
    return this;
  }

   /**
   * Get sticker
   * @return sticker
  **/
  @javax.annotation.Nullable

  public WhatsappInboundMessageMedia getSticker() {
    return sticker;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setSticker(WhatsappInboundMessageMedia sticker) {
    this.sticker = sticker;
  }


  public WhatsappInboundMessage interactive(WhatsappInboundMessageInteractive interactive) {
    
    this.interactive = interactive;
    return this;
  }

   /**
   * Get interactive
   * @return interactive
  **/
  @javax.annotation.Nullable

  public WhatsappInboundMessageInteractive getInteractive() {
    return interactive;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setInteractive(WhatsappInboundMessageInteractive interactive) {
    this.interactive = interactive;
  }


  public WhatsappInboundMessage location(WhatsappInboundMessageLocation location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @javax.annotation.Nullable

  public WhatsappInboundMessageLocation getLocation() {
    return location;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setLocation(WhatsappInboundMessageLocation location) {
    this.location = location;
  }


  public WhatsappInboundMessage button(WhatsappInboundMessageButton button) {
    
    this.button = button;
    return this;
  }

   /**
   * Get button
   * @return button
  **/
  @javax.annotation.Nullable

  public WhatsappInboundMessageButton getButton() {
    return button;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setButton(WhatsappInboundMessageButton button) {
    this.button = button;
  }


  public WhatsappInboundMessage contacts(List<WhatsappMessageContact> contacts) {
    
    this.contacts = contacts;
    return this;
  }

  public WhatsappInboundMessage addContactsItem(WhatsappMessageContact contactsItem) {
    if (this.contacts == null) {
      this.contacts = new ArrayList<>();
    }
    this.contacts.add(contactsItem);
    return this;
  }

   /**
   * Get contacts
   * @return contacts
  **/
  @javax.annotation.Nullable

  public List<WhatsappMessageContact> getContacts() {
    return contacts;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setContacts(List<WhatsappMessageContact> contacts) {
    this.contacts = contacts;
  }


  public WhatsappInboundMessage reaction(WhatsappMessageReaction reaction) {
    
    this.reaction = reaction;
    return this;
  }

   /**
   * Get reaction
   * @return reaction
  **/
  @javax.annotation.Nullable

  public WhatsappMessageReaction getReaction() {
    return reaction;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setReaction(WhatsappMessageReaction reaction) {
    this.reaction = reaction;
  }


  public WhatsappInboundMessage order(WhatsappInboundMessageOrder order) {
    
    this.order = order;
    return this;
  }

   /**
   * Get order
   * @return order
  **/
  @javax.annotation.Nullable

  public WhatsappInboundMessageOrder getOrder() {
    return order;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setOrder(WhatsappInboundMessageOrder order) {
    this.order = order;
  }


  public WhatsappInboundMessage system(WhatsappInboundMessageSystem system) {
    
    this.system = system;
    return this;
  }

   /**
   * Get system
   * @return system
  **/
  @javax.annotation.Nullable

  public WhatsappInboundMessageSystem getSystem() {
    return system;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setSystem(WhatsappInboundMessageSystem system) {
    this.system = system;
  }


  public WhatsappInboundMessage errors(List<WhatsappInboundMessageError> errors) {
    
    this.errors = errors;
    return this;
  }

  public WhatsappInboundMessage addErrorsItem(WhatsappInboundMessageError errorsItem) {
    if (this.errors == null) {
      this.errors = new ArrayList<>();
    }
    this.errors.add(errorsItem);
    return this;
  }

   /**
   * Get errors
   * @return errors
  **/
  @javax.annotation.Nullable

  public List<WhatsappInboundMessageError> getErrors() {
    return errors;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setErrors(List<WhatsappInboundMessageError> errors) {
    this.errors = errors;
  }


  public WhatsappInboundMessage context(WhatsappInboundMessageContext context) {
    
    this.context = context;
    return this;
  }

   /**
   * Get context
   * @return context
  **/
  @javax.annotation.Nullable

  public WhatsappInboundMessageContext getContext() {
    return context;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setContext(WhatsappInboundMessageContext context) {
    this.context = context;
  }


  public WhatsappInboundMessage referral(WhatsappInboundMessageReferral referral) {
    
    this.referral = referral;
    return this;
  }

   /**
   * Get referral
   * @return referral
  **/
  @javax.annotation.Nullable

  public WhatsappInboundMessageReferral getReferral() {
    return referral;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setReferral(WhatsappInboundMessageReferral referral) {
    this.referral = referral;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public WhatsappInboundMessage putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsappInboundMessage whatsappInboundMessage = (WhatsappInboundMessage) o;
    return Objects.equals(this.id, whatsappInboundMessage.id) &&
        Objects.equals(this.wamid, whatsappInboundMessage.wamid) &&
        Objects.equals(this.wabaId, whatsappInboundMessage.wabaId) &&
        Objects.equals(this.from, whatsappInboundMessage.from) &&
        Objects.equals(this.customerProfile, whatsappInboundMessage.customerProfile) &&
        Objects.equals(this.to, whatsappInboundMessage.to) &&
        Objects.equals(this.sendTime, whatsappInboundMessage.sendTime) &&
        Objects.equals(this.type, whatsappInboundMessage.type) &&
        Objects.equals(this.text, whatsappInboundMessage.text) &&
        Objects.equals(this.image, whatsappInboundMessage.image) &&
        Objects.equals(this.video, whatsappInboundMessage.video) &&
        Objects.equals(this.audio, whatsappInboundMessage.audio) &&
        Objects.equals(this.document, whatsappInboundMessage.document) &&
        Objects.equals(this.sticker, whatsappInboundMessage.sticker) &&
        Objects.equals(this.interactive, whatsappInboundMessage.interactive) &&
        Objects.equals(this.location, whatsappInboundMessage.location) &&
        Objects.equals(this.button, whatsappInboundMessage.button) &&
        Objects.equals(this.contacts, whatsappInboundMessage.contacts) &&
        Objects.equals(this.reaction, whatsappInboundMessage.reaction) &&
        Objects.equals(this.order, whatsappInboundMessage.order) &&
        Objects.equals(this.system, whatsappInboundMessage.system) &&
        Objects.equals(this.errors, whatsappInboundMessage.errors) &&
        Objects.equals(this.context, whatsappInboundMessage.context) &&
        Objects.equals(this.referral, whatsappInboundMessage.referral)&&
        Objects.equals(this.additionalProperties, whatsappInboundMessage.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, wamid, wabaId, from, customerProfile, to, sendTime, type, text, image, video, audio, document, sticker, interactive, location, button, contacts, reaction, order, system, errors, context, referral, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsappInboundMessage {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    wamid: ").append(toIndentedString(wamid)).append("\n");
    sb.append("    wabaId: ").append(toIndentedString(wabaId)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    customerProfile: ").append(toIndentedString(customerProfile)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("    sendTime: ").append(toIndentedString(sendTime)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    image: ").append(toIndentedString(image)).append("\n");
    sb.append("    video: ").append(toIndentedString(video)).append("\n");
    sb.append("    audio: ").append(toIndentedString(audio)).append("\n");
    sb.append("    document: ").append(toIndentedString(document)).append("\n");
    sb.append("    sticker: ").append(toIndentedString(sticker)).append("\n");
    sb.append("    interactive: ").append(toIndentedString(interactive)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    button: ").append(toIndentedString(button)).append("\n");
    sb.append("    contacts: ").append(toIndentedString(contacts)).append("\n");
    sb.append("    reaction: ").append(toIndentedString(reaction)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("    system: ").append(toIndentedString(system)).append("\n");
    sb.append("    errors: ").append(toIndentedString(errors)).append("\n");
    sb.append("    context: ").append(toIndentedString(context)).append("\n");
    sb.append("    referral: ").append(toIndentedString(referral)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("wamid");
    openapiFields.add("wabaId");
    openapiFields.add("from");
    openapiFields.add("customerProfile");
    openapiFields.add("to");
    openapiFields.add("sendTime");
    openapiFields.add("type");
    openapiFields.add("text");
    openapiFields.add("image");
    openapiFields.add("video");
    openapiFields.add("audio");
    openapiFields.add("document");
    openapiFields.add("sticker");
    openapiFields.add("interactive");
    openapiFields.add("location");
    openapiFields.add("button");
    openapiFields.add("contacts");
    openapiFields.add("reaction");
    openapiFields.add("order");
    openapiFields.add("system");
    openapiFields.add("errors");
    openapiFields.add("context");
    openapiFields.add("referral");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to WhatsappInboundMessage
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (WhatsappInboundMessage.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappInboundMessage is not found in the empty JSON string", WhatsappInboundMessage.openapiRequiredFields.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : WhatsappInboundMessage.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if (jsonObj.get("wamid") != null && !jsonObj.get("wamid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `wamid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("wamid").toString()));
      }
      if (jsonObj.get("wabaId") != null && !jsonObj.get("wabaId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `wabaId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("wabaId").toString()));
      }
      if (jsonObj.get("from") != null && !jsonObj.get("from").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `from` to be a primitive type in the JSON string but got `%s`", jsonObj.get("from").toString()));
      }
      // validate the optional field `customerProfile`
      if (jsonObj.getAsJsonObject("customerProfile") != null) {
        WhatsappProfile.validateJsonObject(jsonObj.getAsJsonObject("customerProfile"));
      }
      if (jsonObj.get("to") != null && !jsonObj.get("to").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `to` to be a primitive type in the JSON string but got `%s`", jsonObj.get("to").toString()));
      }
      // validate the optional field `text`
      if (jsonObj.getAsJsonObject("text") != null) {
        WhatsappInboundMessageText.validateJsonObject(jsonObj.getAsJsonObject("text"));
      }
      // validate the optional field `image`
      if (jsonObj.getAsJsonObject("image") != null) {
        WhatsappInboundMessageMedia.validateJsonObject(jsonObj.getAsJsonObject("image"));
      }
      // validate the optional field `video`
      if (jsonObj.getAsJsonObject("video") != null) {
        WhatsappInboundMessageMedia.validateJsonObject(jsonObj.getAsJsonObject("video"));
      }
      // validate the optional field `audio`
      if (jsonObj.getAsJsonObject("audio") != null) {
        WhatsappInboundMessageMedia.validateJsonObject(jsonObj.getAsJsonObject("audio"));
      }
      // validate the optional field `document`
      if (jsonObj.getAsJsonObject("document") != null) {
        WhatsappInboundMessageMedia.validateJsonObject(jsonObj.getAsJsonObject("document"));
      }
      // validate the optional field `sticker`
      if (jsonObj.getAsJsonObject("sticker") != null) {
        WhatsappInboundMessageMedia.validateJsonObject(jsonObj.getAsJsonObject("sticker"));
      }
      // validate the optional field `interactive`
      if (jsonObj.getAsJsonObject("interactive") != null) {
        WhatsappInboundMessageInteractive.validateJsonObject(jsonObj.getAsJsonObject("interactive"));
      }
      // validate the optional field `location`
      if (jsonObj.getAsJsonObject("location") != null) {
        WhatsappInboundMessageLocation.validateJsonObject(jsonObj.getAsJsonObject("location"));
      }
      // validate the optional field `button`
      if (jsonObj.getAsJsonObject("button") != null) {
        WhatsappInboundMessageButton.validateJsonObject(jsonObj.getAsJsonObject("button"));
      }
      JsonArray jsonArraycontacts = jsonObj.getAsJsonArray("contacts");
      if (jsonArraycontacts != null) {
        // ensure the json data is an array
        if (!jsonObj.get("contacts").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `contacts` to be an array in the JSON string but got `%s`", jsonObj.get("contacts").toString()));
        }

        // validate the optional field `contacts` (array)
        for (int i = 0; i < jsonArraycontacts.size(); i++) {
          WhatsappMessageContact.validateJsonObject(jsonArraycontacts.get(i).getAsJsonObject());
        };
      }
      // validate the optional field `reaction`
      if (jsonObj.getAsJsonObject("reaction") != null) {
        WhatsappMessageReaction.validateJsonObject(jsonObj.getAsJsonObject("reaction"));
      }
      // validate the optional field `order`
      if (jsonObj.getAsJsonObject("order") != null) {
        WhatsappInboundMessageOrder.validateJsonObject(jsonObj.getAsJsonObject("order"));
      }
      // validate the optional field `system`
      if (jsonObj.getAsJsonObject("system") != null) {
        WhatsappInboundMessageSystem.validateJsonObject(jsonObj.getAsJsonObject("system"));
      }
      JsonArray jsonArrayerrors = jsonObj.getAsJsonArray("errors");
      if (jsonArrayerrors != null) {
        // ensure the json data is an array
        if (!jsonObj.get("errors").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `errors` to be an array in the JSON string but got `%s`", jsonObj.get("errors").toString()));
        }

        // validate the optional field `errors` (array)
        for (int i = 0; i < jsonArrayerrors.size(); i++) {
          WhatsappInboundMessageError.validateJsonObject(jsonArrayerrors.get(i).getAsJsonObject());
        };
      }
      // validate the optional field `context`
      if (jsonObj.getAsJsonObject("context") != null) {
        WhatsappInboundMessageContext.validateJsonObject(jsonObj.getAsJsonObject("context"));
      }
      // validate the optional field `referral`
      if (jsonObj.getAsJsonObject("referral") != null) {
        WhatsappInboundMessageReferral.validateJsonObject(jsonObj.getAsJsonObject("referral"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!WhatsappInboundMessage.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'WhatsappInboundMessage' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<WhatsappInboundMessage> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(WhatsappInboundMessage.class));

       return (TypeAdapter<T>) new TypeAdapter<WhatsappInboundMessage>() {
           @Override
           public void write(JsonWriter out, WhatsappInboundMessage value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public WhatsappInboundMessage read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             WhatsappInboundMessage instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of WhatsappInboundMessage given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of WhatsappInboundMessage
  * @throws IOException if the JSON string is invalid with respect to WhatsappInboundMessage
  */
  public static WhatsappInboundMessage fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, WhatsappInboundMessage.class);
  }

 /**
  * Convert an instance of WhatsappInboundMessage to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

