/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.model.WhatsappInboundMessageReferredProduct;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * Message context.
 */
@ApiModel(description = "Message context.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class WhatsappInboundMessageContext {
  public static final String SERIALIZED_NAME_FORWARDED = "forwarded";
  /**
   * **Added to Webhooks if message was forwarded.**  Set to &#x60;true&#x60; if the received message has been forwarded.
  **/
  @SerializedName(SERIALIZED_NAME_FORWARDED)
  private Boolean forwarded;

  public static final String SERIALIZED_NAME_FREQUENTLY_FORWARDED = "frequently_forwarded";
  /**
   * **Added to Webhooks if message has been frequently forwarded.**  Set to &#x60;true&#x60; if the received message has been forwarded more than five times.
  **/
  @SerializedName(SERIALIZED_NAME_FREQUENTLY_FORWARDED)
  private Boolean frequentlyForwarded;

  public static final String SERIALIZED_NAME_FROM = "from";
  /**
   * **Added to Webhooks if message is an inbound reply to a sent message.**  The WhatsApp ID (a phone number without the &#39;+&#39; prefix) of the sender of the sent message.
  **/
  @SerializedName(SERIALIZED_NAME_FROM)
  private String from;

  public static final String SERIALIZED_NAME_ID = "id";
  /**
   * **Optional.**  The &#x60;wamid&#x60; for the sent message for an inbound reply. &#x60;wamid&#x60; is the original message ID on WhatsApp’s platform.
  **/
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_REFERRED_PRODUCT = "referred_product";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_REFERRED_PRODUCT)
  private WhatsappInboundMessageReferredProduct referredProduct;

  public WhatsappInboundMessageContext() { 
  }

  public WhatsappInboundMessageContext forwarded(Boolean forwarded) {
    
    this.forwarded = forwarded;
    return this;
  }

   /**
   * **Added to Webhooks if message was forwarded.**  Set to &#x60;true&#x60; if the received message has been forwarded.
   * @return forwarded
  **/
  @javax.annotation.Nullable

  public Boolean getForwarded() {
    return forwarded;
  }


  /**
   * **Added to Webhooks if message was forwarded.**  Set to &#x60;true&#x60; if the received message has been forwarded.
   **/
  @ApiModelProperty(value = "**Added to Webhooks if message was forwarded.**  Set to `true` if the received message has been forwarded.")
  public void setForwarded(Boolean forwarded) {
    this.forwarded = forwarded;
  }


  public WhatsappInboundMessageContext frequentlyForwarded(Boolean frequentlyForwarded) {
    
    this.frequentlyForwarded = frequentlyForwarded;
    return this;
  }

   /**
   * **Added to Webhooks if message has been frequently forwarded.**  Set to &#x60;true&#x60; if the received message has been forwarded more than five times.
   * @return frequentlyForwarded
  **/
  @javax.annotation.Nullable

  public Boolean getFrequentlyForwarded() {
    return frequentlyForwarded;
  }


  /**
   * **Added to Webhooks if message has been frequently forwarded.**  Set to &#x60;true&#x60; if the received message has been forwarded more than five times.
   **/
  @ApiModelProperty(value = "**Added to Webhooks if message has been frequently forwarded.**  Set to `true` if the received message has been forwarded more than five times.")
  public void setFrequentlyForwarded(Boolean frequentlyForwarded) {
    this.frequentlyForwarded = frequentlyForwarded;
  }


  public WhatsappInboundMessageContext from(String from) {
    
    this.from = from;
    return this;
  }

   /**
   * **Added to Webhooks if message is an inbound reply to a sent message.**  The WhatsApp ID (a phone number without the &#39;+&#39; prefix) of the sender of the sent message.
   * @return from
  **/
  @javax.annotation.Nullable

  public String getFrom() {
    return from;
  }


  /**
   * **Added to Webhooks if message is an inbound reply to a sent message.**  The WhatsApp ID (a phone number without the &#39;+&#39; prefix) of the sender of the sent message.
   **/
  @ApiModelProperty(value = "**Added to Webhooks if message is an inbound reply to a sent message.**  The WhatsApp ID (a phone number without the '+' prefix) of the sender of the sent message.")
  public void setFrom(String from) {
    this.from = from;
  }


  public WhatsappInboundMessageContext id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * **Optional.**  The &#x60;wamid&#x60; for the sent message for an inbound reply. &#x60;wamid&#x60; is the original message ID on WhatsApp’s platform.
   * @return id
  **/
  @javax.annotation.Nullable

  public String getId() {
    return id;
  }


  /**
   * **Optional.**  The &#x60;wamid&#x60; for the sent message for an inbound reply. &#x60;wamid&#x60; is the original message ID on WhatsApp’s platform.
   **/
  @ApiModelProperty(example = "wamid.BgNODYxN...", value = "**Optional.**  The `wamid` for the sent message for an inbound reply. `wamid` is the original message ID on WhatsApp’s platform.")
  public void setId(String id) {
    this.id = id;
  }


  public WhatsappInboundMessageContext referredProduct(WhatsappInboundMessageReferredProduct referredProduct) {
    
    this.referredProduct = referredProduct;
    return this;
  }

   /**
   * Get referredProduct
   * @return referredProduct
  **/
  @javax.annotation.Nullable

  public WhatsappInboundMessageReferredProduct getReferredProduct() {
    return referredProduct;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setReferredProduct(WhatsappInboundMessageReferredProduct referredProduct) {
    this.referredProduct = referredProduct;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public WhatsappInboundMessageContext putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsappInboundMessageContext whatsappInboundMessageContext = (WhatsappInboundMessageContext) o;
    return Objects.equals(this.forwarded, whatsappInboundMessageContext.forwarded) &&
        Objects.equals(this.frequentlyForwarded, whatsappInboundMessageContext.frequentlyForwarded) &&
        Objects.equals(this.from, whatsappInboundMessageContext.from) &&
        Objects.equals(this.id, whatsappInboundMessageContext.id) &&
        Objects.equals(this.referredProduct, whatsappInboundMessageContext.referredProduct)&&
        Objects.equals(this.additionalProperties, whatsappInboundMessageContext.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(forwarded, frequentlyForwarded, from, id, referredProduct, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsappInboundMessageContext {\n");
    sb.append("    forwarded: ").append(toIndentedString(forwarded)).append("\n");
    sb.append("    frequentlyForwarded: ").append(toIndentedString(frequentlyForwarded)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    referredProduct: ").append(toIndentedString(referredProduct)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("forwarded");
    openapiFields.add("frequently_forwarded");
    openapiFields.add("from");
    openapiFields.add("id");
    openapiFields.add("referred_product");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to WhatsappInboundMessageContext
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (WhatsappInboundMessageContext.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappInboundMessageContext is not found in the empty JSON string", WhatsappInboundMessageContext.openapiRequiredFields.toString()));
        }
      }
      if (jsonObj.get("from") != null && !jsonObj.get("from").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `from` to be a primitive type in the JSON string but got `%s`", jsonObj.get("from").toString()));
      }
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      // validate the optional field `referred_product`
      if (jsonObj.getAsJsonObject("referred_product") != null) {
        WhatsappInboundMessageReferredProduct.validateJsonObject(jsonObj.getAsJsonObject("referred_product"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!WhatsappInboundMessageContext.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'WhatsappInboundMessageContext' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<WhatsappInboundMessageContext> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(WhatsappInboundMessageContext.class));

       return (TypeAdapter<T>) new TypeAdapter<WhatsappInboundMessageContext>() {
           @Override
           public void write(JsonWriter out, WhatsappInboundMessageContext value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public WhatsappInboundMessageContext read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             WhatsappInboundMessageContext instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of WhatsappInboundMessageContext given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of WhatsappInboundMessageContext
  * @throws IOException if the JSON string is invalid with respect to WhatsappInboundMessageContext
  */
  public static WhatsappInboundMessageContext fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, WhatsappInboundMessageContext.class);
  }

 /**
  * Convert an instance of WhatsappInboundMessageContext to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

