/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.model.WhatsappApiError;
import com.ycloud.client.model.WhatsappConversation;
import com.ycloud.client.model.WhatsappMessageContact;
import com.ycloud.client.model.WhatsappMessageContext;
import com.ycloud.client.model.WhatsappMessageInteractive;
import com.ycloud.client.model.WhatsappMessageLocation;
import com.ycloud.client.model.WhatsappMessageMedia;
import com.ycloud.client.model.WhatsappMessageReaction;
import com.ycloud.client.model.WhatsappMessageStatus;
import com.ycloud.client.model.WhatsappMessageTemplate;
import com.ycloud.client.model.WhatsappMessageText;
import com.ycloud.client.model.WhatsappMessageType;
import com.ycloud.client.model.WhatsappPricingCategory;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * WhatsApp outbound message object.
 */
@ApiModel(description = "WhatsApp outbound message object.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class WhatsappMessage {
  public static final String SERIALIZED_NAME_ID = "id";
  /**
   * Unique ID of the message.
  **/
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  public static final String SERIALIZED_NAME_WAMID = "wamid";
  /**
   * The original message ID on WhatsApp&#39;s platform.
  **/
  @SerializedName(SERIALIZED_NAME_WAMID)
  private String wamid;

  public static final String SERIALIZED_NAME_WABA_ID = "wabaId";
  /**
   * WhatsApp Business Account ID.
  **/
  @SerializedName(SERIALIZED_NAME_WABA_ID)
  private String wabaId;

  public static final String SERIALIZED_NAME_FROM = "from";
  /**
   * The sender&#39;s phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.
  **/
  @SerializedName(SERIALIZED_NAME_FROM)
  private String from;

  public static final String SERIALIZED_NAME_TO = "to";
  /**
   * The recipient&#39;s phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.
  **/
  @SerializedName(SERIALIZED_NAME_TO)
  private String to;

  public static final String SERIALIZED_NAME_CONVERSATION = "conversation";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_CONVERSATION)
  private WhatsappConversation conversation;

  public static final String SERIALIZED_NAME_TYPE = "type";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_TYPE)
  private WhatsappMessageType type;

  public static final String SERIALIZED_NAME_TEMPLATE = "template";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_TEMPLATE)
  private WhatsappMessageTemplate template;

  public static final String SERIALIZED_NAME_TEXT = "text";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_TEXT)
  private WhatsappMessageText text;

  public static final String SERIALIZED_NAME_IMAGE = "image";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_IMAGE)
  private WhatsappMessageMedia image;

  public static final String SERIALIZED_NAME_VIDEO = "video";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_VIDEO)
  private WhatsappMessageMedia video;

  public static final String SERIALIZED_NAME_AUDIO = "audio";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_AUDIO)
  private WhatsappMessageMedia audio;

  public static final String SERIALIZED_NAME_DOCUMENT = "document";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_DOCUMENT)
  private WhatsappMessageMedia document;

  public static final String SERIALIZED_NAME_STICKER = "sticker";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_STICKER)
  private WhatsappMessageMedia sticker;

  public static final String SERIALIZED_NAME_LOCATION = "location";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_LOCATION)
  private WhatsappMessageLocation location;

  public static final String SERIALIZED_NAME_INTERACTIVE = "interactive";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_INTERACTIVE)
  private WhatsappMessageInteractive interactive;

  public static final String SERIALIZED_NAME_CONTACTS = "contacts";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_CONTACTS)
  private List<WhatsappMessageContact> contacts = null;

  public static final String SERIALIZED_NAME_REACTION = "reaction";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_REACTION)
  private WhatsappMessageReaction reaction;

  public static final String SERIALIZED_NAME_CONTEXT = "context";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_CONTEXT)
  private WhatsappMessageContext context;

  public static final String SERIALIZED_NAME_EXTERNAL_ID = "externalId";
  /**
   * A unique string to reference the object. This can be an order number or similar, and can be used to reconcile the object with your internal systems.
  **/
  @SerializedName(SERIALIZED_NAME_EXTERNAL_ID)
  private String externalId;

  public static final String SERIALIZED_NAME_STATUS = "status";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_STATUS)
  private WhatsappMessageStatus status;

  public static final String SERIALIZED_NAME_ERROR_CODE = "errorCode";
  /**
   * Error code when the message status is &#x60;failed&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_ERROR_CODE)
  private String errorCode;

  public static final String SERIALIZED_NAME_ERROR_MESSAGE = "errorMessage";
  /**
   * Error message when the message status is &#x60;failed&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_ERROR_MESSAGE)
  private String errorMessage;

  public static final String SERIALIZED_NAME_CREATE_TIME = "createTime";
  /**
   * The time at which this message is created, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_CREATE_TIME)
  private Date createTime;

  public static final String SERIALIZED_NAME_UPDATE_TIME = "updateTime";
  /**
   * The time at which this message is updated, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_UPDATE_TIME)
  private Date updateTime;

  public static final String SERIALIZED_NAME_SEND_TIME = "sendTime";
  /**
   * The time at which this message &#x60;status&#x60; changed to &#x60;sent&#x60;, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_SEND_TIME)
  private Date sendTime;

  public static final String SERIALIZED_NAME_DELIVER_TIME = "deliverTime";
  /**
   * The time at which this message &#x60;status&#x60; changed to &#x60;delivered&#x60;, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_DELIVER_TIME)
  private Date deliverTime;

  public static final String SERIALIZED_NAME_READ_TIME = "readTime";
  /**
   * The time at which this message &#x60;status&#x60; changed to &#x60;read&#x60;, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_READ_TIME)
  private Date readTime;

  public static final String SERIALIZED_NAME_TOTAL_PRICE = "totalPrice";
  /**
   * Total price of this message. **Note: It&#39;s only an estimated price when the &#x60;status&#x60; is &#x60;accepted&#x60; or &#x60;sent&#x60;. It becomes the final price after the message is delivered, i.e., the &#x60;status&#x60; is &#x60;delivered&#x60; or &#x60;read&#x60;.**
  **/
  @SerializedName(SERIALIZED_NAME_TOTAL_PRICE)
  private Double totalPrice;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  /**
   * Price currency. [ISO 4217 currency code](https://en.wikipedia.org/wiki/ISO_4217).
  **/
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private String currency;

  public static final String SERIALIZED_NAME_REGION_CODE = "regionCode";
  /**
   * The [region code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of the recipient phone number.
  **/
  @SerializedName(SERIALIZED_NAME_REGION_CODE)
  private String regionCode;

  public static final String SERIALIZED_NAME_PRICING_CATEGORY = "pricingCategory";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_PRICING_CATEGORY)
  private WhatsappPricingCategory pricingCategory;

  public static final String SERIALIZED_NAME_WHATSAPP_API_ERROR = "whatsappApiError";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_WHATSAPP_API_ERROR)
  private WhatsappApiError whatsappApiError;

  public static final String SERIALIZED_NAME_BIZ_TYPE = "bizType";
  /**
   * This can be either empty or one of &#x60;whatsapp&#x60;, or &#x60;verify&#x60;. Defaults to &#x60;whatsapp&#x60;. - &#x60;whatsapp&#x60;: Indicates that the message is sent via the **WhatsApp** product. - &#x60;verify&#x60;: Indicates that the message is sent via the **Verify** product.
  **/
  @SerializedName(SERIALIZED_NAME_BIZ_TYPE)
  private String bizType;

  public static final String SERIALIZED_NAME_VERIFICATION_ID = "verificationId";
  /**
   * The verification ID. Included only when &#x60;bizType&#x60; is &#x60;verify&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_VERIFICATION_ID)
  private String verificationId;

  public WhatsappMessage() { 
  }

  public WhatsappMessage id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Unique ID of the message.
   * @return id
  **/
  @javax.annotation.Nonnull

  public String getId() {
    return id;
  }


  /**
   * Unique ID of the message.
   **/
  @ApiModelProperty(required = true, value = "Unique ID of the message.")
  public void setId(String id) {
    this.id = id;
  }


  public WhatsappMessage wamid(String wamid) {
    
    this.wamid = wamid;
    return this;
  }

   /**
   * The original message ID on WhatsApp&#39;s platform.
   * @return wamid
  **/
  @javax.annotation.Nullable

  public String getWamid() {
    return wamid;
  }


  /**
   * The original message ID on WhatsApp&#39;s platform.
   **/
  @ApiModelProperty(example = "wamid.BgNODYxN...", value = "The original message ID on WhatsApp's platform.")
  public void setWamid(String wamid) {
    this.wamid = wamid;
  }


  public WhatsappMessage wabaId(String wabaId) {
    
    this.wabaId = wabaId;
    return this;
  }

   /**
   * WhatsApp Business Account ID.
   * @return wabaId
  **/
  @javax.annotation.Nonnull

  public String getWabaId() {
    return wabaId;
  }


  /**
   * WhatsApp Business Account ID.
   **/
  @ApiModelProperty(example = "whatsapp-business-account-id", required = true, value = "WhatsApp Business Account ID.")
  public void setWabaId(String wabaId) {
    this.wabaId = wabaId;
  }


  public WhatsappMessage from(String from) {
    
    this.from = from;
    return this;
  }

   /**
   * The sender&#39;s phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.
   * @return from
  **/
  @javax.annotation.Nonnull

  public String getFrom() {
    return from;
  }


  /**
   * The sender&#39;s phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.
   **/
  @ApiModelProperty(example = "+16315551111", required = true, value = "The sender's phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.")
  public void setFrom(String from) {
    this.from = from;
  }


  public WhatsappMessage to(String to) {
    
    this.to = to;
    return this;
  }

   /**
   * The recipient&#39;s phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.
   * @return to
  **/
  @javax.annotation.Nonnull

  public String getTo() {
    return to;
  }


  /**
   * The recipient&#39;s phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.
   **/
  @ApiModelProperty(example = "+16315551111", required = true, value = "The recipient's phone number in [E.164](https://en.wikipedia.org/wiki/E.164) format.")
  public void setTo(String to) {
    this.to = to;
  }


  public WhatsappMessage conversation(WhatsappConversation conversation) {
    
    this.conversation = conversation;
    return this;
  }

   /**
   * Get conversation
   * @return conversation
  **/
  @javax.annotation.Nullable

  public WhatsappConversation getConversation() {
    return conversation;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setConversation(WhatsappConversation conversation) {
    this.conversation = conversation;
  }


  public WhatsappMessage type(WhatsappMessageType type) {
    
    this.type = type;
    return this;
  }

   /**
   * Get type
   * @return type
  **/
  @javax.annotation.Nullable

  public WhatsappMessageType getType() {
    return type;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setType(WhatsappMessageType type) {
    this.type = type;
  }


  public WhatsappMessage template(WhatsappMessageTemplate template) {
    
    this.template = template;
    return this;
  }

   /**
   * Get template
   * @return template
  **/
  @javax.annotation.Nullable

  public WhatsappMessageTemplate getTemplate() {
    return template;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setTemplate(WhatsappMessageTemplate template) {
    this.template = template;
  }


  public WhatsappMessage text(WhatsappMessageText text) {
    
    this.text = text;
    return this;
  }

   /**
   * Get text
   * @return text
  **/
  @javax.annotation.Nullable

  public WhatsappMessageText getText() {
    return text;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setText(WhatsappMessageText text) {
    this.text = text;
  }


  public WhatsappMessage image(WhatsappMessageMedia image) {
    
    this.image = image;
    return this;
  }

   /**
   * Get image
   * @return image
  **/
  @javax.annotation.Nullable

  public WhatsappMessageMedia getImage() {
    return image;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setImage(WhatsappMessageMedia image) {
    this.image = image;
  }


  public WhatsappMessage video(WhatsappMessageMedia video) {
    
    this.video = video;
    return this;
  }

   /**
   * Get video
   * @return video
  **/
  @javax.annotation.Nullable

  public WhatsappMessageMedia getVideo() {
    return video;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setVideo(WhatsappMessageMedia video) {
    this.video = video;
  }


  public WhatsappMessage audio(WhatsappMessageMedia audio) {
    
    this.audio = audio;
    return this;
  }

   /**
   * Get audio
   * @return audio
  **/
  @javax.annotation.Nullable

  public WhatsappMessageMedia getAudio() {
    return audio;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setAudio(WhatsappMessageMedia audio) {
    this.audio = audio;
  }


  public WhatsappMessage document(WhatsappMessageMedia document) {
    
    this.document = document;
    return this;
  }

   /**
   * Get document
   * @return document
  **/
  @javax.annotation.Nullable

  public WhatsappMessageMedia getDocument() {
    return document;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setDocument(WhatsappMessageMedia document) {
    this.document = document;
  }


  public WhatsappMessage sticker(WhatsappMessageMedia sticker) {
    
    this.sticker = sticker;
    return this;
  }

   /**
   * Get sticker
   * @return sticker
  **/
  @javax.annotation.Nullable

  public WhatsappMessageMedia getSticker() {
    return sticker;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setSticker(WhatsappMessageMedia sticker) {
    this.sticker = sticker;
  }


  public WhatsappMessage location(WhatsappMessageLocation location) {
    
    this.location = location;
    return this;
  }

   /**
   * Get location
   * @return location
  **/
  @javax.annotation.Nullable

  public WhatsappMessageLocation getLocation() {
    return location;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setLocation(WhatsappMessageLocation location) {
    this.location = location;
  }


  public WhatsappMessage interactive(WhatsappMessageInteractive interactive) {
    
    this.interactive = interactive;
    return this;
  }

   /**
   * Get interactive
   * @return interactive
  **/
  @javax.annotation.Nullable

  public WhatsappMessageInteractive getInteractive() {
    return interactive;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setInteractive(WhatsappMessageInteractive interactive) {
    this.interactive = interactive;
  }


  public WhatsappMessage contacts(List<WhatsappMessageContact> contacts) {
    
    this.contacts = contacts;
    return this;
  }

  public WhatsappMessage addContactsItem(WhatsappMessageContact contactsItem) {
    if (this.contacts == null) {
      this.contacts = new ArrayList<>();
    }
    this.contacts.add(contactsItem);
    return this;
  }

   /**
   * Get contacts
   * @return contacts
  **/
  @javax.annotation.Nullable

  public List<WhatsappMessageContact> getContacts() {
    return contacts;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setContacts(List<WhatsappMessageContact> contacts) {
    this.contacts = contacts;
  }


  public WhatsappMessage reaction(WhatsappMessageReaction reaction) {
    
    this.reaction = reaction;
    return this;
  }

   /**
   * Get reaction
   * @return reaction
  **/
  @javax.annotation.Nullable

  public WhatsappMessageReaction getReaction() {
    return reaction;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setReaction(WhatsappMessageReaction reaction) {
    this.reaction = reaction;
  }


  public WhatsappMessage context(WhatsappMessageContext context) {
    
    this.context = context;
    return this;
  }

   /**
   * Get context
   * @return context
  **/
  @javax.annotation.Nullable

  public WhatsappMessageContext getContext() {
    return context;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setContext(WhatsappMessageContext context) {
    this.context = context;
  }


  public WhatsappMessage externalId(String externalId) {
    
    this.externalId = externalId;
    return this;
  }

   /**
   * A unique string to reference the object. This can be an order number or similar, and can be used to reconcile the object with your internal systems.
   * @return externalId
  **/
  @javax.annotation.Nullable

  public String getExternalId() {
    return externalId;
  }


  /**
   * A unique string to reference the object. This can be an order number or similar, and can be used to reconcile the object with your internal systems.
   **/
  @ApiModelProperty(value = "A unique string to reference the object. This can be an order number or similar, and can be used to reconcile the object with your internal systems.")
  public void setExternalId(String externalId) {
    this.externalId = externalId;
  }


  public WhatsappMessage status(WhatsappMessageStatus status) {
    
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nullable

  public WhatsappMessageStatus getStatus() {
    return status;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setStatus(WhatsappMessageStatus status) {
    this.status = status;
  }


  public WhatsappMessage errorCode(String errorCode) {
    
    this.errorCode = errorCode;
    return this;
  }

   /**
   * Error code when the message status is &#x60;failed&#x60;.
   * @return errorCode
  **/
  @javax.annotation.Nullable

  public String getErrorCode() {
    return errorCode;
  }


  /**
   * Error code when the message status is &#x60;failed&#x60;.
   **/
  @ApiModelProperty(example = "INTERNAL_SERVER_ERROR", value = "Error code when the message status is `failed`.")
  public void setErrorCode(String errorCode) {
    this.errorCode = errorCode;
  }


  public WhatsappMessage errorMessage(String errorMessage) {
    
    this.errorMessage = errorMessage;
    return this;
  }

   /**
   * Error message when the message status is &#x60;failed&#x60;.
   * @return errorMessage
  **/
  @javax.annotation.Nullable

  public String getErrorMessage() {
    return errorMessage;
  }


  /**
   * Error message when the message status is &#x60;failed&#x60;.
   **/
  @ApiModelProperty(value = "Error message when the message status is `failed`.")
  public void setErrorMessage(String errorMessage) {
    this.errorMessage = errorMessage;
  }


  public WhatsappMessage createTime(Date createTime) {
    
    this.createTime = createTime;
    return this;
  }

   /**
   * The time at which this message is created, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
   * @return createTime
  **/
  @javax.annotation.Nullable

  public Date getCreateTime() {
    return createTime;
  }


  /**
   * The time at which this message is created, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
   **/
  @ApiModelProperty(example = "2022-06-01T12:00Z", value = "The time at which this message is created, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., `2022-06-01T12:00:00.000Z`.")
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }


  public WhatsappMessage updateTime(Date updateTime) {
    
    this.updateTime = updateTime;
    return this;
  }

   /**
   * The time at which this message is updated, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
   * @return updateTime
  **/
  @javax.annotation.Nullable

  public Date getUpdateTime() {
    return updateTime;
  }


  /**
   * The time at which this message is updated, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
   **/
  @ApiModelProperty(example = "2022-06-01T12:00Z", value = "The time at which this message is updated, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., `2022-06-01T12:00:00.000Z`.")
  public void setUpdateTime(Date updateTime) {
    this.updateTime = updateTime;
  }


  public WhatsappMessage sendTime(Date sendTime) {
    
    this.sendTime = sendTime;
    return this;
  }

   /**
   * The time at which this message &#x60;status&#x60; changed to &#x60;sent&#x60;, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
   * @return sendTime
  **/
  @javax.annotation.Nullable

  public Date getSendTime() {
    return sendTime;
  }


  /**
   * The time at which this message &#x60;status&#x60; changed to &#x60;sent&#x60;, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
   **/
  @ApiModelProperty(example = "2022-06-01T12:00Z", value = "The time at which this message `status` changed to `sent`, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., `2022-06-01T12:00:00.000Z`.")
  public void setSendTime(Date sendTime) {
    this.sendTime = sendTime;
  }


  public WhatsappMessage deliverTime(Date deliverTime) {
    
    this.deliverTime = deliverTime;
    return this;
  }

   /**
   * The time at which this message &#x60;status&#x60; changed to &#x60;delivered&#x60;, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
   * @return deliverTime
  **/
  @javax.annotation.Nullable

  public Date getDeliverTime() {
    return deliverTime;
  }


  /**
   * The time at which this message &#x60;status&#x60; changed to &#x60;delivered&#x60;, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
   **/
  @ApiModelProperty(example = "2022-06-01T12:00Z", value = "The time at which this message `status` changed to `delivered`, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., `2022-06-01T12:00:00.000Z`.")
  public void setDeliverTime(Date deliverTime) {
    this.deliverTime = deliverTime;
  }


  public WhatsappMessage readTime(Date readTime) {
    
    this.readTime = readTime;
    return this;
  }

   /**
   * The time at which this message &#x60;status&#x60; changed to &#x60;read&#x60;, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
   * @return readTime
  **/
  @javax.annotation.Nullable

  public Date getReadTime() {
    return readTime;
  }


  /**
   * The time at which this message &#x60;status&#x60; changed to &#x60;read&#x60;, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., &#x60;2022-06-01T12:00:00.000Z&#x60;.
   **/
  @ApiModelProperty(example = "2022-06-01T12:00Z", value = "The time at which this message `status` changed to `read`, formatted in [RFC 3339](https://datatracker.ietf.org/doc/html/rfc3339). e.g., `2022-06-01T12:00:00.000Z`.")
  public void setReadTime(Date readTime) {
    this.readTime = readTime;
  }


  public WhatsappMessage totalPrice(Double totalPrice) {
    
    this.totalPrice = totalPrice;
    return this;
  }

   /**
   * Total price of this message. **Note: It&#39;s only an estimated price when the &#x60;status&#x60; is &#x60;accepted&#x60; or &#x60;sent&#x60;. It becomes the final price after the message is delivered, i.e., the &#x60;status&#x60; is &#x60;delivered&#x60; or &#x60;read&#x60;.**
   * @return totalPrice
  **/
  @javax.annotation.Nullable

  public Double getTotalPrice() {
    return totalPrice;
  }


  /**
   * Total price of this message. **Note: It&#39;s only an estimated price when the &#x60;status&#x60; is &#x60;accepted&#x60; or &#x60;sent&#x60;. It becomes the final price after the message is delivered, i.e., the &#x60;status&#x60; is &#x60;delivered&#x60; or &#x60;read&#x60;.**
   **/
  @ApiModelProperty(example = "0.05", value = "Total price of this message. **Note: It's only an estimated price when the `status` is `accepted` or `sent`. It becomes the final price after the message is delivered, i.e., the `status` is `delivered` or `read`.**")
  public void setTotalPrice(Double totalPrice) {
    this.totalPrice = totalPrice;
  }


  public WhatsappMessage currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Price currency. [ISO 4217 currency code](https://en.wikipedia.org/wiki/ISO_4217).
   * @return currency
  **/
  @javax.annotation.Nullable

  public String getCurrency() {
    return currency;
  }


  /**
   * Price currency. [ISO 4217 currency code](https://en.wikipedia.org/wiki/ISO_4217).
   **/
  @ApiModelProperty(example = "USD", value = "Price currency. [ISO 4217 currency code](https://en.wikipedia.org/wiki/ISO_4217).")
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public WhatsappMessage regionCode(String regionCode) {
    
    this.regionCode = regionCode;
    return this;
  }

   /**
   * The [region code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of the recipient phone number.
   * @return regionCode
  **/
  @javax.annotation.Nullable

  public String getRegionCode() {
    return regionCode;
  }


  /**
   * The [region code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of the recipient phone number.
   **/
  @ApiModelProperty(example = "US", value = "The [region code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) of the recipient phone number.")
  public void setRegionCode(String regionCode) {
    this.regionCode = regionCode;
  }


  public WhatsappMessage pricingCategory(WhatsappPricingCategory pricingCategory) {
    
    this.pricingCategory = pricingCategory;
    return this;
  }

   /**
   * Get pricingCategory
   * @return pricingCategory
  **/
  @javax.annotation.Nullable

  public WhatsappPricingCategory getPricingCategory() {
    return pricingCategory;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setPricingCategory(WhatsappPricingCategory pricingCategory) {
    this.pricingCategory = pricingCategory;
  }


  public WhatsappMessage whatsappApiError(WhatsappApiError whatsappApiError) {
    
    this.whatsappApiError = whatsappApiError;
    return this;
  }

   /**
   * Get whatsappApiError
   * @return whatsappApiError
  **/
  @javax.annotation.Nullable

  public WhatsappApiError getWhatsappApiError() {
    return whatsappApiError;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setWhatsappApiError(WhatsappApiError whatsappApiError) {
    this.whatsappApiError = whatsappApiError;
  }


  public WhatsappMessage bizType(String bizType) {
    
    this.bizType = bizType;
    return this;
  }

   /**
   * This can be either empty or one of &#x60;whatsapp&#x60;, or &#x60;verify&#x60;. Defaults to &#x60;whatsapp&#x60;. - &#x60;whatsapp&#x60;: Indicates that the message is sent via the **WhatsApp** product. - &#x60;verify&#x60;: Indicates that the message is sent via the **Verify** product.
   * @return bizType
  **/
  @javax.annotation.Nullable

  public String getBizType() {
    return bizType;
  }


  /**
   * This can be either empty or one of &#x60;whatsapp&#x60;, or &#x60;verify&#x60;. Defaults to &#x60;whatsapp&#x60;. - &#x60;whatsapp&#x60;: Indicates that the message is sent via the **WhatsApp** product. - &#x60;verify&#x60;: Indicates that the message is sent via the **Verify** product.
   **/
  @ApiModelProperty(example = "whatsapp", value = "This can be either empty or one of `whatsapp`, or `verify`. Defaults to `whatsapp`. - `whatsapp`: Indicates that the message is sent via the **WhatsApp** product. - `verify`: Indicates that the message is sent via the **Verify** product.")
  public void setBizType(String bizType) {
    this.bizType = bizType;
  }


  public WhatsappMessage verificationId(String verificationId) {
    
    this.verificationId = verificationId;
    return this;
  }

   /**
   * The verification ID. Included only when &#x60;bizType&#x60; is &#x60;verify&#x60;.
   * @return verificationId
  **/
  @javax.annotation.Nullable

  public String getVerificationId() {
    return verificationId;
  }


  /**
   * The verification ID. Included only when &#x60;bizType&#x60; is &#x60;verify&#x60;.
   **/
  @ApiModelProperty(example = "VERIFICATION-ID", value = "The verification ID. Included only when `bizType` is `verify`.")
  public void setVerificationId(String verificationId) {
    this.verificationId = verificationId;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public WhatsappMessage putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsappMessage whatsappMessage = (WhatsappMessage) o;
    return Objects.equals(this.id, whatsappMessage.id) &&
        Objects.equals(this.wamid, whatsappMessage.wamid) &&
        Objects.equals(this.wabaId, whatsappMessage.wabaId) &&
        Objects.equals(this.from, whatsappMessage.from) &&
        Objects.equals(this.to, whatsappMessage.to) &&
        Objects.equals(this.conversation, whatsappMessage.conversation) &&
        Objects.equals(this.type, whatsappMessage.type) &&
        Objects.equals(this.template, whatsappMessage.template) &&
        Objects.equals(this.text, whatsappMessage.text) &&
        Objects.equals(this.image, whatsappMessage.image) &&
        Objects.equals(this.video, whatsappMessage.video) &&
        Objects.equals(this.audio, whatsappMessage.audio) &&
        Objects.equals(this.document, whatsappMessage.document) &&
        Objects.equals(this.sticker, whatsappMessage.sticker) &&
        Objects.equals(this.location, whatsappMessage.location) &&
        Objects.equals(this.interactive, whatsappMessage.interactive) &&
        Objects.equals(this.contacts, whatsappMessage.contacts) &&
        Objects.equals(this.reaction, whatsappMessage.reaction) &&
        Objects.equals(this.context, whatsappMessage.context) &&
        Objects.equals(this.externalId, whatsappMessage.externalId) &&
        Objects.equals(this.status, whatsappMessage.status) &&
        Objects.equals(this.errorCode, whatsappMessage.errorCode) &&
        Objects.equals(this.errorMessage, whatsappMessage.errorMessage) &&
        Objects.equals(this.createTime, whatsappMessage.createTime) &&
        Objects.equals(this.updateTime, whatsappMessage.updateTime) &&
        Objects.equals(this.sendTime, whatsappMessage.sendTime) &&
        Objects.equals(this.deliverTime, whatsappMessage.deliverTime) &&
        Objects.equals(this.readTime, whatsappMessage.readTime) &&
        Objects.equals(this.totalPrice, whatsappMessage.totalPrice) &&
        Objects.equals(this.currency, whatsappMessage.currency) &&
        Objects.equals(this.regionCode, whatsappMessage.regionCode) &&
        Objects.equals(this.pricingCategory, whatsappMessage.pricingCategory) &&
        Objects.equals(this.whatsappApiError, whatsappMessage.whatsappApiError) &&
        Objects.equals(this.bizType, whatsappMessage.bizType) &&
        Objects.equals(this.verificationId, whatsappMessage.verificationId)&&
        Objects.equals(this.additionalProperties, whatsappMessage.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, wamid, wabaId, from, to, conversation, type, template, text, image, video, audio, document, sticker, location, interactive, contacts, reaction, context, externalId, status, errorCode, errorMessage, createTime, updateTime, sendTime, deliverTime, readTime, totalPrice, currency, regionCode, pricingCategory, whatsappApiError, bizType, verificationId, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsappMessage {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    wamid: ").append(toIndentedString(wamid)).append("\n");
    sb.append("    wabaId: ").append(toIndentedString(wabaId)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("    conversation: ").append(toIndentedString(conversation)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    template: ").append(toIndentedString(template)).append("\n");
    sb.append("    text: ").append(toIndentedString(text)).append("\n");
    sb.append("    image: ").append(toIndentedString(image)).append("\n");
    sb.append("    video: ").append(toIndentedString(video)).append("\n");
    sb.append("    audio: ").append(toIndentedString(audio)).append("\n");
    sb.append("    document: ").append(toIndentedString(document)).append("\n");
    sb.append("    sticker: ").append(toIndentedString(sticker)).append("\n");
    sb.append("    location: ").append(toIndentedString(location)).append("\n");
    sb.append("    interactive: ").append(toIndentedString(interactive)).append("\n");
    sb.append("    contacts: ").append(toIndentedString(contacts)).append("\n");
    sb.append("    reaction: ").append(toIndentedString(reaction)).append("\n");
    sb.append("    context: ").append(toIndentedString(context)).append("\n");
    sb.append("    externalId: ").append(toIndentedString(externalId)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    errorCode: ").append(toIndentedString(errorCode)).append("\n");
    sb.append("    errorMessage: ").append(toIndentedString(errorMessage)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    sendTime: ").append(toIndentedString(sendTime)).append("\n");
    sb.append("    deliverTime: ").append(toIndentedString(deliverTime)).append("\n");
    sb.append("    readTime: ").append(toIndentedString(readTime)).append("\n");
    sb.append("    totalPrice: ").append(toIndentedString(totalPrice)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    regionCode: ").append(toIndentedString(regionCode)).append("\n");
    sb.append("    pricingCategory: ").append(toIndentedString(pricingCategory)).append("\n");
    sb.append("    whatsappApiError: ").append(toIndentedString(whatsappApiError)).append("\n");
    sb.append("    bizType: ").append(toIndentedString(bizType)).append("\n");
    sb.append("    verificationId: ").append(toIndentedString(verificationId)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("wamid");
    openapiFields.add("wabaId");
    openapiFields.add("from");
    openapiFields.add("to");
    openapiFields.add("conversation");
    openapiFields.add("type");
    openapiFields.add("template");
    openapiFields.add("text");
    openapiFields.add("image");
    openapiFields.add("video");
    openapiFields.add("audio");
    openapiFields.add("document");
    openapiFields.add("sticker");
    openapiFields.add("location");
    openapiFields.add("interactive");
    openapiFields.add("contacts");
    openapiFields.add("reaction");
    openapiFields.add("context");
    openapiFields.add("externalId");
    openapiFields.add("status");
    openapiFields.add("errorCode");
    openapiFields.add("errorMessage");
    openapiFields.add("createTime");
    openapiFields.add("updateTime");
    openapiFields.add("sendTime");
    openapiFields.add("deliverTime");
    openapiFields.add("readTime");
    openapiFields.add("totalPrice");
    openapiFields.add("currency");
    openapiFields.add("regionCode");
    openapiFields.add("pricingCategory");
    openapiFields.add("whatsappApiError");
    openapiFields.add("bizType");
    openapiFields.add("verificationId");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("wabaId");
    openapiRequiredFields.add("from");
    openapiRequiredFields.add("to");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to WhatsappMessage
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (WhatsappMessage.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappMessage is not found in the empty JSON string", WhatsappMessage.openapiRequiredFields.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : WhatsappMessage.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if (jsonObj.get("wamid") != null && !jsonObj.get("wamid").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `wamid` to be a primitive type in the JSON string but got `%s`", jsonObj.get("wamid").toString()));
      }
      if (jsonObj.get("wabaId") != null && !jsonObj.get("wabaId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `wabaId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("wabaId").toString()));
      }
      if (jsonObj.get("from") != null && !jsonObj.get("from").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `from` to be a primitive type in the JSON string but got `%s`", jsonObj.get("from").toString()));
      }
      if (jsonObj.get("to") != null && !jsonObj.get("to").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `to` to be a primitive type in the JSON string but got `%s`", jsonObj.get("to").toString()));
      }
      // validate the optional field `conversation`
      if (jsonObj.getAsJsonObject("conversation") != null) {
        WhatsappConversation.validateJsonObject(jsonObj.getAsJsonObject("conversation"));
      }
      // validate the optional field `template`
      if (jsonObj.getAsJsonObject("template") != null) {
        WhatsappMessageTemplate.validateJsonObject(jsonObj.getAsJsonObject("template"));
      }
      // validate the optional field `text`
      if (jsonObj.getAsJsonObject("text") != null) {
        WhatsappMessageText.validateJsonObject(jsonObj.getAsJsonObject("text"));
      }
      // validate the optional field `image`
      if (jsonObj.getAsJsonObject("image") != null) {
        WhatsappMessageMedia.validateJsonObject(jsonObj.getAsJsonObject("image"));
      }
      // validate the optional field `video`
      if (jsonObj.getAsJsonObject("video") != null) {
        WhatsappMessageMedia.validateJsonObject(jsonObj.getAsJsonObject("video"));
      }
      // validate the optional field `audio`
      if (jsonObj.getAsJsonObject("audio") != null) {
        WhatsappMessageMedia.validateJsonObject(jsonObj.getAsJsonObject("audio"));
      }
      // validate the optional field `document`
      if (jsonObj.getAsJsonObject("document") != null) {
        WhatsappMessageMedia.validateJsonObject(jsonObj.getAsJsonObject("document"));
      }
      // validate the optional field `sticker`
      if (jsonObj.getAsJsonObject("sticker") != null) {
        WhatsappMessageMedia.validateJsonObject(jsonObj.getAsJsonObject("sticker"));
      }
      // validate the optional field `location`
      if (jsonObj.getAsJsonObject("location") != null) {
        WhatsappMessageLocation.validateJsonObject(jsonObj.getAsJsonObject("location"));
      }
      // validate the optional field `interactive`
      if (jsonObj.getAsJsonObject("interactive") != null) {
        WhatsappMessageInteractive.validateJsonObject(jsonObj.getAsJsonObject("interactive"));
      }
      JsonArray jsonArraycontacts = jsonObj.getAsJsonArray("contacts");
      if (jsonArraycontacts != null) {
        // ensure the json data is an array
        if (!jsonObj.get("contacts").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `contacts` to be an array in the JSON string but got `%s`", jsonObj.get("contacts").toString()));
        }

        // validate the optional field `contacts` (array)
        for (int i = 0; i < jsonArraycontacts.size(); i++) {
          WhatsappMessageContact.validateJsonObject(jsonArraycontacts.get(i).getAsJsonObject());
        };
      }
      // validate the optional field `reaction`
      if (jsonObj.getAsJsonObject("reaction") != null) {
        WhatsappMessageReaction.validateJsonObject(jsonObj.getAsJsonObject("reaction"));
      }
      // validate the optional field `context`
      if (jsonObj.getAsJsonObject("context") != null) {
        WhatsappMessageContext.validateJsonObject(jsonObj.getAsJsonObject("context"));
      }
      if (jsonObj.get("externalId") != null && !jsonObj.get("externalId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `externalId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("externalId").toString()));
      }
      if (jsonObj.get("errorCode") != null && !jsonObj.get("errorCode").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `errorCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("errorCode").toString()));
      }
      if (jsonObj.get("errorMessage") != null && !jsonObj.get("errorMessage").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `errorMessage` to be a primitive type in the JSON string but got `%s`", jsonObj.get("errorMessage").toString()));
      }
      if (jsonObj.get("currency") != null && !jsonObj.get("currency").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("currency").toString()));
      }
      if (jsonObj.get("regionCode") != null && !jsonObj.get("regionCode").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `regionCode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("regionCode").toString()));
      }
      // validate the optional field `whatsappApiError`
      if (jsonObj.getAsJsonObject("whatsappApiError") != null) {
        WhatsappApiError.validateJsonObject(jsonObj.getAsJsonObject("whatsappApiError"));
      }
      if (jsonObj.get("bizType") != null && !jsonObj.get("bizType").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `bizType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("bizType").toString()));
      }
      if (jsonObj.get("verificationId") != null && !jsonObj.get("verificationId").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `verificationId` to be a primitive type in the JSON string but got `%s`", jsonObj.get("verificationId").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!WhatsappMessage.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'WhatsappMessage' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<WhatsappMessage> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(WhatsappMessage.class));

       return (TypeAdapter<T>) new TypeAdapter<WhatsappMessage>() {
           @Override
           public void write(JsonWriter out, WhatsappMessage value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public WhatsappMessage read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             WhatsappMessage instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of WhatsappMessage given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of WhatsappMessage
  * @throws IOException if the JSON string is invalid with respect to WhatsappMessage
  */
  public static WhatsappMessage fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, WhatsappMessage.class);
  }

 /**
  * Convert an instance of WhatsappMessage to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

