/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.model.WhatsappMessageContactAddress;
import com.ycloud.client.model.WhatsappMessageContactEmail;
import com.ycloud.client.model.WhatsappMessageContactName;
import com.ycloud.client.model.WhatsappMessageContactOrg;
import com.ycloud.client.model.WhatsappMessageContactPhone;
import com.ycloud.client.model.WhatsappMessageContactUrl;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * When the message type filed is set to &#x60;contacts&#x60;, this object is included in the message object.
 */
@ApiModel(description = "When the message type filed is set to `contacts`, this object is included in the message object.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class WhatsappMessageContact {
  public static final String SERIALIZED_NAME_ADDRESSES = "addresses";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_ADDRESSES)
  private List<WhatsappMessageContactAddress> addresses = null;

  public static final String SERIALIZED_NAME_BIRTHDAY = "birthday";
  /**
   * &#x60;YYYY-MM-DD&#x60; formatted string.
  **/
  @SerializedName(SERIALIZED_NAME_BIRTHDAY)
  private String birthday;

  public static final String SERIALIZED_NAME_EMAILS = "emails";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_EMAILS)
  private List<WhatsappMessageContactEmail> emails = null;

  public static final String SERIALIZED_NAME_NAME = "name";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_NAME)
  private WhatsappMessageContactName name;

  public static final String SERIALIZED_NAME_ORG = "org";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_ORG)
  private WhatsappMessageContactOrg org;

  public static final String SERIALIZED_NAME_PHONES = "phones";
  /**
   * Contact phone number(s) formatted as a phone object.
  **/
  @SerializedName(SERIALIZED_NAME_PHONES)
  private List<WhatsappMessageContactPhone> phones = null;

  public static final String SERIALIZED_NAME_URLS = "urls";
  /**
   * Contact URL(s) formatted as a urls object.
  **/
  @SerializedName(SERIALIZED_NAME_URLS)
  private List<WhatsappMessageContactUrl> urls = null;

  public WhatsappMessageContact() { 
  }

  public WhatsappMessageContact addresses(List<WhatsappMessageContactAddress> addresses) {
    
    this.addresses = addresses;
    return this;
  }

  public WhatsappMessageContact addAddressesItem(WhatsappMessageContactAddress addressesItem) {
    if (this.addresses == null) {
      this.addresses = new ArrayList<>();
    }
    this.addresses.add(addressesItem);
    return this;
  }

   /**
   * Get addresses
   * @return addresses
  **/
  @javax.annotation.Nullable

  public List<WhatsappMessageContactAddress> getAddresses() {
    return addresses;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setAddresses(List<WhatsappMessageContactAddress> addresses) {
    this.addresses = addresses;
  }


  public WhatsappMessageContact birthday(String birthday) {
    
    this.birthday = birthday;
    return this;
  }

   /**
   * &#x60;YYYY-MM-DD&#x60; formatted string.
   * @return birthday
  **/
  @javax.annotation.Nullable

  public String getBirthday() {
    return birthday;
  }


  /**
   * &#x60;YYYY-MM-DD&#x60; formatted string.
   **/
  @ApiModelProperty(example = "2022-09-27", value = "`YYYY-MM-DD` formatted string.")
  public void setBirthday(String birthday) {
    this.birthday = birthday;
  }


  public WhatsappMessageContact emails(List<WhatsappMessageContactEmail> emails) {
    
    this.emails = emails;
    return this;
  }

  public WhatsappMessageContact addEmailsItem(WhatsappMessageContactEmail emailsItem) {
    if (this.emails == null) {
      this.emails = new ArrayList<>();
    }
    this.emails.add(emailsItem);
    return this;
  }

   /**
   * Get emails
   * @return emails
  **/
  @javax.annotation.Nullable

  public List<WhatsappMessageContactEmail> getEmails() {
    return emails;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setEmails(List<WhatsappMessageContactEmail> emails) {
    this.emails = emails;
  }


  public WhatsappMessageContact name(WhatsappMessageContactName name) {
    
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @javax.annotation.Nonnull

  public WhatsappMessageContactName getName() {
    return name;
  }


  /**
   **/
  @ApiModelProperty(required = true, value = "")
  public void setName(WhatsappMessageContactName name) {
    this.name = name;
  }


  public WhatsappMessageContact org(WhatsappMessageContactOrg org) {
    
    this.org = org;
    return this;
  }

   /**
   * Get org
   * @return org
  **/
  @javax.annotation.Nullable

  public WhatsappMessageContactOrg getOrg() {
    return org;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setOrg(WhatsappMessageContactOrg org) {
    this.org = org;
  }


  public WhatsappMessageContact phones(List<WhatsappMessageContactPhone> phones) {
    
    this.phones = phones;
    return this;
  }

  public WhatsappMessageContact addPhonesItem(WhatsappMessageContactPhone phonesItem) {
    if (this.phones == null) {
      this.phones = new ArrayList<>();
    }
    this.phones.add(phonesItem);
    return this;
  }

   /**
   * Contact phone number(s) formatted as a phone object.
   * @return phones
  **/
  @javax.annotation.Nullable

  public List<WhatsappMessageContactPhone> getPhones() {
    return phones;
  }


  /**
   * Contact phone number(s) formatted as a phone object.
   **/
  @ApiModelProperty(value = "Contact phone number(s) formatted as a phone object.")
  public void setPhones(List<WhatsappMessageContactPhone> phones) {
    this.phones = phones;
  }


  public WhatsappMessageContact urls(List<WhatsappMessageContactUrl> urls) {
    
    this.urls = urls;
    return this;
  }

  public WhatsappMessageContact addUrlsItem(WhatsappMessageContactUrl urlsItem) {
    if (this.urls == null) {
      this.urls = new ArrayList<>();
    }
    this.urls.add(urlsItem);
    return this;
  }

   /**
   * Contact URL(s) formatted as a urls object.
   * @return urls
  **/
  @javax.annotation.Nullable

  public List<WhatsappMessageContactUrl> getUrls() {
    return urls;
  }


  /**
   * Contact URL(s) formatted as a urls object.
   **/
  @ApiModelProperty(value = "Contact URL(s) formatted as a urls object.")
  public void setUrls(List<WhatsappMessageContactUrl> urls) {
    this.urls = urls;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public WhatsappMessageContact putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsappMessageContact whatsappMessageContact = (WhatsappMessageContact) o;
    return Objects.equals(this.addresses, whatsappMessageContact.addresses) &&
        Objects.equals(this.birthday, whatsappMessageContact.birthday) &&
        Objects.equals(this.emails, whatsappMessageContact.emails) &&
        Objects.equals(this.name, whatsappMessageContact.name) &&
        Objects.equals(this.org, whatsappMessageContact.org) &&
        Objects.equals(this.phones, whatsappMessageContact.phones) &&
        Objects.equals(this.urls, whatsappMessageContact.urls)&&
        Objects.equals(this.additionalProperties, whatsappMessageContact.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addresses, birthday, emails, name, org, phones, urls, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsappMessageContact {\n");
    sb.append("    addresses: ").append(toIndentedString(addresses)).append("\n");
    sb.append("    birthday: ").append(toIndentedString(birthday)).append("\n");
    sb.append("    emails: ").append(toIndentedString(emails)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    org: ").append(toIndentedString(org)).append("\n");
    sb.append("    phones: ").append(toIndentedString(phones)).append("\n");
    sb.append("    urls: ").append(toIndentedString(urls)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("addresses");
    openapiFields.add("birthday");
    openapiFields.add("emails");
    openapiFields.add("name");
    openapiFields.add("org");
    openapiFields.add("phones");
    openapiFields.add("urls");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("name");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to WhatsappMessageContact
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (WhatsappMessageContact.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappMessageContact is not found in the empty JSON string", WhatsappMessageContact.openapiRequiredFields.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : WhatsappMessageContact.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      JsonArray jsonArrayaddresses = jsonObj.getAsJsonArray("addresses");
      if (jsonArrayaddresses != null) {
        // ensure the json data is an array
        if (!jsonObj.get("addresses").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `addresses` to be an array in the JSON string but got `%s`", jsonObj.get("addresses").toString()));
        }

        // validate the optional field `addresses` (array)
        for (int i = 0; i < jsonArrayaddresses.size(); i++) {
          WhatsappMessageContactAddress.validateJsonObject(jsonArrayaddresses.get(i).getAsJsonObject());
        };
      }
      if (jsonObj.get("birthday") != null && !jsonObj.get("birthday").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `birthday` to be a primitive type in the JSON string but got `%s`", jsonObj.get("birthday").toString()));
      }
      JsonArray jsonArrayemails = jsonObj.getAsJsonArray("emails");
      if (jsonArrayemails != null) {
        // ensure the json data is an array
        if (!jsonObj.get("emails").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `emails` to be an array in the JSON string but got `%s`", jsonObj.get("emails").toString()));
        }

        // validate the optional field `emails` (array)
        for (int i = 0; i < jsonArrayemails.size(); i++) {
          WhatsappMessageContactEmail.validateJsonObject(jsonArrayemails.get(i).getAsJsonObject());
        };
      }
      // validate the optional field `name`
      if (jsonObj.getAsJsonObject("name") != null) {
        WhatsappMessageContactName.validateJsonObject(jsonObj.getAsJsonObject("name"));
      }
      // validate the optional field `org`
      if (jsonObj.getAsJsonObject("org") != null) {
        WhatsappMessageContactOrg.validateJsonObject(jsonObj.getAsJsonObject("org"));
      }
      JsonArray jsonArrayphones = jsonObj.getAsJsonArray("phones");
      if (jsonArrayphones != null) {
        // ensure the json data is an array
        if (!jsonObj.get("phones").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `phones` to be an array in the JSON string but got `%s`", jsonObj.get("phones").toString()));
        }

        // validate the optional field `phones` (array)
        for (int i = 0; i < jsonArrayphones.size(); i++) {
          WhatsappMessageContactPhone.validateJsonObject(jsonArrayphones.get(i).getAsJsonObject());
        };
      }
      JsonArray jsonArrayurls = jsonObj.getAsJsonArray("urls");
      if (jsonArrayurls != null) {
        // ensure the json data is an array
        if (!jsonObj.get("urls").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `urls` to be an array in the JSON string but got `%s`", jsonObj.get("urls").toString()));
        }

        // validate the optional field `urls` (array)
        for (int i = 0; i < jsonArrayurls.size(); i++) {
          WhatsappMessageContactUrl.validateJsonObject(jsonArrayurls.get(i).getAsJsonObject());
        };
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!WhatsappMessageContact.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'WhatsappMessageContact' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<WhatsappMessageContact> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(WhatsappMessageContact.class));

       return (TypeAdapter<T>) new TypeAdapter<WhatsappMessageContact>() {
           @Override
           public void write(JsonWriter out, WhatsappMessageContact value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public WhatsappMessageContact read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             WhatsappMessageContact instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of WhatsappMessageContact given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of WhatsappMessageContact
  * @throws IOException if the JSON string is invalid with respect to WhatsappMessageContact
  */
  public static WhatsappMessageContact fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, WhatsappMessageContact.class);
  }

 /**
  * Convert an instance of WhatsappMessageContact to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

