/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * Full contact address(es) formatted as an addresses object.
 */
@ApiModel(description = "Full contact address(es) formatted as an addresses object.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class WhatsappMessageContactAddress {
  public static final String SERIALIZED_NAME_STREET = "street";
  /**
   * Street number and name.
  **/
  @SerializedName(SERIALIZED_NAME_STREET)
  private String street;

  public static final String SERIALIZED_NAME_CITY = "city";
  /**
   * City name.
  **/
  @SerializedName(SERIALIZED_NAME_CITY)
  private String city;

  public static final String SERIALIZED_NAME_STATE = "state";
  /**
   * State abbreviation.
  **/
  @SerializedName(SERIALIZED_NAME_STATE)
  private String state;

  public static final String SERIALIZED_NAME_ZIP = "zip";
  /**
   * ZIP code.
  **/
  @SerializedName(SERIALIZED_NAME_ZIP)
  private String zip;

  public static final String SERIALIZED_NAME_COUNTRY = "country";
  /**
   * Full country name.
  **/
  @SerializedName(SERIALIZED_NAME_COUNTRY)
  private String country;

  public static final String SERIALIZED_NAME_COUNTRY_CODE = "country_code";
  /**
   * Two-letter country abbreviation.
  **/
  @SerializedName(SERIALIZED_NAME_COUNTRY_CODE)
  private String countryCode;

  public static final String SERIALIZED_NAME_TYPE = "type";
  /**
   * Standard values are &#x60;HOME&#x60; and &#x60;WORK&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public WhatsappMessageContactAddress() { 
  }

  public WhatsappMessageContactAddress street(String street) {
    
    this.street = street;
    return this;
  }

   /**
   * Street number and name.
   * @return street
  **/
  @javax.annotation.Nullable

  public String getStreet() {
    return street;
  }


  /**
   * Street number and name.
   **/
  @ApiModelProperty(value = "Street number and name.")
  public void setStreet(String street) {
    this.street = street;
  }


  public WhatsappMessageContactAddress city(String city) {
    
    this.city = city;
    return this;
  }

   /**
   * City name.
   * @return city
  **/
  @javax.annotation.Nullable

  public String getCity() {
    return city;
  }


  /**
   * City name.
   **/
  @ApiModelProperty(value = "City name.")
  public void setCity(String city) {
    this.city = city;
  }


  public WhatsappMessageContactAddress state(String state) {
    
    this.state = state;
    return this;
  }

   /**
   * State abbreviation.
   * @return state
  **/
  @javax.annotation.Nullable

  public String getState() {
    return state;
  }


  /**
   * State abbreviation.
   **/
  @ApiModelProperty(value = "State abbreviation.")
  public void setState(String state) {
    this.state = state;
  }


  public WhatsappMessageContactAddress zip(String zip) {
    
    this.zip = zip;
    return this;
  }

   /**
   * ZIP code.
   * @return zip
  **/
  @javax.annotation.Nullable

  public String getZip() {
    return zip;
  }


  /**
   * ZIP code.
   **/
  @ApiModelProperty(value = "ZIP code.")
  public void setZip(String zip) {
    this.zip = zip;
  }


  public WhatsappMessageContactAddress country(String country) {
    
    this.country = country;
    return this;
  }

   /**
   * Full country name.
   * @return country
  **/
  @javax.annotation.Nullable

  public String getCountry() {
    return country;
  }


  /**
   * Full country name.
   **/
  @ApiModelProperty(value = "Full country name.")
  public void setCountry(String country) {
    this.country = country;
  }


  public WhatsappMessageContactAddress countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * Two-letter country abbreviation.
   * @return countryCode
  **/
  @javax.annotation.Nullable

  public String getCountryCode() {
    return countryCode;
  }


  /**
   * Two-letter country abbreviation.
   **/
  @ApiModelProperty(value = "Two-letter country abbreviation.")
  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public WhatsappMessageContactAddress type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Standard values are &#x60;HOME&#x60; and &#x60;WORK&#x60;.
   * @return type
  **/
  @javax.annotation.Nullable

  public String getType() {
    return type;
  }


  /**
   * Standard values are &#x60;HOME&#x60; and &#x60;WORK&#x60;.
   **/
  @ApiModelProperty(example = "WORK", value = "Standard values are `HOME` and `WORK`.")
  public void setType(String type) {
    this.type = type;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public WhatsappMessageContactAddress putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsappMessageContactAddress whatsappMessageContactAddress = (WhatsappMessageContactAddress) o;
    return Objects.equals(this.street, whatsappMessageContactAddress.street) &&
        Objects.equals(this.city, whatsappMessageContactAddress.city) &&
        Objects.equals(this.state, whatsappMessageContactAddress.state) &&
        Objects.equals(this.zip, whatsappMessageContactAddress.zip) &&
        Objects.equals(this.country, whatsappMessageContactAddress.country) &&
        Objects.equals(this.countryCode, whatsappMessageContactAddress.countryCode) &&
        Objects.equals(this.type, whatsappMessageContactAddress.type)&&
        Objects.equals(this.additionalProperties, whatsappMessageContactAddress.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(street, city, state, zip, country, countryCode, type, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsappMessageContactAddress {\n");
    sb.append("    street: ").append(toIndentedString(street)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    zip: ").append(toIndentedString(zip)).append("\n");
    sb.append("    country: ").append(toIndentedString(country)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("street");
    openapiFields.add("city");
    openapiFields.add("state");
    openapiFields.add("zip");
    openapiFields.add("country");
    openapiFields.add("country_code");
    openapiFields.add("type");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to WhatsappMessageContactAddress
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (WhatsappMessageContactAddress.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappMessageContactAddress is not found in the empty JSON string", WhatsappMessageContactAddress.openapiRequiredFields.toString()));
        }
      }
      if (jsonObj.get("street") != null && !jsonObj.get("street").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `street` to be a primitive type in the JSON string but got `%s`", jsonObj.get("street").toString()));
      }
      if (jsonObj.get("city") != null && !jsonObj.get("city").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `city` to be a primitive type in the JSON string but got `%s`", jsonObj.get("city").toString()));
      }
      if (jsonObj.get("state") != null && !jsonObj.get("state").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `state` to be a primitive type in the JSON string but got `%s`", jsonObj.get("state").toString()));
      }
      if (jsonObj.get("zip") != null && !jsonObj.get("zip").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `zip` to be a primitive type in the JSON string but got `%s`", jsonObj.get("zip").toString()));
      }
      if (jsonObj.get("country") != null && !jsonObj.get("country").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `country` to be a primitive type in the JSON string but got `%s`", jsonObj.get("country").toString()));
      }
      if (jsonObj.get("country_code") != null && !jsonObj.get("country_code").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `country_code` to be a primitive type in the JSON string but got `%s`", jsonObj.get("country_code").toString()));
      }
      if (jsonObj.get("type") != null && !jsonObj.get("type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!WhatsappMessageContactAddress.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'WhatsappMessageContactAddress' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<WhatsappMessageContactAddress> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(WhatsappMessageContactAddress.class));

       return (TypeAdapter<T>) new TypeAdapter<WhatsappMessageContactAddress>() {
           @Override
           public void write(JsonWriter out, WhatsappMessageContactAddress value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public WhatsappMessageContactAddress read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             WhatsappMessageContactAddress instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of WhatsappMessageContactAddress given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of WhatsappMessageContactAddress
  * @throws IOException if the JSON string is invalid with respect to WhatsappMessageContactAddress
  */
  public static WhatsappMessageContactAddress fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, WhatsappMessageContactAddress.class);
  }

 /**
  * Convert an instance of WhatsappMessageContactAddress to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

