/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * Full contact name formatted as a name object.
 */
@ApiModel(description = "Full contact name formatted as a name object.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class WhatsappMessageContactName {
  public static final String SERIALIZED_NAME_FORMATTED_NAME = "formatted_name";
  /**
   * Full name, as it normally appears.
  **/
  @SerializedName(SERIALIZED_NAME_FORMATTED_NAME)
  private String formattedName;

  public static final String SERIALIZED_NAME_FIRST_NAME = "first_name";
  /**
   * First name.
  **/
  @SerializedName(SERIALIZED_NAME_FIRST_NAME)
  private String firstName;

  public static final String SERIALIZED_NAME_LAST_NAME = "last_name";
  /**
   * Last name.
  **/
  @SerializedName(SERIALIZED_NAME_LAST_NAME)
  private String lastName;

  public static final String SERIALIZED_NAME_MIDDLE_NAME = "middle_name";
  /**
   * Middle name.
  **/
  @SerializedName(SERIALIZED_NAME_MIDDLE_NAME)
  private String middleName;

  public static final String SERIALIZED_NAME_SUFFIX = "suffix";
  /**
   * Name suffix.
  **/
  @SerializedName(SERIALIZED_NAME_SUFFIX)
  private String suffix;

  public static final String SERIALIZED_NAME_PREFIX = "prefix";
  /**
   * Name prefix.
  **/
  @SerializedName(SERIALIZED_NAME_PREFIX)
  private String prefix;

  public WhatsappMessageContactName() { 
  }

  public WhatsappMessageContactName formattedName(String formattedName) {
    
    this.formattedName = formattedName;
    return this;
  }

   /**
   * Full name, as it normally appears.
   * @return formattedName
  **/
  @javax.annotation.Nonnull

  public String getFormattedName() {
    return formattedName;
  }


  /**
   * Full name, as it normally appears.
   **/
  @ApiModelProperty(required = true, value = "Full name, as it normally appears.")
  public void setFormattedName(String formattedName) {
    this.formattedName = formattedName;
  }


  public WhatsappMessageContactName firstName(String firstName) {
    
    this.firstName = firstName;
    return this;
  }

   /**
   * First name.
   * @return firstName
  **/
  @javax.annotation.Nullable

  public String getFirstName() {
    return firstName;
  }


  /**
   * First name.
   **/
  @ApiModelProperty(value = "First name.")
  public void setFirstName(String firstName) {
    this.firstName = firstName;
  }


  public WhatsappMessageContactName lastName(String lastName) {
    
    this.lastName = lastName;
    return this;
  }

   /**
   * Last name.
   * @return lastName
  **/
  @javax.annotation.Nullable

  public String getLastName() {
    return lastName;
  }


  /**
   * Last name.
   **/
  @ApiModelProperty(value = "Last name.")
  public void setLastName(String lastName) {
    this.lastName = lastName;
  }


  public WhatsappMessageContactName middleName(String middleName) {
    
    this.middleName = middleName;
    return this;
  }

   /**
   * Middle name.
   * @return middleName
  **/
  @javax.annotation.Nullable

  public String getMiddleName() {
    return middleName;
  }


  /**
   * Middle name.
   **/
  @ApiModelProperty(value = "Middle name.")
  public void setMiddleName(String middleName) {
    this.middleName = middleName;
  }


  public WhatsappMessageContactName suffix(String suffix) {
    
    this.suffix = suffix;
    return this;
  }

   /**
   * Name suffix.
   * @return suffix
  **/
  @javax.annotation.Nullable

  public String getSuffix() {
    return suffix;
  }


  /**
   * Name suffix.
   **/
  @ApiModelProperty(value = "Name suffix.")
  public void setSuffix(String suffix) {
    this.suffix = suffix;
  }


  public WhatsappMessageContactName prefix(String prefix) {
    
    this.prefix = prefix;
    return this;
  }

   /**
   * Name prefix.
   * @return prefix
  **/
  @javax.annotation.Nullable

  public String getPrefix() {
    return prefix;
  }


  /**
   * Name prefix.
   **/
  @ApiModelProperty(value = "Name prefix.")
  public void setPrefix(String prefix) {
    this.prefix = prefix;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public WhatsappMessageContactName putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsappMessageContactName whatsappMessageContactName = (WhatsappMessageContactName) o;
    return Objects.equals(this.formattedName, whatsappMessageContactName.formattedName) &&
        Objects.equals(this.firstName, whatsappMessageContactName.firstName) &&
        Objects.equals(this.lastName, whatsappMessageContactName.lastName) &&
        Objects.equals(this.middleName, whatsappMessageContactName.middleName) &&
        Objects.equals(this.suffix, whatsappMessageContactName.suffix) &&
        Objects.equals(this.prefix, whatsappMessageContactName.prefix)&&
        Objects.equals(this.additionalProperties, whatsappMessageContactName.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(formattedName, firstName, lastName, middleName, suffix, prefix, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsappMessageContactName {\n");
    sb.append("    formattedName: ").append(toIndentedString(formattedName)).append("\n");
    sb.append("    firstName: ").append(toIndentedString(firstName)).append("\n");
    sb.append("    lastName: ").append(toIndentedString(lastName)).append("\n");
    sb.append("    middleName: ").append(toIndentedString(middleName)).append("\n");
    sb.append("    suffix: ").append(toIndentedString(suffix)).append("\n");
    sb.append("    prefix: ").append(toIndentedString(prefix)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("formatted_name");
    openapiFields.add("first_name");
    openapiFields.add("last_name");
    openapiFields.add("middle_name");
    openapiFields.add("suffix");
    openapiFields.add("prefix");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("formatted_name");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to WhatsappMessageContactName
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (WhatsappMessageContactName.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappMessageContactName is not found in the empty JSON string", WhatsappMessageContactName.openapiRequiredFields.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : WhatsappMessageContactName.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (jsonObj.get("formatted_name") != null && !jsonObj.get("formatted_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `formatted_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("formatted_name").toString()));
      }
      if (jsonObj.get("first_name") != null && !jsonObj.get("first_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `first_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("first_name").toString()));
      }
      if (jsonObj.get("last_name") != null && !jsonObj.get("last_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `last_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("last_name").toString()));
      }
      if (jsonObj.get("middle_name") != null && !jsonObj.get("middle_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `middle_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("middle_name").toString()));
      }
      if (jsonObj.get("suffix") != null && !jsonObj.get("suffix").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `suffix` to be a primitive type in the JSON string but got `%s`", jsonObj.get("suffix").toString()));
      }
      if (jsonObj.get("prefix") != null && !jsonObj.get("prefix").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `prefix` to be a primitive type in the JSON string but got `%s`", jsonObj.get("prefix").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!WhatsappMessageContactName.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'WhatsappMessageContactName' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<WhatsappMessageContactName> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(WhatsappMessageContactName.class));

       return (TypeAdapter<T>) new TypeAdapter<WhatsappMessageContactName>() {
           @Override
           public void write(JsonWriter out, WhatsappMessageContactName value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public WhatsappMessageContactName read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             WhatsappMessageContactName instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of WhatsappMessageContactName given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of WhatsappMessageContactName
  * @throws IOException if the JSON string is invalid with respect to WhatsappMessageContactName
  */
  public static WhatsappMessageContactName fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, WhatsappMessageContactName.class);
  }

 /**
  * Convert an instance of WhatsappMessageContactName to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

