/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.model.WhatsappMessageInteractiveActionParametersFlowActionPayload;
import com.ycloud.client.model.WhatsappMessageOrderAmount;
import com.ycloud.client.model.WhatsappMessageOrderBeneficiary;
import com.ycloud.client.model.WhatsappMessageOrderInfo;
import com.ycloud.client.model.WhatsappMessageOrderPaymentSetting;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * Action parameters. Required for Call-To-Action (CTA) buttons.
 */
@ApiModel(description = "Action parameters. Required for Call-To-Action (CTA) buttons.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class WhatsappMessageInteractiveActionParameters {
  public static final String SERIALIZED_NAME_DISPLAY_TEXT = "display_text";
  /**
   * Text of the CTA URL button. Maximum length: 20 bytes.
  **/
  @SerializedName(SERIALIZED_NAME_DISPLAY_TEXT)
  private String displayText;

  public static final String SERIALIZED_NAME_URL = "url";
  /**
   * URL of the CTA URL button.
  **/
  @SerializedName(SERIALIZED_NAME_URL)
  private String url;

  public static final String SERIALIZED_NAME_THUMBNAIL_PRODUCT_RETAILER_ID = "thumbnail_product_retailer_id";
  /**
   * Item SKU number. Labeled as **Content ID** in the [Commerce Manager](https://business.facebook.com/commerce). The thumbnail of this item will be used as the message&#39;s header image.
  **/
  @SerializedName(SERIALIZED_NAME_THUMBNAIL_PRODUCT_RETAILER_ID)
  private String thumbnailProductRetailerId;

  public static final String SERIALIZED_NAME_FLOW_MESSAGE_VERSION = "flow_message_version";
  /**
   * Use for &#x60;flow&#x60; buttons. Value must be \&quot;3\&quot;.
  **/
  @SerializedName(SERIALIZED_NAME_FLOW_MESSAGE_VERSION)
  private String flowMessageVersion;

  public static final String SERIALIZED_NAME_FLOW_TOKEN = "flow_token";
  /**
   * Use for &#x60;flow&#x60; buttons. Flow token that is generated by the business to serve as an identifier. Defaults to &#x60;unused&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_FLOW_TOKEN)
  private String flowToken;

  public static final String SERIALIZED_NAME_FLOW_ID = "flow_id";
  /**
   * Required for &#x60;flow&#x60; buttons. Unique ID of the Flow provided by WhatsApp.
  **/
  @SerializedName(SERIALIZED_NAME_FLOW_ID)
  private String flowId;

  public static final String SERIALIZED_NAME_FLOW_CTA = "flow_cta";
  /**
   * Required for &#x60;flow&#x60; buttons. Text on the CTA button. For example: \&quot;Open flow!\&quot;. Maximum length: 20 characters.
  **/
  @SerializedName(SERIALIZED_NAME_FLOW_CTA)
  private String flowCta;

  public static final String SERIALIZED_NAME_FLOW_ACTION = "flow_action";
  /**
   * Use for &#x60;flow&#x60; buttons. Either &#x60;navigate&#x60; or &#x60;data_exchange&#x60;. Defaults to &#x60;navigate&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_FLOW_ACTION)
  private String flowAction;

  public static final String SERIALIZED_NAME_FLOW_ACTION_PAYLOAD = "flow_action_payload";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_FLOW_ACTION_PAYLOAD)
  private WhatsappMessageInteractiveActionParametersFlowActionPayload flowActionPayload;

  public static final String SERIALIZED_NAME_REFERENCE_ID = "reference_id";
  /**
   * Required for &#x60;review_and_pay&#x60; buttons. Unique identifier for the order provided by the business. It is case sensitive and cannot be an empty string and can only contain English letters, numbers, underscores, dashes, or dots, and should not exceed 35 characters.  The &#x60;reference_id&#x60; must be unique for each order_details message for a given business. If there is a need to send multiple order_details messages for the same order, it is recommended to include a sequence number in the reference_id (for example, \&quot;BM345A-12\&quot;) to ensure reference_id uniqueness.
  **/
  @SerializedName(SERIALIZED_NAME_REFERENCE_ID)
  private String referenceId;

  public static final String SERIALIZED_NAME_TYPE = "type";
  /**
   * Required for &#x60;review_and_pay&#x60; buttons. The type of goods being paid for in this order. Current supported options are &#x60;digital-goods&#x60; and &#x60;physical-goods&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public static final String SERIALIZED_NAME_BENEFICIARIES = "beneficiaries";
  /**
   * Required for &#x60;review_and_pay&#x60; buttons. An array of beneficiaries for this order. A beneficiary is an intended recipient for shipping the physical goods in the order. Beneficiary information isn&#39;t shown to users but is needed for legal and compliance reasons.
  **/
  @SerializedName(SERIALIZED_NAME_BENEFICIARIES)
  private List<WhatsappMessageOrderBeneficiary> beneficiaries = null;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  /**
   * Required for &#x60;review_and_pay&#x60; buttons. The currency for this order. Currently the only supported value is &#x60;INR&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private String currency;

  public static final String SERIALIZED_NAME_TOTAL_AMOUNT = "total_amount";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_TOTAL_AMOUNT)
  private WhatsappMessageOrderAmount totalAmount;

  public static final String SERIALIZED_NAME_ORDER = "order";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_ORDER)
  private WhatsappMessageOrderInfo order;

  public static final String SERIALIZED_NAME_PAYMENT_SETTINGS = "payment_settings";
  /**
   * Required for &#x60;review_and_pay&#x60; buttons. Payment settings for the order.
  **/
  @SerializedName(SERIALIZED_NAME_PAYMENT_SETTINGS)
  private List<WhatsappMessageOrderPaymentSetting> paymentSettings = null;

  public WhatsappMessageInteractiveActionParameters() { 
  }

  public WhatsappMessageInteractiveActionParameters displayText(String displayText) {
    
    this.displayText = displayText;
    return this;
  }

   /**
   * Text of the CTA URL button. Maximum length: 20 bytes.
   * @return displayText
  **/
  @javax.annotation.Nullable

  public String getDisplayText() {
    return displayText;
  }


  /**
   * Text of the CTA URL button. Maximum length: 20 bytes.
   **/
  @ApiModelProperty(example = "See Docs", value = "Text of the CTA URL button. Maximum length: 20 bytes.")
  public void setDisplayText(String displayText) {
    this.displayText = displayText;
  }


  public WhatsappMessageInteractiveActionParameters url(String url) {
    
    this.url = url;
    return this;
  }

   /**
   * URL of the CTA URL button.
   * @return url
  **/
  @javax.annotation.Nullable

  public String getUrl() {
    return url;
  }


  /**
   * URL of the CTA URL button.
   **/
  @ApiModelProperty(example = "https://developers.facebook.com/docs/whatsapp", value = "URL of the CTA URL button.")
  public void setUrl(String url) {
    this.url = url;
  }


  public WhatsappMessageInteractiveActionParameters thumbnailProductRetailerId(String thumbnailProductRetailerId) {
    
    this.thumbnailProductRetailerId = thumbnailProductRetailerId;
    return this;
  }

   /**
   * Item SKU number. Labeled as **Content ID** in the [Commerce Manager](https://business.facebook.com/commerce). The thumbnail of this item will be used as the message&#39;s header image.
   * @return thumbnailProductRetailerId
  **/
  @javax.annotation.Nullable

  public String getThumbnailProductRetailerId() {
    return thumbnailProductRetailerId;
  }


  /**
   * Item SKU number. Labeled as **Content ID** in the [Commerce Manager](https://business.facebook.com/commerce). The thumbnail of this item will be used as the message&#39;s header image.
   **/
  @ApiModelProperty(value = "Item SKU number. Labeled as **Content ID** in the [Commerce Manager](https://business.facebook.com/commerce). The thumbnail of this item will be used as the message's header image.")
  public void setThumbnailProductRetailerId(String thumbnailProductRetailerId) {
    this.thumbnailProductRetailerId = thumbnailProductRetailerId;
  }


  public WhatsappMessageInteractiveActionParameters flowMessageVersion(String flowMessageVersion) {
    
    this.flowMessageVersion = flowMessageVersion;
    return this;
  }

   /**
   * Use for &#x60;flow&#x60; buttons. Value must be \&quot;3\&quot;.
   * @return flowMessageVersion
  **/
  @javax.annotation.Nullable

  public String getFlowMessageVersion() {
    return flowMessageVersion;
  }


  /**
   * Use for &#x60;flow&#x60; buttons. Value must be \&quot;3\&quot;.
   **/
  @ApiModelProperty(value = "Use for `flow` buttons. Value must be \"3\".")
  public void setFlowMessageVersion(String flowMessageVersion) {
    this.flowMessageVersion = flowMessageVersion;
  }


  public WhatsappMessageInteractiveActionParameters flowToken(String flowToken) {
    
    this.flowToken = flowToken;
    return this;
  }

   /**
   * Use for &#x60;flow&#x60; buttons. Flow token that is generated by the business to serve as an identifier. Defaults to &#x60;unused&#x60;.
   * @return flowToken
  **/
  @javax.annotation.Nullable

  public String getFlowToken() {
    return flowToken;
  }


  /**
   * Use for &#x60;flow&#x60; buttons. Flow token that is generated by the business to serve as an identifier. Defaults to &#x60;unused&#x60;.
   **/
  @ApiModelProperty(value = "Use for `flow` buttons. Flow token that is generated by the business to serve as an identifier. Defaults to `unused`.")
  public void setFlowToken(String flowToken) {
    this.flowToken = flowToken;
  }


  public WhatsappMessageInteractiveActionParameters flowId(String flowId) {
    
    this.flowId = flowId;
    return this;
  }

   /**
   * Required for &#x60;flow&#x60; buttons. Unique ID of the Flow provided by WhatsApp.
   * @return flowId
  **/
  @javax.annotation.Nullable

  public String getFlowId() {
    return flowId;
  }


  /**
   * Required for &#x60;flow&#x60; buttons. Unique ID of the Flow provided by WhatsApp.
   **/
  @ApiModelProperty(value = "Required for `flow` buttons. Unique ID of the Flow provided by WhatsApp.")
  public void setFlowId(String flowId) {
    this.flowId = flowId;
  }


  public WhatsappMessageInteractiveActionParameters flowCta(String flowCta) {
    
    this.flowCta = flowCta;
    return this;
  }

   /**
   * Required for &#x60;flow&#x60; buttons. Text on the CTA button. For example: \&quot;Open flow!\&quot;. Maximum length: 20 characters.
   * @return flowCta
  **/
  @javax.annotation.Nullable

  public String getFlowCta() {
    return flowCta;
  }


  /**
   * Required for &#x60;flow&#x60; buttons. Text on the CTA button. For example: \&quot;Open flow!\&quot;. Maximum length: 20 characters.
   **/
  @ApiModelProperty(example = "Open flow!", value = "Required for `flow` buttons. Text on the CTA button. For example: \"Open flow!\". Maximum length: 20 characters.")
  public void setFlowCta(String flowCta) {
    this.flowCta = flowCta;
  }


  public WhatsappMessageInteractiveActionParameters flowAction(String flowAction) {
    
    this.flowAction = flowAction;
    return this;
  }

   /**
   * Use for &#x60;flow&#x60; buttons. Either &#x60;navigate&#x60; or &#x60;data_exchange&#x60;. Defaults to &#x60;navigate&#x60;.
   * @return flowAction
  **/
  @javax.annotation.Nullable

  public String getFlowAction() {
    return flowAction;
  }


  /**
   * Use for &#x60;flow&#x60; buttons. Either &#x60;navigate&#x60; or &#x60;data_exchange&#x60;. Defaults to &#x60;navigate&#x60;.
   **/
  @ApiModelProperty(example = "navigate", value = "Use for `flow` buttons. Either `navigate` or `data_exchange`. Defaults to `navigate`.")
  public void setFlowAction(String flowAction) {
    this.flowAction = flowAction;
  }


  public WhatsappMessageInteractiveActionParameters flowActionPayload(WhatsappMessageInteractiveActionParametersFlowActionPayload flowActionPayload) {
    
    this.flowActionPayload = flowActionPayload;
    return this;
  }

   /**
   * Get flowActionPayload
   * @return flowActionPayload
  **/
  @javax.annotation.Nullable

  public WhatsappMessageInteractiveActionParametersFlowActionPayload getFlowActionPayload() {
    return flowActionPayload;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setFlowActionPayload(WhatsappMessageInteractiveActionParametersFlowActionPayload flowActionPayload) {
    this.flowActionPayload = flowActionPayload;
  }


  public WhatsappMessageInteractiveActionParameters referenceId(String referenceId) {
    
    this.referenceId = referenceId;
    return this;
  }

   /**
   * Required for &#x60;review_and_pay&#x60; buttons. Unique identifier for the order provided by the business. It is case sensitive and cannot be an empty string and can only contain English letters, numbers, underscores, dashes, or dots, and should not exceed 35 characters.  The &#x60;reference_id&#x60; must be unique for each order_details message for a given business. If there is a need to send multiple order_details messages for the same order, it is recommended to include a sequence number in the reference_id (for example, \&quot;BM345A-12\&quot;) to ensure reference_id uniqueness.
   * @return referenceId
  **/
  @javax.annotation.Nullable

  public String getReferenceId() {
    return referenceId;
  }


  /**
   * Required for &#x60;review_and_pay&#x60; buttons. Unique identifier for the order provided by the business. It is case sensitive and cannot be an empty string and can only contain English letters, numbers, underscores, dashes, or dots, and should not exceed 35 characters.  The &#x60;reference_id&#x60; must be unique for each order_details message for a given business. If there is a need to send multiple order_details messages for the same order, it is recommended to include a sequence number in the reference_id (for example, \&quot;BM345A-12\&quot;) to ensure reference_id uniqueness.
   **/
  @ApiModelProperty(value = "Required for `review_and_pay` buttons. Unique identifier for the order provided by the business. It is case sensitive and cannot be an empty string and can only contain English letters, numbers, underscores, dashes, or dots, and should not exceed 35 characters.  The `reference_id` must be unique for each order_details message for a given business. If there is a need to send multiple order_details messages for the same order, it is recommended to include a sequence number in the reference_id (for example, \"BM345A-12\") to ensure reference_id uniqueness.")
  public void setReferenceId(String referenceId) {
    this.referenceId = referenceId;
  }


  public WhatsappMessageInteractiveActionParameters type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Required for &#x60;review_and_pay&#x60; buttons. The type of goods being paid for in this order. Current supported options are &#x60;digital-goods&#x60; and &#x60;physical-goods&#x60;.
   * @return type
  **/
  @javax.annotation.Nullable

  public String getType() {
    return type;
  }


  /**
   * Required for &#x60;review_and_pay&#x60; buttons. The type of goods being paid for in this order. Current supported options are &#x60;digital-goods&#x60; and &#x60;physical-goods&#x60;.
   **/
  @ApiModelProperty(value = "Required for `review_and_pay` buttons. The type of goods being paid for in this order. Current supported options are `digital-goods` and `physical-goods`.")
  public void setType(String type) {
    this.type = type;
  }


  public WhatsappMessageInteractiveActionParameters beneficiaries(List<WhatsappMessageOrderBeneficiary> beneficiaries) {
    
    this.beneficiaries = beneficiaries;
    return this;
  }

  public WhatsappMessageInteractiveActionParameters addBeneficiariesItem(WhatsappMessageOrderBeneficiary beneficiariesItem) {
    if (this.beneficiaries == null) {
      this.beneficiaries = new ArrayList<>();
    }
    this.beneficiaries.add(beneficiariesItem);
    return this;
  }

   /**
   * Required for &#x60;review_and_pay&#x60; buttons. An array of beneficiaries for this order. A beneficiary is an intended recipient for shipping the physical goods in the order. Beneficiary information isn&#39;t shown to users but is needed for legal and compliance reasons.
   * @return beneficiaries
  **/
  @javax.annotation.Nullable

  public List<WhatsappMessageOrderBeneficiary> getBeneficiaries() {
    return beneficiaries;
  }


  /**
   * Required for &#x60;review_and_pay&#x60; buttons. An array of beneficiaries for this order. A beneficiary is an intended recipient for shipping the physical goods in the order. Beneficiary information isn&#39;t shown to users but is needed for legal and compliance reasons.
   **/
  @ApiModelProperty(value = "Required for `review_and_pay` buttons. An array of beneficiaries for this order. A beneficiary is an intended recipient for shipping the physical goods in the order. Beneficiary information isn't shown to users but is needed for legal and compliance reasons.")
  public void setBeneficiaries(List<WhatsappMessageOrderBeneficiary> beneficiaries) {
    this.beneficiaries = beneficiaries;
  }


  public WhatsappMessageInteractiveActionParameters currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * Required for &#x60;review_and_pay&#x60; buttons. The currency for this order. Currently the only supported value is &#x60;INR&#x60;.
   * @return currency
  **/
  @javax.annotation.Nullable

  public String getCurrency() {
    return currency;
  }


  /**
   * Required for &#x60;review_and_pay&#x60; buttons. The currency for this order. Currently the only supported value is &#x60;INR&#x60;.
   **/
  @ApiModelProperty(value = "Required for `review_and_pay` buttons. The currency for this order. Currently the only supported value is `INR`.")
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public WhatsappMessageInteractiveActionParameters totalAmount(WhatsappMessageOrderAmount totalAmount) {
    
    this.totalAmount = totalAmount;
    return this;
  }

   /**
   * Get totalAmount
   * @return totalAmount
  **/
  @javax.annotation.Nullable

  public WhatsappMessageOrderAmount getTotalAmount() {
    return totalAmount;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setTotalAmount(WhatsappMessageOrderAmount totalAmount) {
    this.totalAmount = totalAmount;
  }


  public WhatsappMessageInteractiveActionParameters order(WhatsappMessageOrderInfo order) {
    
    this.order = order;
    return this;
  }

   /**
   * Get order
   * @return order
  **/
  @javax.annotation.Nullable

  public WhatsappMessageOrderInfo getOrder() {
    return order;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setOrder(WhatsappMessageOrderInfo order) {
    this.order = order;
  }


  public WhatsappMessageInteractiveActionParameters paymentSettings(List<WhatsappMessageOrderPaymentSetting> paymentSettings) {
    
    this.paymentSettings = paymentSettings;
    return this;
  }

  public WhatsappMessageInteractiveActionParameters addPaymentSettingsItem(WhatsappMessageOrderPaymentSetting paymentSettingsItem) {
    if (this.paymentSettings == null) {
      this.paymentSettings = new ArrayList<>();
    }
    this.paymentSettings.add(paymentSettingsItem);
    return this;
  }

   /**
   * Required for &#x60;review_and_pay&#x60; buttons. Payment settings for the order.
   * @return paymentSettings
  **/
  @javax.annotation.Nullable

  public List<WhatsappMessageOrderPaymentSetting> getPaymentSettings() {
    return paymentSettings;
  }


  /**
   * Required for &#x60;review_and_pay&#x60; buttons. Payment settings for the order.
   **/
  @ApiModelProperty(value = "Required for `review_and_pay` buttons. Payment settings for the order.")
  public void setPaymentSettings(List<WhatsappMessageOrderPaymentSetting> paymentSettings) {
    this.paymentSettings = paymentSettings;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public WhatsappMessageInteractiveActionParameters putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsappMessageInteractiveActionParameters whatsappMessageInteractiveActionParameters = (WhatsappMessageInteractiveActionParameters) o;
    return Objects.equals(this.displayText, whatsappMessageInteractiveActionParameters.displayText) &&
        Objects.equals(this.url, whatsappMessageInteractiveActionParameters.url) &&
        Objects.equals(this.thumbnailProductRetailerId, whatsappMessageInteractiveActionParameters.thumbnailProductRetailerId) &&
        Objects.equals(this.flowMessageVersion, whatsappMessageInteractiveActionParameters.flowMessageVersion) &&
        Objects.equals(this.flowToken, whatsappMessageInteractiveActionParameters.flowToken) &&
        Objects.equals(this.flowId, whatsappMessageInteractiveActionParameters.flowId) &&
        Objects.equals(this.flowCta, whatsappMessageInteractiveActionParameters.flowCta) &&
        Objects.equals(this.flowAction, whatsappMessageInteractiveActionParameters.flowAction) &&
        Objects.equals(this.flowActionPayload, whatsappMessageInteractiveActionParameters.flowActionPayload) &&
        Objects.equals(this.referenceId, whatsappMessageInteractiveActionParameters.referenceId) &&
        Objects.equals(this.type, whatsappMessageInteractiveActionParameters.type) &&
        Objects.equals(this.beneficiaries, whatsappMessageInteractiveActionParameters.beneficiaries) &&
        Objects.equals(this.currency, whatsappMessageInteractiveActionParameters.currency) &&
        Objects.equals(this.totalAmount, whatsappMessageInteractiveActionParameters.totalAmount) &&
        Objects.equals(this.order, whatsappMessageInteractiveActionParameters.order) &&
        Objects.equals(this.paymentSettings, whatsappMessageInteractiveActionParameters.paymentSettings)&&
        Objects.equals(this.additionalProperties, whatsappMessageInteractiveActionParameters.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(displayText, url, thumbnailProductRetailerId, flowMessageVersion, flowToken, flowId, flowCta, flowAction, flowActionPayload, referenceId, type, beneficiaries, currency, totalAmount, order, paymentSettings, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsappMessageInteractiveActionParameters {\n");
    sb.append("    displayText: ").append(toIndentedString(displayText)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    thumbnailProductRetailerId: ").append(toIndentedString(thumbnailProductRetailerId)).append("\n");
    sb.append("    flowMessageVersion: ").append(toIndentedString(flowMessageVersion)).append("\n");
    sb.append("    flowToken: ").append(toIndentedString(flowToken)).append("\n");
    sb.append("    flowId: ").append(toIndentedString(flowId)).append("\n");
    sb.append("    flowCta: ").append(toIndentedString(flowCta)).append("\n");
    sb.append("    flowAction: ").append(toIndentedString(flowAction)).append("\n");
    sb.append("    flowActionPayload: ").append(toIndentedString(flowActionPayload)).append("\n");
    sb.append("    referenceId: ").append(toIndentedString(referenceId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    beneficiaries: ").append(toIndentedString(beneficiaries)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    totalAmount: ").append(toIndentedString(totalAmount)).append("\n");
    sb.append("    order: ").append(toIndentedString(order)).append("\n");
    sb.append("    paymentSettings: ").append(toIndentedString(paymentSettings)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("display_text");
    openapiFields.add("url");
    openapiFields.add("thumbnail_product_retailer_id");
    openapiFields.add("flow_message_version");
    openapiFields.add("flow_token");
    openapiFields.add("flow_id");
    openapiFields.add("flow_cta");
    openapiFields.add("flow_action");
    openapiFields.add("flow_action_payload");
    openapiFields.add("reference_id");
    openapiFields.add("type");
    openapiFields.add("beneficiaries");
    openapiFields.add("currency");
    openapiFields.add("total_amount");
    openapiFields.add("order");
    openapiFields.add("payment_settings");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to WhatsappMessageInteractiveActionParameters
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (WhatsappMessageInteractiveActionParameters.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappMessageInteractiveActionParameters is not found in the empty JSON string", WhatsappMessageInteractiveActionParameters.openapiRequiredFields.toString()));
        }
      }
      if (jsonObj.get("display_text") != null && !jsonObj.get("display_text").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `display_text` to be a primitive type in the JSON string but got `%s`", jsonObj.get("display_text").toString()));
      }
      if (jsonObj.get("url") != null && !jsonObj.get("url").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get("url").toString()));
      }
      if (jsonObj.get("thumbnail_product_retailer_id") != null && !jsonObj.get("thumbnail_product_retailer_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `thumbnail_product_retailer_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("thumbnail_product_retailer_id").toString()));
      }
      if (jsonObj.get("flow_message_version") != null && !jsonObj.get("flow_message_version").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `flow_message_version` to be a primitive type in the JSON string but got `%s`", jsonObj.get("flow_message_version").toString()));
      }
      if (jsonObj.get("flow_token") != null && !jsonObj.get("flow_token").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `flow_token` to be a primitive type in the JSON string but got `%s`", jsonObj.get("flow_token").toString()));
      }
      if (jsonObj.get("flow_id") != null && !jsonObj.get("flow_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `flow_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("flow_id").toString()));
      }
      if (jsonObj.get("flow_cta") != null && !jsonObj.get("flow_cta").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `flow_cta` to be a primitive type in the JSON string but got `%s`", jsonObj.get("flow_cta").toString()));
      }
      if (jsonObj.get("flow_action") != null && !jsonObj.get("flow_action").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `flow_action` to be a primitive type in the JSON string but got `%s`", jsonObj.get("flow_action").toString()));
      }
      // validate the optional field `flow_action_payload`
      if (jsonObj.getAsJsonObject("flow_action_payload") != null) {
        WhatsappMessageInteractiveActionParametersFlowActionPayload.validateJsonObject(jsonObj.getAsJsonObject("flow_action_payload"));
      }
      if (jsonObj.get("reference_id") != null && !jsonObj.get("reference_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `reference_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("reference_id").toString()));
      }
      if (jsonObj.get("type") != null && !jsonObj.get("type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
      }
      JsonArray jsonArraybeneficiaries = jsonObj.getAsJsonArray("beneficiaries");
      if (jsonArraybeneficiaries != null) {
        // ensure the json data is an array
        if (!jsonObj.get("beneficiaries").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `beneficiaries` to be an array in the JSON string but got `%s`", jsonObj.get("beneficiaries").toString()));
        }

        // validate the optional field `beneficiaries` (array)
        for (int i = 0; i < jsonArraybeneficiaries.size(); i++) {
          WhatsappMessageOrderBeneficiary.validateJsonObject(jsonArraybeneficiaries.get(i).getAsJsonObject());
        };
      }
      if (jsonObj.get("currency") != null && !jsonObj.get("currency").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("currency").toString()));
      }
      // validate the optional field `total_amount`
      if (jsonObj.getAsJsonObject("total_amount") != null) {
        WhatsappMessageOrderAmount.validateJsonObject(jsonObj.getAsJsonObject("total_amount"));
      }
      // validate the optional field `order`
      if (jsonObj.getAsJsonObject("order") != null) {
        WhatsappMessageOrderInfo.validateJsonObject(jsonObj.getAsJsonObject("order"));
      }
      JsonArray jsonArraypaymentSettings = jsonObj.getAsJsonArray("payment_settings");
      if (jsonArraypaymentSettings != null) {
        // ensure the json data is an array
        if (!jsonObj.get("payment_settings").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `payment_settings` to be an array in the JSON string but got `%s`", jsonObj.get("payment_settings").toString()));
        }

        // validate the optional field `payment_settings` (array)
        for (int i = 0; i < jsonArraypaymentSettings.size(); i++) {
          WhatsappMessageOrderPaymentSetting.validateJsonObject(jsonArraypaymentSettings.get(i).getAsJsonObject());
        };
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!WhatsappMessageInteractiveActionParameters.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'WhatsappMessageInteractiveActionParameters' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<WhatsappMessageInteractiveActionParameters> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(WhatsappMessageInteractiveActionParameters.class));

       return (TypeAdapter<T>) new TypeAdapter<WhatsappMessageInteractiveActionParameters>() {
           @Override
           public void write(JsonWriter out, WhatsappMessageInteractiveActionParameters value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public WhatsappMessageInteractiveActionParameters read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             WhatsappMessageInteractiveActionParameters instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of WhatsappMessageInteractiveActionParameters given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of WhatsappMessageInteractiveActionParameters
  * @throws IOException if the JSON string is invalid with respect to WhatsappMessageInteractiveActionParameters
  */
  public static WhatsappMessageInteractiveActionParameters fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, WhatsappMessageInteractiveActionParameters.class);
  }

 /**
  * Convert an instance of WhatsappMessageInteractiveActionParameters to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

