/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * Represents the amount of an order.
 */
@ApiModel(description = "Represents the amount of an order.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class WhatsappMessageOrderAmount {
  public static final String SERIALIZED_NAME_OFFSET = "offset";
  /**
   * Must be &#x60;100&#x60; for &#x60;INR&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_OFFSET)
  private Integer offset;

  public static final String SERIALIZED_NAME_VALUE = "value";
  /**
   * Positive integer representing the amount value multiplied by offset.  For example, ₹12.34 has value 1234.
  **/
  @SerializedName(SERIALIZED_NAME_VALUE)
  private Integer value;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  /**
   * Use only for &#x60;tax&#x60;, &#x60;shipping&#x60;, or &#x60;discount&#x60;. Description of the amount. Max character limit is 60 characters.
  **/
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public static final String SERIALIZED_NAME_DISCOUNT_PROGRAM_NAME = "discount_program_name";
  /**
   * Use only for &#x60;discount&#x60;. Text used for defining incentivised orders. If order is incentivised, the merchant needs to define this information. Max character limit is 60 characters.
  **/
  @SerializedName(SERIALIZED_NAME_DISCOUNT_PROGRAM_NAME)
  private String discountProgramName;

  public WhatsappMessageOrderAmount() { 
  }

  public WhatsappMessageOrderAmount offset(Integer offset) {
    
    this.offset = offset;
    return this;
  }

   /**
   * Must be &#x60;100&#x60; for &#x60;INR&#x60;.
   * @return offset
  **/
  @javax.annotation.Nonnull

  public Integer getOffset() {
    return offset;
  }


  /**
   * Must be &#x60;100&#x60; for &#x60;INR&#x60;.
   **/
  @ApiModelProperty(example = "100", required = true, value = "Must be `100` for `INR`.")
  public void setOffset(Integer offset) {
    this.offset = offset;
  }


  public WhatsappMessageOrderAmount value(Integer value) {
    
    this.value = value;
    return this;
  }

   /**
   * Positive integer representing the amount value multiplied by offset.  For example, ₹12.34 has value 1234.
   * @return value
  **/
  @javax.annotation.Nonnull

  public Integer getValue() {
    return value;
  }


  /**
   * Positive integer representing the amount value multiplied by offset.  For example, ₹12.34 has value 1234.
   **/
  @ApiModelProperty(example = "1234", required = true, value = "Positive integer representing the amount value multiplied by offset.  For example, ₹12.34 has value 1234.")
  public void setValue(Integer value) {
    this.value = value;
  }


  public WhatsappMessageOrderAmount description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * Use only for &#x60;tax&#x60;, &#x60;shipping&#x60;, or &#x60;discount&#x60;. Description of the amount. Max character limit is 60 characters.
   * @return description
  **/
  @javax.annotation.Nullable

  public String getDescription() {
    return description;
  }


  /**
   * Use only for &#x60;tax&#x60;, &#x60;shipping&#x60;, or &#x60;discount&#x60;. Description of the amount. Max character limit is 60 characters.
   **/
  @ApiModelProperty(value = "Use only for `tax`, `shipping`, or `discount`. Description of the amount. Max character limit is 60 characters.")
  public void setDescription(String description) {
    this.description = description;
  }


  public WhatsappMessageOrderAmount discountProgramName(String discountProgramName) {
    
    this.discountProgramName = discountProgramName;
    return this;
  }

   /**
   * Use only for &#x60;discount&#x60;. Text used for defining incentivised orders. If order is incentivised, the merchant needs to define this information. Max character limit is 60 characters.
   * @return discountProgramName
  **/
  @javax.annotation.Nullable

  public String getDiscountProgramName() {
    return discountProgramName;
  }


  /**
   * Use only for &#x60;discount&#x60;. Text used for defining incentivised orders. If order is incentivised, the merchant needs to define this information. Max character limit is 60 characters.
   **/
  @ApiModelProperty(value = "Use only for `discount`. Text used for defining incentivised orders. If order is incentivised, the merchant needs to define this information. Max character limit is 60 characters.")
  public void setDiscountProgramName(String discountProgramName) {
    this.discountProgramName = discountProgramName;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public WhatsappMessageOrderAmount putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsappMessageOrderAmount whatsappMessageOrderAmount = (WhatsappMessageOrderAmount) o;
    return Objects.equals(this.offset, whatsappMessageOrderAmount.offset) &&
        Objects.equals(this.value, whatsappMessageOrderAmount.value) &&
        Objects.equals(this.description, whatsappMessageOrderAmount.description) &&
        Objects.equals(this.discountProgramName, whatsappMessageOrderAmount.discountProgramName)&&
        Objects.equals(this.additionalProperties, whatsappMessageOrderAmount.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(offset, value, description, discountProgramName, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsappMessageOrderAmount {\n");
    sb.append("    offset: ").append(toIndentedString(offset)).append("\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    discountProgramName: ").append(toIndentedString(discountProgramName)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("offset");
    openapiFields.add("value");
    openapiFields.add("description");
    openapiFields.add("discount_program_name");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("offset");
    openapiRequiredFields.add("value");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to WhatsappMessageOrderAmount
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (WhatsappMessageOrderAmount.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappMessageOrderAmount is not found in the empty JSON string", WhatsappMessageOrderAmount.openapiRequiredFields.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : WhatsappMessageOrderAmount.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (jsonObj.get("description") != null && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
      if (jsonObj.get("discount_program_name") != null && !jsonObj.get("discount_program_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `discount_program_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("discount_program_name").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!WhatsappMessageOrderAmount.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'WhatsappMessageOrderAmount' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<WhatsappMessageOrderAmount> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(WhatsappMessageOrderAmount.class));

       return (TypeAdapter<T>) new TypeAdapter<WhatsappMessageOrderAmount>() {
           @Override
           public void write(JsonWriter out, WhatsappMessageOrderAmount value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public WhatsappMessageOrderAmount read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             WhatsappMessageOrderAmount instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of WhatsappMessageOrderAmount given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of WhatsappMessageOrderAmount
  * @throws IOException if the JSON string is invalid with respect to WhatsappMessageOrderAmount
  */
  public static WhatsappMessageOrderAmount fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, WhatsappMessageOrderAmount.class);
  }

 /**
  * Convert an instance of WhatsappMessageOrderAmount to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

