/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.model.WhatsappMessageOrderAmount;
import com.ycloud.client.model.WhatsappMessageOrderExpiration;
import com.ycloud.client.model.WhatsappMessageOrderItem;
import com.ycloud.client.model.WhatsappMessageOrderStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * Order info.
 */
@ApiModel(description = "Order info.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class WhatsappMessageOrderInfo {
  public static final String SERIALIZED_NAME_STATUS = "status";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_STATUS)
  private WhatsappMessageOrderStatusEnum status;

  public static final String SERIALIZED_NAME_TYPE = "type";
  /**
   * Only supported value is &#x60;quick_pay&#x60;. When this field is passed in we hide the \&quot;Review and Pay\&quot; button and only show the \&quot;Pay Now\&quot; button in the order details bubble.
  **/
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public static final String SERIALIZED_NAME_CATALOG_ID = "catalog_id";
  /**
   * Unique identifier of the Facebook catalog being used by the business. If you do not provide this field, you must provide the following fields inside the items object: &#x60;country_of_origin&#x60;, &#x60;importer_name&#x60;, and &#x60;importer_address&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_CATALOG_ID)
  private String catalogId;

  public static final String SERIALIZED_NAME_ITEMS = "items";
  /**
   * Array of items in the order.
  **/
  @SerializedName(SERIALIZED_NAME_ITEMS)
  private List<WhatsappMessageOrderItem> items = null;

  public static final String SERIALIZED_NAME_SUBTOTAL = "subtotal";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_SUBTOTAL)
  private WhatsappMessageOrderAmount subtotal;

  public static final String SERIALIZED_NAME_TAX = "tax";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_TAX)
  private WhatsappMessageOrderAmount tax;

  public static final String SERIALIZED_NAME_SHIPPING = "shipping";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_SHIPPING)
  private WhatsappMessageOrderAmount shipping;

  public static final String SERIALIZED_NAME_DISCOUNT = "discount";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_DISCOUNT)
  private WhatsappMessageOrderAmount discount;

  public static final String SERIALIZED_NAME_EXPIRATION = "expiration";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_EXPIRATION)
  private WhatsappMessageOrderExpiration expiration;

  public static final String SERIALIZED_NAME_DESCRIPTION = "description";
  /**
   * **Optional.** Text for sharing status related information. Could be useful while sending cancellation. Max character limit is 120 characters.
  **/
  @SerializedName(SERIALIZED_NAME_DESCRIPTION)
  private String description;

  public WhatsappMessageOrderInfo() { 
  }

  public WhatsappMessageOrderInfo status(WhatsappMessageOrderStatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * Get status
   * @return status
  **/
  @javax.annotation.Nullable

  public WhatsappMessageOrderStatusEnum getStatus() {
    return status;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setStatus(WhatsappMessageOrderStatusEnum status) {
    this.status = status;
  }


  public WhatsappMessageOrderInfo type(String type) {
    
    this.type = type;
    return this;
  }

   /**
   * Only supported value is &#x60;quick_pay&#x60;. When this field is passed in we hide the \&quot;Review and Pay\&quot; button and only show the \&quot;Pay Now\&quot; button in the order details bubble.
   * @return type
  **/
  @javax.annotation.Nullable

  public String getType() {
    return type;
  }


  /**
   * Only supported value is &#x60;quick_pay&#x60;. When this field is passed in we hide the \&quot;Review and Pay\&quot; button and only show the \&quot;Pay Now\&quot; button in the order details bubble.
   **/
  @ApiModelProperty(value = "Only supported value is `quick_pay`. When this field is passed in we hide the \"Review and Pay\" button and only show the \"Pay Now\" button in the order details bubble.")
  public void setType(String type) {
    this.type = type;
  }


  public WhatsappMessageOrderInfo catalogId(String catalogId) {
    
    this.catalogId = catalogId;
    return this;
  }

   /**
   * Unique identifier of the Facebook catalog being used by the business. If you do not provide this field, you must provide the following fields inside the items object: &#x60;country_of_origin&#x60;, &#x60;importer_name&#x60;, and &#x60;importer_address&#x60;.
   * @return catalogId
  **/
  @javax.annotation.Nullable

  public String getCatalogId() {
    return catalogId;
  }


  /**
   * Unique identifier of the Facebook catalog being used by the business. If you do not provide this field, you must provide the following fields inside the items object: &#x60;country_of_origin&#x60;, &#x60;importer_name&#x60;, and &#x60;importer_address&#x60;.
   **/
  @ApiModelProperty(value = "Unique identifier of the Facebook catalog being used by the business. If you do not provide this field, you must provide the following fields inside the items object: `country_of_origin`, `importer_name`, and `importer_address`.")
  public void setCatalogId(String catalogId) {
    this.catalogId = catalogId;
  }


  public WhatsappMessageOrderInfo items(List<WhatsappMessageOrderItem> items) {
    
    this.items = items;
    return this;
  }

  public WhatsappMessageOrderInfo addItemsItem(WhatsappMessageOrderItem itemsItem) {
    if (this.items == null) {
      this.items = new ArrayList<>();
    }
    this.items.add(itemsItem);
    return this;
  }

   /**
   * Array of items in the order.
   * @return items
  **/
  @javax.annotation.Nullable

  public List<WhatsappMessageOrderItem> getItems() {
    return items;
  }


  /**
   * Array of items in the order.
   **/
  @ApiModelProperty(value = "Array of items in the order.")
  public void setItems(List<WhatsappMessageOrderItem> items) {
    this.items = items;
  }


  public WhatsappMessageOrderInfo subtotal(WhatsappMessageOrderAmount subtotal) {
    
    this.subtotal = subtotal;
    return this;
  }

   /**
   * Get subtotal
   * @return subtotal
  **/
  @javax.annotation.Nullable

  public WhatsappMessageOrderAmount getSubtotal() {
    return subtotal;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setSubtotal(WhatsappMessageOrderAmount subtotal) {
    this.subtotal = subtotal;
  }


  public WhatsappMessageOrderInfo tax(WhatsappMessageOrderAmount tax) {
    
    this.tax = tax;
    return this;
  }

   /**
   * Get tax
   * @return tax
  **/
  @javax.annotation.Nullable

  public WhatsappMessageOrderAmount getTax() {
    return tax;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setTax(WhatsappMessageOrderAmount tax) {
    this.tax = tax;
  }


  public WhatsappMessageOrderInfo shipping(WhatsappMessageOrderAmount shipping) {
    
    this.shipping = shipping;
    return this;
  }

   /**
   * Get shipping
   * @return shipping
  **/
  @javax.annotation.Nullable

  public WhatsappMessageOrderAmount getShipping() {
    return shipping;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setShipping(WhatsappMessageOrderAmount shipping) {
    this.shipping = shipping;
  }


  public WhatsappMessageOrderInfo discount(WhatsappMessageOrderAmount discount) {
    
    this.discount = discount;
    return this;
  }

   /**
   * Get discount
   * @return discount
  **/
  @javax.annotation.Nullable

  public WhatsappMessageOrderAmount getDiscount() {
    return discount;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setDiscount(WhatsappMessageOrderAmount discount) {
    this.discount = discount;
  }


  public WhatsappMessageOrderInfo expiration(WhatsappMessageOrderExpiration expiration) {
    
    this.expiration = expiration;
    return this;
  }

   /**
   * Get expiration
   * @return expiration
  **/
  @javax.annotation.Nullable

  public WhatsappMessageOrderExpiration getExpiration() {
    return expiration;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setExpiration(WhatsappMessageOrderExpiration expiration) {
    this.expiration = expiration;
  }


  public WhatsappMessageOrderInfo description(String description) {
    
    this.description = description;
    return this;
  }

   /**
   * **Optional.** Text for sharing status related information. Could be useful while sending cancellation. Max character limit is 120 characters.
   * @return description
  **/
  @javax.annotation.Nullable

  public String getDescription() {
    return description;
  }


  /**
   * **Optional.** Text for sharing status related information. Could be useful while sending cancellation. Max character limit is 120 characters.
   **/
  @ApiModelProperty(value = "**Optional.** Text for sharing status related information. Could be useful while sending cancellation. Max character limit is 120 characters.")
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public WhatsappMessageOrderInfo putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsappMessageOrderInfo whatsappMessageOrderInfo = (WhatsappMessageOrderInfo) o;
    return Objects.equals(this.status, whatsappMessageOrderInfo.status) &&
        Objects.equals(this.type, whatsappMessageOrderInfo.type) &&
        Objects.equals(this.catalogId, whatsappMessageOrderInfo.catalogId) &&
        Objects.equals(this.items, whatsappMessageOrderInfo.items) &&
        Objects.equals(this.subtotal, whatsappMessageOrderInfo.subtotal) &&
        Objects.equals(this.tax, whatsappMessageOrderInfo.tax) &&
        Objects.equals(this.shipping, whatsappMessageOrderInfo.shipping) &&
        Objects.equals(this.discount, whatsappMessageOrderInfo.discount) &&
        Objects.equals(this.expiration, whatsappMessageOrderInfo.expiration) &&
        Objects.equals(this.description, whatsappMessageOrderInfo.description)&&
        Objects.equals(this.additionalProperties, whatsappMessageOrderInfo.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(status, type, catalogId, items, subtotal, tax, shipping, discount, expiration, description, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsappMessageOrderInfo {\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    catalogId: ").append(toIndentedString(catalogId)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("    subtotal: ").append(toIndentedString(subtotal)).append("\n");
    sb.append("    tax: ").append(toIndentedString(tax)).append("\n");
    sb.append("    shipping: ").append(toIndentedString(shipping)).append("\n");
    sb.append("    discount: ").append(toIndentedString(discount)).append("\n");
    sb.append("    expiration: ").append(toIndentedString(expiration)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("status");
    openapiFields.add("type");
    openapiFields.add("catalog_id");
    openapiFields.add("items");
    openapiFields.add("subtotal");
    openapiFields.add("tax");
    openapiFields.add("shipping");
    openapiFields.add("discount");
    openapiFields.add("expiration");
    openapiFields.add("description");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to WhatsappMessageOrderInfo
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (WhatsappMessageOrderInfo.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappMessageOrderInfo is not found in the empty JSON string", WhatsappMessageOrderInfo.openapiRequiredFields.toString()));
        }
      }
      if (jsonObj.get("type") != null && !jsonObj.get("type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
      }
      if (jsonObj.get("catalog_id") != null && !jsonObj.get("catalog_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `catalog_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("catalog_id").toString()));
      }
      JsonArray jsonArrayitems = jsonObj.getAsJsonArray("items");
      if (jsonArrayitems != null) {
        // ensure the json data is an array
        if (!jsonObj.get("items").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `items` to be an array in the JSON string but got `%s`", jsonObj.get("items").toString()));
        }

        // validate the optional field `items` (array)
        for (int i = 0; i < jsonArrayitems.size(); i++) {
          WhatsappMessageOrderItem.validateJsonObject(jsonArrayitems.get(i).getAsJsonObject());
        };
      }
      // validate the optional field `subtotal`
      if (jsonObj.getAsJsonObject("subtotal") != null) {
        WhatsappMessageOrderAmount.validateJsonObject(jsonObj.getAsJsonObject("subtotal"));
      }
      // validate the optional field `tax`
      if (jsonObj.getAsJsonObject("tax") != null) {
        WhatsappMessageOrderAmount.validateJsonObject(jsonObj.getAsJsonObject("tax"));
      }
      // validate the optional field `shipping`
      if (jsonObj.getAsJsonObject("shipping") != null) {
        WhatsappMessageOrderAmount.validateJsonObject(jsonObj.getAsJsonObject("shipping"));
      }
      // validate the optional field `discount`
      if (jsonObj.getAsJsonObject("discount") != null) {
        WhatsappMessageOrderAmount.validateJsonObject(jsonObj.getAsJsonObject("discount"));
      }
      // validate the optional field `expiration`
      if (jsonObj.getAsJsonObject("expiration") != null) {
        WhatsappMessageOrderExpiration.validateJsonObject(jsonObj.getAsJsonObject("expiration"));
      }
      if (jsonObj.get("description") != null && !jsonObj.get("description").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get("description").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!WhatsappMessageOrderInfo.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'WhatsappMessageOrderInfo' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<WhatsappMessageOrderInfo> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(WhatsappMessageOrderInfo.class));

       return (TypeAdapter<T>) new TypeAdapter<WhatsappMessageOrderInfo>() {
           @Override
           public void write(JsonWriter out, WhatsappMessageOrderInfo value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public WhatsappMessageOrderInfo read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             WhatsappMessageOrderInfo instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of WhatsappMessageOrderInfo given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of WhatsappMessageOrderInfo
  * @throws IOException if the JSON string is invalid with respect to WhatsappMessageOrderInfo
  */
  public static WhatsappMessageOrderInfo fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, WhatsappMessageOrderInfo.class);
  }

 /**
  * Convert an instance of WhatsappMessageOrderInfo to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

