/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import io.swagger.annotations.ApiModel;
import com.google.gson.annotations.SerializedName;

import java.io.IOException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

/**
 * Only supported value in the &#x60;order_details&#x60; message is &#x60;pending&#x60;. In an &#x60;order_status&#x60; message, &#x60;status&#x60; can be: &#x60;pending&#x60;, &#x60;processing&#x60;, &#x60;partially_shipped&#x60;, &#x60;shipped&#x60;, &#x60;completed&#x60;, or &#x60;canceled&#x60;.
 */
@JsonAdapter(WhatsappMessageOrderStatusEnum.Adapter.class)
public enum WhatsappMessageOrderStatusEnum {
  
  PENDING("pending"),
  
  PROCESSING("processing"),
  
  PARTIALLY_SHIPPED("partially_shipped"),
  
  SHIPPED("shipped"),
  
  COMPLETED("completed"),
  
  CANCELED("canceled");

  private String value;

  WhatsappMessageOrderStatusEnum(String value) {
    this.value = value;
  }

  public String getValue() {
    return value;
  }

  @Override
  public String toString() {
    return String.valueOf(value);
  }

  public static WhatsappMessageOrderStatusEnum fromValue(String value) {
    for (WhatsappMessageOrderStatusEnum b : WhatsappMessageOrderStatusEnum.values()) {
      if (b.value.equals(value)) {
        return b;
      }
    }
    return null;
  }

  public static class Adapter extends TypeAdapter<WhatsappMessageOrderStatusEnum> {
    @Override
    public void write(final JsonWriter jsonWriter, final WhatsappMessageOrderStatusEnum enumeration) throws IOException {
      jsonWriter.value(enumeration.getValue());
    }

    @Override
    public WhatsappMessageOrderStatusEnum read(final JsonReader jsonReader) throws IOException {
      String value = jsonReader.nextString();
      return WhatsappMessageOrderStatusEnum.fromValue(value);
    }
  }
}

