/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.model.WhatsappMessageOrderDetails;
import com.ycloud.client.model.WhatsappMessageTemplateComponentParameterActionSection;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * Required if template uses catalog or MPM (multi-product message) buttons.
 */
@ApiModel(description = "Required if template uses catalog or MPM (multi-product message) buttons.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class WhatsappMessageTemplateComponentParameterAction {
  public static final String SERIALIZED_NAME_THUMBNAIL_PRODUCT_RETAILER_ID = "thumbnail_product_retailer_id";
  /**
   * **Optional.** Use for catalog and MPM template messages. Item SKU number. Labeled as Content ID in the Commerce Manager. The thumbnail of this item will be used as the message&#39;s header image. If the &#x60;parameters&#x60; object is omitted, the product image of the first item in your catalog will be used.
  **/
  @SerializedName(SERIALIZED_NAME_THUMBNAIL_PRODUCT_RETAILER_ID)
  private String thumbnailProductRetailerId;

  public static final String SERIALIZED_NAME_SECTIONS = "sections";
  /**
   * Use for MPM templates. Product sections. You can define up to 10 sections.
  **/
  @SerializedName(SERIALIZED_NAME_SECTIONS)
  private List<WhatsappMessageTemplateComponentParameterActionSection> sections = null;

  public static final String SERIALIZED_NAME_FLOW_TOKEN = "flow_token";
  /**
   * Use for &#x60;FLOW&#x60; buttons. Flow token that is generated by the business to serve as an identifier. Defaults to &#x60;unused&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_FLOW_TOKEN)
  private String flowToken;

  public static final String SERIALIZED_NAME_FLOW_ACTION_DATA = "flow_action_data";
  /**
   * Use for &#x60;FLOW&#x60; buttons. JSON object with the data payload for the first screen.
  **/
  @SerializedName(SERIALIZED_NAME_FLOW_ACTION_DATA)
  private Map<String, Object> flowActionData = null;

  public static final String SERIALIZED_NAME_ORDER_DETAILS = "order_details";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_ORDER_DETAILS)
  private WhatsappMessageOrderDetails orderDetails;

  public WhatsappMessageTemplateComponentParameterAction() { 
  }

  public WhatsappMessageTemplateComponentParameterAction thumbnailProductRetailerId(String thumbnailProductRetailerId) {
    
    this.thumbnailProductRetailerId = thumbnailProductRetailerId;
    return this;
  }

   /**
   * **Optional.** Use for catalog and MPM template messages. Item SKU number. Labeled as Content ID in the Commerce Manager. The thumbnail of this item will be used as the message&#39;s header image. If the &#x60;parameters&#x60; object is omitted, the product image of the first item in your catalog will be used.
   * @return thumbnailProductRetailerId
  **/
  @javax.annotation.Nullable

  public String getThumbnailProductRetailerId() {
    return thumbnailProductRetailerId;
  }


  /**
   * **Optional.** Use for catalog and MPM template messages. Item SKU number. Labeled as Content ID in the Commerce Manager. The thumbnail of this item will be used as the message&#39;s header image. If the &#x60;parameters&#x60; object is omitted, the product image of the first item in your catalog will be used.
   **/
  @ApiModelProperty(example = "2lc20305pt", value = "**Optional.** Use for catalog and MPM template messages. Item SKU number. Labeled as Content ID in the Commerce Manager. The thumbnail of this item will be used as the message's header image. If the `parameters` object is omitted, the product image of the first item in your catalog will be used.")
  public void setThumbnailProductRetailerId(String thumbnailProductRetailerId) {
    this.thumbnailProductRetailerId = thumbnailProductRetailerId;
  }


  public WhatsappMessageTemplateComponentParameterAction sections(List<WhatsappMessageTemplateComponentParameterActionSection> sections) {
    
    this.sections = sections;
    return this;
  }

  public WhatsappMessageTemplateComponentParameterAction addSectionsItem(WhatsappMessageTemplateComponentParameterActionSection sectionsItem) {
    if (this.sections == null) {
      this.sections = new ArrayList<>();
    }
    this.sections.add(sectionsItem);
    return this;
  }

   /**
   * Use for MPM templates. Product sections. You can define up to 10 sections.
   * @return sections
  **/
  @javax.annotation.Nullable

  public List<WhatsappMessageTemplateComponentParameterActionSection> getSections() {
    return sections;
  }


  /**
   * Use for MPM templates. Product sections. You can define up to 10 sections.
   **/
  @ApiModelProperty(value = "Use for MPM templates. Product sections. You can define up to 10 sections.")
  public void setSections(List<WhatsappMessageTemplateComponentParameterActionSection> sections) {
    this.sections = sections;
  }


  public WhatsappMessageTemplateComponentParameterAction flowToken(String flowToken) {
    
    this.flowToken = flowToken;
    return this;
  }

   /**
   * Use for &#x60;FLOW&#x60; buttons. Flow token that is generated by the business to serve as an identifier. Defaults to &#x60;unused&#x60;.
   * @return flowToken
  **/
  @javax.annotation.Nullable

  public String getFlowToken() {
    return flowToken;
  }


  /**
   * Use for &#x60;FLOW&#x60; buttons. Flow token that is generated by the business to serve as an identifier. Defaults to &#x60;unused&#x60;.
   **/
  @ApiModelProperty(value = "Use for `FLOW` buttons. Flow token that is generated by the business to serve as an identifier. Defaults to `unused`.")
  public void setFlowToken(String flowToken) {
    this.flowToken = flowToken;
  }


  public WhatsappMessageTemplateComponentParameterAction flowActionData(Map<String, Object> flowActionData) {
    
    this.flowActionData = flowActionData;
    return this;
  }

  public WhatsappMessageTemplateComponentParameterAction putFlowActionDataItem(String key, Object flowActionDataItem) {
    if (this.flowActionData == null) {
      this.flowActionData = new HashMap<>();
    }
    this.flowActionData.put(key, flowActionDataItem);
    return this;
  }

   /**
   * Use for &#x60;FLOW&#x60; buttons. JSON object with the data payload for the first screen.
   * @return flowActionData
  **/
  @javax.annotation.Nullable

  public Map<String, Object> getFlowActionData() {
    return flowActionData;
  }


  /**
   * Use for &#x60;FLOW&#x60; buttons. JSON object with the data payload for the first screen.
   **/
  @ApiModelProperty(value = "Use for `FLOW` buttons. JSON object with the data payload for the first screen.")
  public void setFlowActionData(Map<String, Object> flowActionData) {
    this.flowActionData = flowActionData;
  }


  public WhatsappMessageTemplateComponentParameterAction orderDetails(WhatsappMessageOrderDetails orderDetails) {
    
    this.orderDetails = orderDetails;
    return this;
  }

   /**
   * Get orderDetails
   * @return orderDetails
  **/
  @javax.annotation.Nullable

  public WhatsappMessageOrderDetails getOrderDetails() {
    return orderDetails;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setOrderDetails(WhatsappMessageOrderDetails orderDetails) {
    this.orderDetails = orderDetails;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public WhatsappMessageTemplateComponentParameterAction putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsappMessageTemplateComponentParameterAction whatsappMessageTemplateComponentParameterAction = (WhatsappMessageTemplateComponentParameterAction) o;
    return Objects.equals(this.thumbnailProductRetailerId, whatsappMessageTemplateComponentParameterAction.thumbnailProductRetailerId) &&
        Objects.equals(this.sections, whatsappMessageTemplateComponentParameterAction.sections) &&
        Objects.equals(this.flowToken, whatsappMessageTemplateComponentParameterAction.flowToken) &&
        Objects.equals(this.flowActionData, whatsappMessageTemplateComponentParameterAction.flowActionData) &&
        Objects.equals(this.orderDetails, whatsappMessageTemplateComponentParameterAction.orderDetails)&&
        Objects.equals(this.additionalProperties, whatsappMessageTemplateComponentParameterAction.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(thumbnailProductRetailerId, sections, flowToken, flowActionData, orderDetails, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsappMessageTemplateComponentParameterAction {\n");
    sb.append("    thumbnailProductRetailerId: ").append(toIndentedString(thumbnailProductRetailerId)).append("\n");
    sb.append("    sections: ").append(toIndentedString(sections)).append("\n");
    sb.append("    flowToken: ").append(toIndentedString(flowToken)).append("\n");
    sb.append("    flowActionData: ").append(toIndentedString(flowActionData)).append("\n");
    sb.append("    orderDetails: ").append(toIndentedString(orderDetails)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("thumbnail_product_retailer_id");
    openapiFields.add("sections");
    openapiFields.add("flow_token");
    openapiFields.add("flow_action_data");
    openapiFields.add("order_details");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to WhatsappMessageTemplateComponentParameterAction
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (WhatsappMessageTemplateComponentParameterAction.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappMessageTemplateComponentParameterAction is not found in the empty JSON string", WhatsappMessageTemplateComponentParameterAction.openapiRequiredFields.toString()));
        }
      }
      if (jsonObj.get("thumbnail_product_retailer_id") != null && !jsonObj.get("thumbnail_product_retailer_id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `thumbnail_product_retailer_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("thumbnail_product_retailer_id").toString()));
      }
      JsonArray jsonArraysections = jsonObj.getAsJsonArray("sections");
      if (jsonArraysections != null) {
        // ensure the json data is an array
        if (!jsonObj.get("sections").isJsonArray()) {
          throw new IllegalArgumentException(String.format("Expected the field `sections` to be an array in the JSON string but got `%s`", jsonObj.get("sections").toString()));
        }

        // validate the optional field `sections` (array)
        for (int i = 0; i < jsonArraysections.size(); i++) {
          WhatsappMessageTemplateComponentParameterActionSection.validateJsonObject(jsonArraysections.get(i).getAsJsonObject());
        };
      }
      if (jsonObj.get("flow_token") != null && !jsonObj.get("flow_token").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `flow_token` to be a primitive type in the JSON string but got `%s`", jsonObj.get("flow_token").toString()));
      }
      // validate the optional field `order_details`
      if (jsonObj.getAsJsonObject("order_details") != null) {
        WhatsappMessageOrderDetails.validateJsonObject(jsonObj.getAsJsonObject("order_details"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!WhatsappMessageTemplateComponentParameterAction.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'WhatsappMessageTemplateComponentParameterAction' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<WhatsappMessageTemplateComponentParameterAction> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(WhatsappMessageTemplateComponentParameterAction.class));

       return (TypeAdapter<T>) new TypeAdapter<WhatsappMessageTemplateComponentParameterAction>() {
           @Override
           public void write(JsonWriter out, WhatsappMessageTemplateComponentParameterAction value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public WhatsappMessageTemplateComponentParameterAction read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             WhatsappMessageTemplateComponentParameterAction instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of WhatsappMessageTemplateComponentParameterAction given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of WhatsappMessageTemplateComponentParameterAction
  * @throws IOException if the JSON string is invalid with respect to WhatsappMessageTemplateComponentParameterAction
  */
  public static WhatsappMessageTemplateComponentParameterAction fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, WhatsappMessageTemplateComponentParameterAction.class);
  }

 /**
  * Convert an instance of WhatsappMessageTemplateComponentParameterAction to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

