/*
 * YCloud API
 * The [YCloud](https://ycloud.com) API is organized around [REST](https://en.wikipedia.org/wiki/Representational_state_transfer). Our API is designed to have predictable, resource-oriented URLs, return [JSON](https://www.json.org) responses, and use standard HTTP response codes and verbs.
 *
 * The version of the OpenAPI document: v2
 * Contact: service@ycloud.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.ycloud.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.ycloud.client.model.WhatsappMessageOrderAmount;
import com.ycloud.client.model.WhatsappPaymentTransactionError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import com.ycloud.client.JSON;

/**
 * Represents a transaction attempt for a payment.
 */
@ApiModel(description = "Represents a transaction attempt for a payment.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class WhatsappPaymentTransaction {
  public static final String SERIALIZED_NAME_ID = "id";
  /**
   * Transaction ID.
  **/
  @SerializedName(SERIALIZED_NAME_ID)
  private String id;

  /**
   * The payment type for this transactions. One of &#x60;billdesk&#x60;, &#x60;razorpay&#x60;, &#x60;payu&#x60;, or &#x60;zaakpay&#x60;.
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    BILLDESK("billdesk"),
    
    RAZORPAY("razorpay"),
    
    PAYU("payu"),
    
    ZAAKPAY("zaakpay");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  /**
   * The payment type for this transactions. One of &#x60;billdesk&#x60;, &#x60;razorpay&#x60;, &#x60;payu&#x60;, or &#x60;zaakpay&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  /**
   * The status of the transaction. One of &#x60;pending&#x60;, &#x60;success&#x60; or &#x60;failed&#x60;.
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    PENDING("pending"),
    
    SUCCESS("success"),
    
    FAILED("failed");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StatusEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_STATUS = "status";
  /**
   * The status of the transaction. One of &#x60;pending&#x60;, &#x60;success&#x60; or &#x60;failed&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_STATUS)
  private StatusEnum status;

  public static final String SERIALIZED_NAME_CREATED_TIMESTAMP = "createdTimestamp";
  /**
   * Time when transaction was created in epoch milliseconds.
  **/
  @SerializedName(SERIALIZED_NAME_CREATED_TIMESTAMP)
  private Long createdTimestamp;

  public static final String SERIALIZED_NAME_UPDATED_TIMESTAMP = "updatedTimestamp";
  /**
   * Time when transaction was last updated in epoch milliseconds.
  **/
  @SerializedName(SERIALIZED_NAME_UPDATED_TIMESTAMP)
  private Long updatedTimestamp;

  public static final String SERIALIZED_NAME_AMOUNT = "amount";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_AMOUNT)
  private WhatsappMessageOrderAmount amount;

  public static final String SERIALIZED_NAME_CURRENCY = "currency";
  /**
   * The currency for this payment. Currently the only supported value is &#x60;INR&#x60;.
  **/
  @SerializedName(SERIALIZED_NAME_CURRENCY)
  private String currency;

  public static final String SERIALIZED_NAME_METHOD_TYPE = "methodType";
  /**
   * Describes the type of payment method used by consumer to pay for the order. Can be one of &#x60;upi&#x60;, &#x60;card&#x60;, &#x60;wallet&#x60;, or &#x60;netbanking&#x60;. The payment method information might not be available for failed payments.
  **/
  @SerializedName(SERIALIZED_NAME_METHOD_TYPE)
  private String methodType;

  public static final String SERIALIZED_NAME_ERROR = "error";
  /**
  **/
  @SerializedName(SERIALIZED_NAME_ERROR)
  private WhatsappPaymentTransactionError error;

  public WhatsappPaymentTransaction() { 
  }

  public WhatsappPaymentTransaction id(String id) {
    
    this.id = id;
    return this;
  }

   /**
   * Transaction ID.
   * @return id
  **/
  @javax.annotation.Nonnull

  public String getId() {
    return id;
  }


  /**
   * Transaction ID.
   **/
  @ApiModelProperty(required = true, value = "Transaction ID.")
  public void setId(String id) {
    this.id = id;
  }


  public WhatsappPaymentTransaction type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * The payment type for this transactions. One of &#x60;billdesk&#x60;, &#x60;razorpay&#x60;, &#x60;payu&#x60;, or &#x60;zaakpay&#x60;.
   * @return type
  **/
  @javax.annotation.Nonnull

  public TypeEnum getType() {
    return type;
  }


  /**
   * The payment type for this transactions. One of &#x60;billdesk&#x60;, &#x60;razorpay&#x60;, &#x60;payu&#x60;, or &#x60;zaakpay&#x60;.
   **/
  @ApiModelProperty(required = true, value = "The payment type for this transactions. One of `billdesk`, `razorpay`, `payu`, or `zaakpay`.")
  public void setType(TypeEnum type) {
    this.type = type;
  }


  public WhatsappPaymentTransaction status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * The status of the transaction. One of &#x60;pending&#x60;, &#x60;success&#x60; or &#x60;failed&#x60;.
   * @return status
  **/
  @javax.annotation.Nonnull

  public StatusEnum getStatus() {
    return status;
  }


  /**
   * The status of the transaction. One of &#x60;pending&#x60;, &#x60;success&#x60; or &#x60;failed&#x60;.
   **/
  @ApiModelProperty(required = true, value = "The status of the transaction. One of `pending`, `success` or `failed`.")
  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public WhatsappPaymentTransaction createdTimestamp(Long createdTimestamp) {
    
    this.createdTimestamp = createdTimestamp;
    return this;
  }

   /**
   * Time when transaction was created in epoch milliseconds.
   * @return createdTimestamp
  **/
  @javax.annotation.Nonnull

  public Long getCreatedTimestamp() {
    return createdTimestamp;
  }


  /**
   * Time when transaction was created in epoch milliseconds.
   **/
  @ApiModelProperty(required = true, value = "Time when transaction was created in epoch milliseconds.")
  public void setCreatedTimestamp(Long createdTimestamp) {
    this.createdTimestamp = createdTimestamp;
  }


  public WhatsappPaymentTransaction updatedTimestamp(Long updatedTimestamp) {
    
    this.updatedTimestamp = updatedTimestamp;
    return this;
  }

   /**
   * Time when transaction was last updated in epoch milliseconds.
   * @return updatedTimestamp
  **/
  @javax.annotation.Nonnull

  public Long getUpdatedTimestamp() {
    return updatedTimestamp;
  }


  /**
   * Time when transaction was last updated in epoch milliseconds.
   **/
  @ApiModelProperty(required = true, value = "Time when transaction was last updated in epoch milliseconds.")
  public void setUpdatedTimestamp(Long updatedTimestamp) {
    this.updatedTimestamp = updatedTimestamp;
  }


  public WhatsappPaymentTransaction amount(WhatsappMessageOrderAmount amount) {
    
    this.amount = amount;
    return this;
  }

   /**
   * Get amount
   * @return amount
  **/
  @javax.annotation.Nonnull

  public WhatsappMessageOrderAmount getAmount() {
    return amount;
  }


  /**
   **/
  @ApiModelProperty(required = true, value = "")
  public void setAmount(WhatsappMessageOrderAmount amount) {
    this.amount = amount;
  }


  public WhatsappPaymentTransaction currency(String currency) {
    
    this.currency = currency;
    return this;
  }

   /**
   * The currency for this payment. Currently the only supported value is &#x60;INR&#x60;.
   * @return currency
  **/
  @javax.annotation.Nonnull

  public String getCurrency() {
    return currency;
  }


  /**
   * The currency for this payment. Currently the only supported value is &#x60;INR&#x60;.
   **/
  @ApiModelProperty(required = true, value = "The currency for this payment. Currently the only supported value is `INR`.")
  public void setCurrency(String currency) {
    this.currency = currency;
  }


  public WhatsappPaymentTransaction methodType(String methodType) {
    
    this.methodType = methodType;
    return this;
  }

   /**
   * Describes the type of payment method used by consumer to pay for the order. Can be one of &#x60;upi&#x60;, &#x60;card&#x60;, &#x60;wallet&#x60;, or &#x60;netbanking&#x60;. The payment method information might not be available for failed payments.
   * @return methodType
  **/
  @javax.annotation.Nullable

  public String getMethodType() {
    return methodType;
  }


  /**
   * Describes the type of payment method used by consumer to pay for the order. Can be one of &#x60;upi&#x60;, &#x60;card&#x60;, &#x60;wallet&#x60;, or &#x60;netbanking&#x60;. The payment method information might not be available for failed payments.
   **/
  @ApiModelProperty(example = "upi", value = "Describes the type of payment method used by consumer to pay for the order. Can be one of `upi`, `card`, `wallet`, or `netbanking`. The payment method information might not be available for failed payments.")
  public void setMethodType(String methodType) {
    this.methodType = methodType;
  }


  public WhatsappPaymentTransaction error(WhatsappPaymentTransactionError error) {
    
    this.error = error;
    return this;
  }

   /**
   * Get error
   * @return error
  **/
  @javax.annotation.Nullable

  public WhatsappPaymentTransactionError getError() {
    return error;
  }


  /**
   **/
  @ApiModelProperty(value = "")
  public void setError(WhatsappPaymentTransactionError error) {
    this.error = error;
  }

  /**
   * A container for additional, undeclared properties.
   * This is a holder for any undeclared properties as specified with
   * the 'additionalProperties' keyword in the OAS document.
   */
  private Map<String, Object> additionalProperties;

  /**
   * Set the additional (undeclared) property with the specified name and value.
   * If the property does not already exist, create it otherwise replace it.
   */
  public WhatsappPaymentTransaction putAdditionalProperty(String key, Object value) {
    if (this.additionalProperties == null) {
        this.additionalProperties = new HashMap<String, Object>();
    }
    this.additionalProperties.put(key, value);
    return this;
  }

  /**
   * Return the additional (undeclared) property.
   */
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  /**
   * Return the additional (undeclared) property with the specified name.
   */
  public Object getAdditionalProperty(String key) {
    if (this.additionalProperties == null) {
        return null;
    }
    return this.additionalProperties.get(key);
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WhatsappPaymentTransaction whatsappPaymentTransaction = (WhatsappPaymentTransaction) o;
    return Objects.equals(this.id, whatsappPaymentTransaction.id) &&
        Objects.equals(this.type, whatsappPaymentTransaction.type) &&
        Objects.equals(this.status, whatsappPaymentTransaction.status) &&
        Objects.equals(this.createdTimestamp, whatsappPaymentTransaction.createdTimestamp) &&
        Objects.equals(this.updatedTimestamp, whatsappPaymentTransaction.updatedTimestamp) &&
        Objects.equals(this.amount, whatsappPaymentTransaction.amount) &&
        Objects.equals(this.currency, whatsappPaymentTransaction.currency) &&
        Objects.equals(this.methodType, whatsappPaymentTransaction.methodType) &&
        Objects.equals(this.error, whatsappPaymentTransaction.error)&&
        Objects.equals(this.additionalProperties, whatsappPaymentTransaction.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, type, status, createdTimestamp, updatedTimestamp, amount, currency, methodType, error, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WhatsappPaymentTransaction {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    createdTimestamp: ").append(toIndentedString(createdTimestamp)).append("\n");
    sb.append("    updatedTimestamp: ").append(toIndentedString(updatedTimestamp)).append("\n");
    sb.append("    amount: ").append(toIndentedString(amount)).append("\n");
    sb.append("    currency: ").append(toIndentedString(currency)).append("\n");
    sb.append("    methodType: ").append(toIndentedString(methodType)).append("\n");
    sb.append("    error: ").append(toIndentedString(error)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("id");
    openapiFields.add("type");
    openapiFields.add("status");
    openapiFields.add("createdTimestamp");
    openapiFields.add("updatedTimestamp");
    openapiFields.add("amount");
    openapiFields.add("currency");
    openapiFields.add("methodType");
    openapiFields.add("error");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
    openapiRequiredFields.add("id");
    openapiRequiredFields.add("type");
    openapiRequiredFields.add("status");
    openapiRequiredFields.add("createdTimestamp");
    openapiRequiredFields.add("updatedTimestamp");
    openapiRequiredFields.add("amount");
    openapiRequiredFields.add("currency");
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to WhatsappPaymentTransaction
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (WhatsappPaymentTransaction.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in WhatsappPaymentTransaction is not found in the empty JSON string", WhatsappPaymentTransaction.openapiRequiredFields.toString()));
        }
      }

      // check to make sure all required properties/fields are present in the JSON string
      for (String requiredField : WhatsappPaymentTransaction.openapiRequiredFields) {
        if (jsonObj.get(requiredField) == null) {
          throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
      }
      if (jsonObj.get("id") != null && !jsonObj.get("id").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get("id").toString()));
      }
      if (jsonObj.get("type") != null && !jsonObj.get("type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("type").toString()));
      }
      if (jsonObj.get("status") != null && !jsonObj.get("status").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get("status").toString()));
      }
      // validate the optional field `amount`
      if (jsonObj.getAsJsonObject("amount") != null) {
        WhatsappMessageOrderAmount.validateJsonObject(jsonObj.getAsJsonObject("amount"));
      }
      if (jsonObj.get("currency") != null && !jsonObj.get("currency").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `currency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("currency").toString()));
      }
      if (jsonObj.get("methodType") != null && !jsonObj.get("methodType").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `methodType` to be a primitive type in the JSON string but got `%s`", jsonObj.get("methodType").toString()));
      }
      // validate the optional field `error`
      if (jsonObj.getAsJsonObject("error") != null) {
        WhatsappPaymentTransactionError.validateJsonObject(jsonObj.getAsJsonObject("error"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!WhatsappPaymentTransaction.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'WhatsappPaymentTransaction' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<WhatsappPaymentTransaction> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(WhatsappPaymentTransaction.class));

       return (TypeAdapter<T>) new TypeAdapter<WhatsappPaymentTransaction>() {
           @Override
           public void write(JsonWriter out, WhatsappPaymentTransaction value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             obj.remove("additionalProperties");
             // serialize additonal properties
             if (value.getAdditionalProperties() != null) {
               for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                 if (entry.getValue() instanceof String)
                   obj.addProperty(entry.getKey(), (String) entry.getValue());
                 else if (entry.getValue() instanceof Number)
                   obj.addProperty(entry.getKey(), (Number) entry.getValue());
                 else if (entry.getValue() instanceof Boolean)
                   obj.addProperty(entry.getKey(), (Boolean) entry.getValue());
                 else if (entry.getValue() instanceof Character)
                   obj.addProperty(entry.getKey(), (Character) entry.getValue());
                 else {
                   obj.add(entry.getKey(), gson.toJsonTree(entry.getValue()).getAsJsonObject());
                 }
               }
             }
             elementAdapter.write(out, obj);
           }

           @Override
           public WhatsappPaymentTransaction read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             // store additional fields in the deserialized instance
             WhatsappPaymentTransaction instance = thisAdapter.fromJsonTree(jsonObj);
             for (Map.Entry<String, JsonElement> entry : jsonObj.entrySet()) {
               if (!openapiFields.contains(entry.getKey())) {
                 if (entry.getValue().isJsonPrimitive()) { // primitive type
                   if (entry.getValue().getAsJsonPrimitive().isString())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsString());
                   else if (entry.getValue().getAsJsonPrimitive().isNumber())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsNumber());
                   else if (entry.getValue().getAsJsonPrimitive().isBoolean())
                     instance.putAdditionalProperty(entry.getKey(), entry.getValue().getAsBoolean());
                   else
                     throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), entry.getValue().toString()));
                 } else { // non-primitive type
                   instance.putAdditionalProperty(entry.getKey(), gson.fromJson(entry.getValue(), HashMap.class));
                 }
               }
             }
             return instance;
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of WhatsappPaymentTransaction given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of WhatsappPaymentTransaction
  * @throws IOException if the JSON string is invalid with respect to WhatsappPaymentTransaction
  */
  public static WhatsappPaymentTransaction fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, WhatsappPaymentTransaction.class);
  }

 /**
  * Convert an instance of WhatsappPaymentTransaction to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

